/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jubula.client.core.businessprocess.CalcTypes;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class BasicCompNameCache
implements IWritableComponentNameCache {
    private Map<String, IComponentNamePO> m_localChanges = new HashMap<String, IComponentNamePO>();
    private Map<String, ProblemType> m_localProblems = null;
    private IPersistentObject m_context;

    public BasicCompNameCache(IPersistentObject context) {
        this.m_context = context;
    }

    @Override
    public void addCompNamePO(IComponentNamePO compNamePo) {
        if (compNamePo != null) {
            this.m_localChanges.put(compNamePo.getGuid(), compNamePo);
        }
    }

    @Override
    public final void updateStandardMapperAndCleanup(Long projectId) {
        try {
            CompNameManager.getInstance().refreshNames(projectId);
            this.clear();
        }
        catch (PMException e) {
            throw new JBFatalException(String.valueOf(Messages.ReadingComponentNamesFailed) + "!", (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
        }
    }

    @Override
    public String getGuidForName(String name) {
        for (IComponentNamePO cN : this.m_localChanges.values()) {
            if (!cN.getName().equals(name)) continue;
            return cN.getGuid();
        }
        return CompNameManager.getInstance().getGuidForName(name);
    }

    @Override
    public String getGuidForName(String name, Long parentProjectId) {
        IProjectPO currentProject;
        Long parentProjectIdToUse = parentProjectId;
        if (parentProjectIdToUse == null && (currentProject = GeneralStorage.getInstance().getProject()) != null) {
            parentProjectIdToUse = currentProject.getId();
        }
        if (parentProjectIdToUse == null) {
            return null;
        }
        for (IComponentNamePO cN : this.m_localChanges.values()) {
            if (!cN.getName().equals(name) || !parentProjectIdToUse.equals(cN.getParentProjectId())) continue;
            return cN.getGuid();
        }
        return CompNameManager.getInstance().getGuidForName(name, parentProjectIdToUse);
    }

    @Override
    public IComponentNamePO createComponentNamePO(String name, String type, ComponentNamesBP.CompNameCreationContext creationContext) {
        return this.createComponentNamePO(null, name, type, creationContext);
    }

    @Override
    public IComponentNamePO createComponentNamePO(String guid, String name, String type, ComponentNamesBP.CompNameCreationContext creationContext) {
        String nameGuid = guid;
        if (guid == null) {
            nameGuid = PersistenceUtil.generateUUID();
        }
        IComponentNamePO newComponentNamePO = CompNameManager.getInstance().createCompNamePO(nameGuid, name, type, creationContext);
        newComponentNamePO.setParentProjectId(GeneralStorage.getInstance().getProject().getId());
        this.addCompNamePO(newComponentNamePO);
        return newComponentNamePO;
    }

    @Override
    public void renameComponentName(String guid, String newName) {
        IComponentNamePO cN = this.m_localChanges.get(guid);
        if (cN != null) {
            cN.setName(newName);
            return;
        }
        cN = PoMaker.cloneCompName(this.getResCompNamePOByGuid(guid));
        this.m_localChanges.put(guid, cN);
        cN.setName(newName);
    }

    @Override
    public void clear() {
        this.m_localChanges.clear();
    }

    @Override
    public IComponentNamePO getResCompNamePOByGuid(String guid) {
        IComponentNamePO res = this.m_localChanges.get(guid);
        if (res != null && res.getReferencedGuid() == null) {
            return res;
        }
        return CompNameManager.getInstance().getResCompNamePOByGuid(guid);
    }

    @Override
    public String getNameByGuid(String guid) {
        IComponentNamePO compNamePo = this.getResCompNamePOByGuid(guid);
        String retVal = compNamePo != null ? compNamePo.getName() : CompNameManager.getInstance().getNameByGuid(guid);
        return retVal;
    }

    @Override
    public Collection<IComponentNamePO> getAllCompNamePOs() {
        HashSet<IComponentNamePO> compNames = new HashSet<IComponentNamePO>();
        compNames.addAll(this.m_localChanges.values());
        compNames.addAll(CompNameManager.getInstance().getAllCompNamePOs());
        return compNames;
    }

    @Override
    public Map<String, IComponentNamePO> getLocalChanges() {
        return this.m_localChanges;
    }

    @Override
    public void removeCompName(String guid) {
        this.m_localChanges.remove(guid);
    }

    @Override
    public void renamedCompName(String guid, String newName) {
        IComponentNamePO cN = this.m_localChanges.get(guid);
        if (cN != null) {
            cN.setName(newName);
        }
    }

    @Override
    public void addIfNotYetPresent(String guid) {
        IComponentNamePO cN;
        if (!this.m_localChanges.containsKey(guid) && (cN = this.getResCompNamePOByGuid(guid)) != null) {
            this.addCompNamePO(PoMaker.cloneCompName(cN));
        }
    }

    @Override
    public void clearUnusedCompNames(INodePO node) {
        HashSet<String> usedGuids = new HashSet<String>();
        Iterator<Object> it = node.getAllNodeIter();
        while (it.hasNext()) {
            INodePO next = it.next();
            if (next instanceof ICapPO) {
                usedGuids.add(((ICapPO)next).getComponentName());
                continue;
            }
            if (!(next instanceof IExecTestCasePO)) continue;
            for (ICompNamesPairPO pair : ((IExecTestCasePO)next).getCompNamesPairs()) {
                usedGuids.add(pair.getSecondName());
            }
        }
        it = this.m_localChanges.keySet().iterator();
        while (it.hasNext()) {
            String guid = (String)it.next();
            if (usedGuids.contains(guid)) continue;
            it.remove();
        }
    }

    @Override
    public void storeLocalProblems(CalcTypes calc) {
        this.m_localProblems = calc.getAllProblems();
        calc.writeLocalTypes();
    }

    @Override
    public Map<String, ProblemType> getNewProblems(CalcTypes calc) {
        Map<String, ProblemType> problems = calc.getAllProblems();
        if (this.m_localProblems == null) {
            this.m_localProblems = CompNameManager.getInstance().getTypeProblems();
        }
        Map<String, ProblemType> locProbs = this.m_localProblems;
        HashMap<String, ProblemType> newProblems = new HashMap<String, ProblemType>();
        for (String guid : problems.keySet()) {
            if (problems.get(guid).equals((Object)locProbs.get(guid))) continue;
            newProblems.put(guid, problems.get(guid));
        }
        return newProblems;
    }

    @Override
    public void changeReuse(IComponentNameReuser user, String oldGuid, String newGuid) {
        if (user == null) {
            return;
        }
        user.changeCompName(oldGuid, newGuid);
        if (newGuid != null) {
            this.addIfNotYetPresent(newGuid);
        }
    }

    public IPersistentObject getContext() {
        return this.m_context;
    }

    @Override
    public void handleExistingNames(Map<String, String> guidToCompNameMap) {
    }

    @Override
    public void setContext(IPersistentObject context) {
        this.m_context = context;
    }
}

