/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.internal.ketch.KetchPreReceive;
import org.eclipse.jgit.internal.ketch.KetchSystem;
import org.eclipse.jgit.internal.ketch.KetchText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.DaemonClient;
import org.eclipse.jgit.transport.DaemonService;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.resolver.FileResolver;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_exportRepositoriesOverGit")
class Daemon
extends TextBuiltin {
    @Option(name="--config-file", metaVar="metaVar_configFile", usage="usage_configFile")
    File configFile;
    @Option(name="--port", metaVar="metaVar_port", usage="usage_portNumberToListenOn")
    int port = 9418;
    @Option(name="--listen", metaVar="metaVar_hostName", usage="usage_hostnameOrIpToListenOn")
    String host;
    @Option(name="--timeout", metaVar="metaVar_seconds", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Option(name="--enable", metaVar="metaVar_service", usage="usage_enableTheServiceInAllRepositories")
    List<String> enable = new ArrayList<String>();
    @Option(name="--disable", metaVar="metaVar_service", usage="usage_disableTheServiceInAllRepositories")
    List<String> disable = new ArrayList<String>();
    @Option(name="--allow-override", metaVar="metaVar_service", usage="usage_configureTheServiceInDaemonServicename")
    List<String> canOverride = new ArrayList<String>();
    @Option(name="--forbid-override", metaVar="metaVar_service", usage="usage_configureTheServiceInDaemonServicename")
    List<String> forbidOverride = new ArrayList<String>();
    @Option(name="--export-all", usage="usage_exportWithoutGitDaemonExportOk")
    boolean exportAll;
    @Option(name="--ketch", metaVar="metaVar_ketchServerType", usage="usage_ketchServerType")
    KetchServerType ketchServerType;
    @Argument(required=true, metaVar="metaVar_directory", usage="usage_directoriesToExport")
    List<File> directory = new ArrayList<File>();

    Daemon() {
    }

    @Override
    protected boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        int threads;
        PackConfig packConfig = new PackConfig();
        if (this.configFile != null) {
            if (!this.configFile.exists()) {
                throw Daemon.die(MessageFormat.format(CLIText.get().configFileNotFound, this.configFile.getAbsolutePath()));
            }
            FileBasedConfig cfg = new FileBasedConfig(this.configFile, FS.DETECTED);
            cfg.load();
            new WindowCacheConfig().fromConfig((Config)cfg).install();
            packConfig.fromConfig((Config)cfg);
        }
        if ((threads = packConfig.getThreads()) <= 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        if (1 < threads) {
            packConfig.setExecutor((Executor)Executors.newFixedThreadPool(threads));
        }
        FileResolver resolver = new FileResolver();
        for (File f : this.directory) {
            this.outw.println(MessageFormat.format(CLIText.get().exporting, f.getAbsolutePath()));
            resolver.exportDirectory(f);
        }
        resolver.setExportAll(this.exportAll);
        org.eclipse.jgit.transport.Daemon d = new org.eclipse.jgit.transport.Daemon(this.host != null ? new InetSocketAddress(this.host, this.port) : new InetSocketAddress(this.port));
        d.setPackConfig(packConfig);
        d.setRepositoryResolver((RepositoryResolver)resolver);
        if (0 <= this.timeout) {
            d.setTimeout(this.timeout);
        }
        for (String n : this.enable) {
            Daemon.service(d, n).setEnabled(true);
        }
        for (String n : this.disable) {
            Daemon.service(d, n).setEnabled(false);
        }
        for (String n : this.canOverride) {
            Daemon.service(d, n).setOverridable(true);
        }
        for (String n : this.forbidOverride) {
            Daemon.service(d, n).setOverridable(false);
        }
        if (this.ketchServerType == KetchServerType.LEADER) {
            this.startKetchLeader(d);
        }
        d.start();
        this.outw.println(MessageFormat.format(CLIText.get().listeningOn, d.getAddress()));
    }

    private static DaemonService service(org.eclipse.jgit.transport.Daemon d, String n) {
        DaemonService svc = d.getService(n);
        if (svc == null) {
            throw Daemon.die(MessageFormat.format(CLIText.get().serviceNotSupported, n));
        }
        return svc;
    }

    private void startKetchLeader(org.eclipse.jgit.transport.Daemon daemon) {
        KetchSystem system = new KetchSystem();
        final KetchLeaderCache leaders = new KetchLeaderCache(system);
        final ReceivePackFactory factory = daemon.getReceivePackFactory();
        daemon.setReceivePackFactory((ReceivePackFactory)new ReceivePackFactory<DaemonClient>(){

            public ReceivePack create(DaemonClient req, Repository repo) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                KetchLeader leader;
                ReceivePack rp = factory.create((Object)req, repo);
                try {
                    leader = leaders.get(repo);
                }
                catch (URISyntaxException err) {
                    throw new ServiceNotEnabledException(KetchText.get().invalidFollowerUri, (Throwable)err);
                }
                rp.setPreReceiveHook((PreReceiveHook)new KetchPreReceive(leader));
                return rp;
            }
        });
    }

    static enum KetchServerType {
        LEADER;

    }
}

