/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import com.google.common.base.Throwables;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.internal.logging.aeri.ide.processors.EditableReportProcessorSafeWrapper;
import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.ide.processors.IEditableReportProcessor;
import org.osgi.framework.Bundle;

public class CreateReportProcessorHandler {
    @Execute
    public ReportProcessorSafeWrapper execute(String providerClass, IEclipseContext context, String contributor) {
        Bundle ext = Platform.getBundle((String)contributor);
        try {
            Class<?> clazz;
            try {
                clazz = ext.loadClass(providerClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.getClass().getClassLoader().loadClass(providerClass);
            }
            IReportProcessor reportProcessor = (IReportProcessor)ContextInjectionFactory.make((Class)clazz, (IEclipseContext)context);
            if (reportProcessor instanceof IEditableReportProcessor) {
                return new EditableReportProcessorSafeWrapper((IEditableReportProcessor)reportProcessor);
            }
            return new ReportProcessorSafeWrapper(reportProcessor);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

