/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.EmfDebugUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.ResourceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;

public final class EditingDomainUtils {
    private EditingDomainUtils() {
    }

    private static EditingDomain createDefaultEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public static void addCommandStackListener(EditingDomain editingDomain, CommandStackListener listener) {
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.addCommandStackListener(listener);
    }

    public static void save(EditingDomain editingDomain, Resource resource) {
        WorkspaceModifyOperation operation = EditingDomainUtils.createSaveOperation(editingDomain, resource);
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        BasicCommandStack commandStack = (BasicCommandStack)editingDomain.getCommandStack();
        commandStack.saveIsDone();
    }

    private static WorkspaceModifyOperation createSaveOperation(final EditingDomain editingDomain, final Resource resource) {
        return new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("USE_FILE_BUFFER", Boolean.TRUE);
                options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                if (resource == null || ResourceUtils.isTmpResource(resource)) {
                    EditingDomainUtils.saveAs(editingDomain, resource);
                }
                for (Resource resourceElt : editingDomain.getResourceSet().getResources()) {
                    if (!EditingDomainUtils.isPersisted(editingDomain, resourceElt) || resourceElt.getContents().isEmpty() || editingDomain.isReadOnly(resourceElt)) continue;
                    try {
                        resourceElt.save(options);
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
            }
        };
    }

    public static void saveAs(EditingDomain editingDomain, Resource resource) {
        SaveAsDialog dialog = new SaveAsDialog(Display.getDefault().getActiveShell());
        dialog.setOriginalName("My.table");
        dialog.open();
        if (dialog.getReturnCode() != 1) {
            URI uri = URI.createPlatformResourceURI((String)dialog.getResult().toString(), (boolean)true);
            if (uri != null) {
                resource.setURI(uri);
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("USE_FILE_BUFFER", Boolean.TRUE);
                try {
                    resource.save(options);
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            if (editingDomain != null) {
                BasicCommandStack commandStack = (BasicCommandStack)editingDomain.getCommandStack();
                commandStack.saveIsDone();
            }
        }
    }

    protected static boolean isPersisted(EditingDomain editingDomain, Resource resourceParam) {
        boolean result;
        try {
            InputStream stream = editingDomain.getResourceSet().getURIConverter().createInputStream(resourceParam.getURI());
            if (stream == null) {
                result = false;
            } else {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }

    public static void executeCommand(Command command, EditingDomain editingDomain) {
        if (command != null) {
            DebugUtils.debug((String)EmfDebugUtils.debugCommand((Command)command));
            if (command.canExecute()) {
                editingDomain.getCommandStack().execute(command);
            } else {
                throw new TableWidgetRuntimeException(EmfDebugUtils.debugCommand((Command)command));
            }
        }
    }

    public static EditingDomain initEditingDomain(IEditingDomainProvider editingDomainP) {
        EditingDomain result = null;
        result = EditingDomainUtils.isEditingDomainProviderNotInitialized(editingDomainP) ? EditingDomainUtils.createDefaultEditingDomain() : editingDomainP.getEditingDomain();
        return result;
    }

    public static boolean isEditingDomainProviderNotInitialized(IEditingDomainProvider editingDomainP) {
        return editingDomainP == null || editingDomainP.getEditingDomain() == null;
    }

    public static String getStringURI(EObject eObject) {
        URI uri = EcoreUtil.getURI((EObject)eObject);
        return uri.toString();
    }
}

