/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.column;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialog;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialogFactory;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.column.ColumnsCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.CustomizationUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetAndCustomCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.EditingDomainUtils;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColumnsAddService {
    private final Table table;
    private final ColumnsCommandFactory columnsCmdFactory;
    private final FacetAndCustomCommandFactory facetCustomCmdF;
    private final EditingDomain editingDomain;

    public ColumnsAddService(Table table, BasicCommandFactory basicCmdFactory) {
        this.table = table;
        this.facetCustomCmdF = new FacetAndCustomCommandFactory(table, basicCmdFactory);
        this.columnsCmdFactory = new ColumnsCommandFactory(table, basicCmdFactory);
        this.editingDomain = basicCmdFactory.getEditingDomain();
    }

    public IETypedElementSelectionDialog<Object> openAddColumnsDialog() {
        List<FacetSet> knownFacetSets = CustomizationUtils.getKnownFacetSetsWithoutCustom(this.table);
        HashSet eTypedElements = new HashSet();
        for (FacetSet facetSet : knownFacetSets) {
            eTypedElements.addAll(FacetUtils.getETypedElements((EPackage)facetSet));
        }
        for (Row row : this.table.getRows()) {
            EObject eObject = row.getElement();
            eTypedElements.addAll(FacetUtils.getETypedElements((EClassifier)eObject.eClass()));
        }
        IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object> callback = new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> result, Object precommitResult) {
                HashSet<FacetSet> facetSets = new HashSet<FacetSet>();
                for (ETypedElement eTypedElement : result) {
                    FacetSet facetSet = FacetUtils.getFacetSet((ETypedElement)eTypedElement);
                    if (facetSet == null) continue;
                    FacetSet rootFacetSet = FacetUtils.getRootFacetSet((FacetSet)facetSet);
                    facetSets.add(rootFacetSet);
                }
                ArrayList<ETypedElement> resolvedTE = new ArrayList<ETypedElement>(result.size());
                for (ETypedElement eTypedElement : result) {
                    ETypedElement resolvedEObject = (ETypedElement)IResolverManager.DEFAULT.resolve((Object)eTypedElement, ETypedElement.class);
                    if (resolvedEObject == null) {
                        resolvedTE.add(eTypedElement);
                        continue;
                    }
                    resolvedTE.add(resolvedEObject);
                }
                ColumnsAddService.this.addColumns(resolvedTE, new ArrayList<FacetSet>(facetSets));
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        };
        ICustomizationManager customManager = CustomizationUtils.getCustomManager((EObject)this.table);
        IETypedElementSelectionDialog dialog = IETypedElementSelectionDialogFactory.DEFAULT.openETypedElementSelectionDialog(eTypedElements, Integer.MAX_VALUE, false, (IDialogCallbackWithPreCommit)callback, Display.getDefault().getActiveShell(), customManager, knownFacetSets);
        return dialog;
    }

    public void addColumns(List<ETypedElement> eTypedElements, List<FacetSet> facetSets) {
        Command signatureFSetCmd = this.facetCustomCmdF.createSignatureFacetSetCommand(eTypedElements, facetSets);
        Command cmd = this.columnsCmdFactory.createAddColumnCommand(eTypedElements, signatureFSetCmd);
        EditingDomainUtils.executeCommand(cmd, this.editingDomain);
    }

    protected Table getTable() {
        return this.table;
    }
}

