/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.dialogs;

import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FinishFeatureDialog
extends TitleAreaDialog {
    private boolean squash;
    private boolean keepBranch;
    private Button squashButton;
    private Button keepBranchButton;
    private String featureBranch;
    private Button rememberOptionsButton;

    public FinishFeatureDialog(Shell parentShell, String featureBranch) {
        super(parentShell);
        this.featureBranch = featureBranch;
    }

    public void create() {
        super.create();
        this.setTitle(UIText.FinishFeatureDialog_title);
        this.getShell().setText(UIText.FinishFeatureDialog_title);
        this.setMessage(NLS.bind((String)UIText.FinishFeatureDialog_setParameterForFinishing, (Object)this.featureBranch), 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.squashButton = new Button(container, 32);
        this.squashButton.setText(UIText.FinishFeatureDialog_squashCheck);
        this.keepBranchButton = new Button(container, 32);
        this.keepBranchButton.setText(UIText.FinishFeatureDialog_keepBranch);
        this.restoreInput();
        return area;
    }

    private void restoreInput() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        this.squashButton.setSelection(prefStore.getBoolean("feature_finish_squash"));
        this.keepBranchButton.setSelection(prefStore.getBoolean("feature_finish_keep_branch"));
    }

    protected Control createButtonBar(Composite parent) {
        Composite customButtonBar = new Composite(parent, 0);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).spacing(horizontalSpacing, 0).applyTo(customButtonBar);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 1024).applyTo((Control)customButtonBar);
        customButtonBar.setFont(parent.getFont());
        this.rememberOptionsButton = new Button(customButtonBar, 32);
        this.rememberOptionsButton.setText(UIText.FinishFeatureDialog_saveAsDefault);
        int horizontlIndent = this.convertHorizontalDLUsToPixels(7);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 0x1000000).indent(horizontlIndent, 0).applyTo((Control)this.rememberOptionsButton);
        Control buttonControl = super.createButtonBar(customButtonBar);
        GridDataFactory.swtDefaults().grab(true, false).align(131072, 0x1000000).applyTo(buttonControl);
        return customButtonBar;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.squash = this.squashButton.getSelection();
        this.keepBranch = this.keepBranchButton.getSelection();
        if (this.rememberOptionsButton.getSelection()) {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            preferenceStore.setValue("feature_finish_squash", this.squashButton.getSelection());
            preferenceStore.setValue("feature_finish_keep_branch", this.keepBranchButton.getSelection());
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public boolean isSquash() {
        return this.squash;
    }

    public boolean isKeepBranch() {
        return this.keepBranch;
    }
}

