/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.DLTKUIException;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ContentAssistHistory {
    private static final RHSHistory EMPTY_HISTORY = new RHSHistory(null);
    private static final int DEFAULT_TRACKED_LHS = 100;
    private static final int DEFAULT_TRACKED_RHS = 10;
    private final LinkedHashMap fLHSCache;
    private final int fMaxLHS;
    private final int fMaxRHS;

    public ContentAssistHistory(int maxLHS, int maxRHS) {
        Assert.isLegal((maxLHS > 0 ? 1 : 0) != 0);
        Assert.isLegal((maxRHS > 0 ? 1 : 0) != 0);
        this.fMaxLHS = maxLHS;
        this.fMaxRHS = maxRHS;
        this.fLHSCache = new MRUMap(this.fMaxLHS);
    }

    public ContentAssistHistory() {
        this(100, 10);
    }

    public void remember(IType lhs, IType rhs) {
        Assert.isLegal((lhs != null ? 1 : 0) != 0);
        Assert.isLegal((rhs != null ? 1 : 0) != 0);
        try {
            if (!this.isCacheableRHS(rhs)) {
                return;
            }
        }
        catch (ModelException x) {
            DLTKUIPlugin.log(x);
        }
    }

    public RHSHistory getHistory(String lhs) {
        MRUSet rhsCache = (MRUSet)this.fLHSCache.get(lhs);
        if (rhsCache != null) {
            int count = rhsCache.size();
            LinkedHashMap<String, Integer> history = new LinkedHashMap<String, Integer>((int)((double)count / 0.75));
            int rank = 1;
            for (String type : rhsCache) {
                history.put(type, rank);
                ++rank;
            }
            return new RHSHistory(history);
        }
        return EMPTY_HISTORY;
    }

    public Map getEntireHistory() {
        HashMap<String, RHSHistory> map = new HashMap<String, RHSHistory>((int)((double)this.fLHSCache.size() / 0.75));
        for (Map.Entry entry : this.fLHSCache.entrySet()) {
            String lhs = (String)entry.getKey();
            map.put(lhs, this.getHistory(lhs));
        }
        return Collections.unmodifiableMap(map);
    }

    private boolean isCacheableRHS(IType type) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("isCachableRHS always return true...");
        }
        return true;
    }

    private Set getCache(String lhs) {
        MRUSet rhsCache = (MRUSet)this.fLHSCache.get(lhs);
        if (rhsCache == null) {
            rhsCache = new MRUSet(this.fMaxRHS);
            this.fLHSCache.put(lhs, rhsCache);
        }
        return rhsCache;
    }

    public static void store(ContentAssistHistory history, Preferences preferences, String key) throws CoreException {
        StringWriter writer = new StringWriter();
        new ReaderWriter().store(history, new StreamResult(writer));
        preferences.setValue(key, writer.toString());
    }

    public static ContentAssistHistory load(Preferences preferences, String key) throws CoreException {
        String value = preferences.getString(key);
        if (value != null && value.length() > 0) {
            return new ReaderWriter().load(new InputSource(new StringReader(value)));
        }
        return null;
    }

    private static final class MRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private final int fMaxSize;

        public MRUMap(int maxSize) {
            Assert.isLegal((maxSize > 0 ? 1 : 0) != 0);
            this.fMaxSize = maxSize;
        }

        @Override
        public Object put(Object key, Object value) {
            Object object = this.remove(key);
            super.put(key, value);
            return object;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.fMaxSize;
        }
    }

    private static final class MRUSet
    extends LinkedHashSet {
        private static final long serialVersionUID = 1L;
        private final int fMaxSize;

        public MRUSet(int maxSize) {
            Assert.isLegal((maxSize > 0 ? 1 : 0) != 0);
            this.fMaxSize = maxSize;
        }

        @Override
        public boolean add(Object o) {
            if (this.remove(o)) {
                super.add(o);
                return false;
            }
            if (this.size() >= this.fMaxSize) {
                this.remove(this.iterator().next());
            }
            super.add(o);
            return true;
        }
    }

    public static final class RHSHistory {
        private final LinkedHashMap fHistory;
        private List fList;

        RHSHistory(LinkedHashMap history) {
            this.fHistory = history;
        }

        public float getRank(String type) {
            if (this.fHistory == null) {
                return 0.0f;
            }
            Integer integer = (Integer)this.fHistory.get(type);
            return integer == null ? 0.0f : integer.floatValue() / (float)this.fHistory.size();
        }

        public int size() {
            return this.fHistory == null ? 0 : this.fHistory.size();
        }

        public List getTypes() {
            if (this.fHistory == null) {
                return Collections.EMPTY_LIST;
            }
            if (this.fList == null) {
                this.fList = Collections.unmodifiableList(new ArrayList(this.fHistory.keySet()));
            }
            return this.fList;
        }
    }

    private static final class ReaderWriter {
        private static final String NODE_ROOT = "history";
        private static final String NODE_LHS = "lhs";
        private static final String NODE_RHS = "rhs";
        private static final String ATTRIBUTE_NAME = "name";
        private static final String ATTRIBUTE_MAX_LHS = "maxLHS";
        private static final String ATTRIBUTE_MAX_RHS = "maxRHS";

        private ReaderWriter() {
        }

        public void store(ContentAssistHistory history, StreamResult result) throws CoreException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element rootElement = document.createElement(NODE_ROOT);
                rootElement.setAttribute(ATTRIBUTE_MAX_LHS, Integer.toString(history.fMaxLHS));
                rootElement.setAttribute(ATTRIBUTE_MAX_RHS, Integer.toString(history.fMaxRHS));
                document.appendChild(rootElement);
                for (String lhs : history.fLHSCache.keySet()) {
                    Element lhsElement = document.createElement(NODE_LHS);
                    lhsElement.setAttribute(ATTRIBUTE_NAME, lhs);
                    rootElement.appendChild(lhsElement);
                    Set rightHandSides = (Set)history.fLHSCache.get(lhs);
                    for (String rhs : rightHandSides) {
                        Element rhsElement = document.createElement(NODE_RHS);
                        rhsElement.setAttribute(ATTRIBUTE_NAME, rhs);
                        lhsElement.appendChild(rhsElement);
                    }
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "no");
                DOMSource source = new DOMSource(document);
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw this.createException(e, ScriptTextMessages.ContentAssistHistory_serialize_error);
            }
            catch (ParserConfigurationException e) {
                throw this.createException(e, ScriptTextMessages.ContentAssistHistory_serialize_error);
            }
        }

        public ContentAssistHistory load(InputSource source) throws CoreException {
            Element root;
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                root = parser.parse(source).getDocumentElement();
            }
            catch (SAXException e) {
                throw this.createException(e, ScriptTextMessages.ContentAssistHistory_deserialize_error);
            }
            catch (ParserConfigurationException e) {
                throw this.createException(e, ScriptTextMessages.ContentAssistHistory_deserialize_error);
            }
            catch (IOException e) {
                throw this.createException(e, ScriptTextMessages.ContentAssistHistory_deserialize_error);
            }
            if (root == null || !root.getNodeName().equalsIgnoreCase(NODE_ROOT)) {
                return null;
            }
            int maxLHS = this.parseNaturalInt(root.getAttribute(ATTRIBUTE_MAX_LHS), 100);
            int maxRHS = this.parseNaturalInt(root.getAttribute(ATTRIBUTE_MAX_RHS), 10);
            ContentAssistHistory history = new ContentAssistHistory(maxLHS, maxRHS);
            NodeList list = root.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                String lhs;
                Element lhsElement;
                Node lhsNode = list.item(i);
                if (lhsNode.getNodeType() == 1 && (lhsElement = (Element)lhsNode).getNodeName().equalsIgnoreCase(NODE_LHS) && (lhs = lhsElement.getAttribute(ATTRIBUTE_NAME)) != null) {
                    Set cache = history.getCache(lhs);
                    NodeList children = lhsElement.getChildNodes();
                    int nRHS = children.getLength();
                    int j = 0;
                    while (j < nRHS) {
                        String rhs;
                        Element rhsElement;
                        Node rhsNode = children.item(j);
                        if (rhsNode.getNodeType() == 1 && (rhsElement = (Element)rhsNode).getNodeName().equalsIgnoreCase(NODE_RHS) && (rhs = rhsElement.getAttribute(ATTRIBUTE_NAME)) != null) {
                            cache.add(rhs);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return history;
        }

        private int parseNaturalInt(String attribute, int defaultValue) {
            try {
                int integer = Integer.parseInt(attribute);
                if (integer > 0) {
                    return integer;
                }
                return defaultValue;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        private DLTKUIException createException(Exception e, String message) {
            return new DLTKUIException(DLTKUIStatus.createError(4, message, e));
        }
    }
}

