/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.ColumnInfo;
import org.eclipse.datatools.enablement.oda.xml.util.MappedTables;
import org.eclipse.datatools.enablement.oda.xml.util.MappingPathElementTree;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.enablement.oda.xml.util.TableInfo;

public class RelationInformation {
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String FORWARD_SLASH = "/";
    private HashMap tableInfos;
    private boolean containsNamespace = false;

    public RelationInformation(String relationString) throws OdaException {
        if (relationString == null || relationString.length() == 0) {
            throw new OdaException(Messages.getString("RelationInformation.InputStringCannotBeNull"));
        }
        this.initialize(new MappedTables(relationString), false);
    }

    public RelationInformation(MappedTables mt, boolean useNamespace) throws OdaException {
        this.initialize(mt, useNamespace);
    }

    private void initialize(MappedTables mt, boolean useNamespace) throws OdaException {
        this.tableInfos = new HashMap();
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        if (useNamespace && mt.getNameSpacePart() != null) {
            this.containsNamespace = true;
            String[] names = mt.getNameSpacePart().split(";");
            int k = 0;
            while (k < names.length) {
                String[] entry = names[k].split(",");
                if (entry.length == 2 && entry[0].trim().matches("\\Q\"\\E.*\\Q\"\\E") && entry[1].trim().matches("\\Q\"\\E.*\\Q\"\\E")) {
                    prefixMap.put(entry[0].trim().substring(1, entry[0].trim().length() - 1), entry[1].trim().substring(1, entry[1].trim().length() - 1));
                }
                ++k;
            }
        }
        for (MappedTables.Table t : mt.getTables()) {
            ArrayList filterColumnInfos = new ArrayList();
            String tableName = t.getName();
            String tableRawRoot = t.getRowPath();
            if (useNamespace) {
                tableRawRoot = this.getValueWithNameSpace(tableRawRoot, prefixMap);
            }
            TableInfo tableInfo = new TableInfo(tableName, tableRawRoot);
            int j = 0;
            while (j < t.getColumns().length) {
                MappedTables.Column c = t.getColumns()[j];
                String columnXpath = c.getPath();
                if (useNamespace) {
                    columnXpath = this.getValueWithNameSpace(columnXpath, prefixMap);
                }
                HashMap map = null;
                if (columnXpath.matches(".*\\Q[@\\E.*\\Q=\\E.*")) {
                    map = RelationInformation.populateFilterInfo(filterColumnInfos, tableInfo, t.getColumns().length, columnXpath);
                }
                tableInfo.addColumn(new ColumnInfo(j + 1, c.getName(), c.getType(), columnXpath, map));
                ++j;
            }
            j = 0;
            while (j < filterColumnInfos.size()) {
                tableInfo.addColumn((ColumnInfo)filterColumnInfos.get(j));
                ++j;
            }
            if (tableRawRoot.matches(".*\\Q[@\\E.*\\Q=\\E.*")) {
                String tableRootWithFilter = SaxParserUtil.removeRedundantParentAxis(tableRawRoot);
                String value = RelationInformation.getFilterValue(tableRootWithFilter);
                String filterColumnXpath = tableRootWithFilter.replaceAll("\\Q=\\E.*", "]");
                int backRef = tableRootWithFilter.split(FORWARD_SLASH).length - filterColumnXpath.split(FORWARD_SLASH).length;
                String tableFilterPart = tableRawRoot.replaceAll(".*\\Q[\\E", EMPTY_STRING).replaceAll("\\Q=\\E.*", EMPTY_STRING);
                int n = 0;
                while (n < backRef) {
                    tableFilterPart = "../" + tableFilterPart;
                    ++n;
                }
                String tempColumnName = SaxParserUtil.createTableRootTempColumnNameForFilter();
                tableInfo.addFilter(tempColumnName, value);
                tableInfo.addColumn(new ColumnInfo(t.getColumns().length + filterColumnInfos.size() + 1, tempColumnName, "String", tableFilterPart, null));
            }
            tableInfo.bulidMappingPathTree();
            this.tableInfos.put(t.getName(), tableInfo);
        }
    }

    public boolean containsNamespace() {
        return this.containsNamespace;
    }

    private String getValueWithNameSpace(String rawInfo, Map prefixMap) {
        if (rawInfo.indexOf(":") < 0) {
            return rawInfo;
        }
        for (Map.Entry entry : prefixMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String regex = "/\\Q" + key + "\\E" + "\\Q" + ":" + "\\E";
            rawInfo = rawInfo.replaceAll(regex, FORWARD_SLASH + value + ":");
        }
        return rawInfo;
    }

    private static HashMap populateFilterInfo(List filterColumnInfos, TableInfo tableInfo, int columnCount, String columnXpath) throws OdaException {
        HashMap<String, String> map = null;
        String value = RelationInformation.getFilterValue(columnXpath);
        columnXpath = columnXpath.replaceAll("\\Q=\\E.*", EMPTY_STRING);
        int index = columnXpath.lastIndexOf("[@");
        String before = columnXpath.substring(0, index);
        String after = columnXpath.substring(index + 1);
        String relativePath = String.valueOf(before) + FORWARD_SLASH + after;
        String tempColumnName = SaxParserUtil.createTempColumnName(filterColumnInfos.size() + 1);
        map = new HashMap<String, String>();
        map.put(tempColumnName, value);
        filterColumnInfos.add(new ColumnInfo(columnCount + filterColumnInfos.size() + 1, tempColumnName, "String", relativePath, null));
        return map;
    }

    static String getFilterValue(String columnXpath) throws OdaException {
        String value = columnXpath.replaceAll(".*\\Q[@\\E.*\\Q=\\E", EMPTY_STRING).trim();
        if (!((value = value.replaceAll("\\Q]\\E.*", EMPTY_STRING).trim()).startsWith(SINGLE_QUOTE) && value.endsWith(SINGLE_QUOTE) || value.startsWith(DOUBLE_QUOTE) && value.endsWith(DOUBLE_QUOTE))) {
            throw new OdaException(Messages.getString("RelationInformation.InvalidFilterDefinition"));
        }
        value = value.substring(1, value.length() - 1);
        return value;
    }

    public String getTableOriginalColumnPath(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalPath(columnName == null ? EMPTY_STRING : columnName.trim());
        }
        return null;
    }

    public String getTableColumnType(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getType(columnName == null ? EMPTY_STRING : columnName.trim());
        }
        return null;
    }

    public String[] getTableColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getColumnNames();
        }
        return new String[0];
    }

    String[] getTableRealColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getRealColumnNames();
        }
        return new String[0];
    }

    public String[] getTableNestedXMLColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getNestedXMLColumnNames();
        }
        return new String[0];
    }

    public MappingPathElementTree getTableMappingPathElementTree(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getMappingPathTree();
        }
        return null;
    }

    public String getTableRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getRootPath();
        }
        return null;
    }

    public String getTableOriginalRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalRootPath();
        }
        return null;
    }

    public HashMap getTableFilter(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getFilter();
        }
        return null;
    }

    public Iterator getTableNames() {
        return this.tableInfos.keySet().iterator();
    }

    public HashMap getTableColumnFilter(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getColumnFilters(columnName);
        }
        return null;
    }
}

