/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.managedbuilder.core.IOptionDefaultValueGenerator;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class Option
extends BuildObject
implements IOption,
IBuildPropertiesRestriction {
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final OptionStringValue[] EMPTY_LV_ARRAY = new OptionStringValue[0];
    private IOption superClass;
    private String superClassId;
    private IHoldsOptions holder;
    private String unusedChildren;
    private Integer browseType;
    private String browseFilterPath;
    private String[] browseFilterExtensions;
    private List<OptionStringValue> builtIns;
    private IOptionCategory category;
    private String categoryId;
    private String command;
    private IConfigurationElement commandGeneratorElement;
    private IOptionCommandGenerator commandGenerator;
    private String commandFalse;
    private Boolean isForScannerDiscovery;
    private String tip;
    private String contextId;
    private List<String> applicableValuesList;
    private Map<String, String> commandsMap;
    private Map<String, String> namesMap;
    private Object value;
    private Object defaultValue;
    private IConfigurationElement defaultValueGeneratorElement;
    private IOptionDefaultValueGenerator defaultValueGenerator;
    private Integer valueType;
    private Boolean isAbstract;
    private Integer resourceFilter;
    private IConfigurationElement valueHandlerElement = null;
    private IManagedOptionValueHandler valueHandler = null;
    private String valueHandlerExtraArgument;
    private String fieldEditorId;
    private String fieldEditorExtraArgument;
    private IConfigurationElement applicabilityCalculatorElement = null;
    private IOptionApplicability applicabilityCalculator = null;
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator = null;
    private IOption.ITreeRoot treeRoot;
    private boolean isExtensionOption = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private boolean verified = false;
    private boolean isValid = true;
    private boolean wasOptRef = false;
    private boolean isUdjusted = false;
    private boolean rebuildState;

    public Option(IHoldsOptions parent, IManagedConfigElement element) {
        this.holder = parent;
        this.isExtensionOption = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionOption(this);
    }

    public Option(IHoldsOptions parent, IOption superClass, String Id, String name, boolean isExtensionElement) {
        this.holder = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOption = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionOption(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public Option(IHoldsOptions parent, ICStorageElement element) {
        this.holder = parent;
        this.isExtensionOption = false;
        this.loadFromProject(element);
    }

    public Option(IHoldsOptions parent, String Id, String name, Option option) {
        this.holder = parent;
        this.superClass = option.superClass;
        if (this.superClass != null) {
            this.superClassId = option.superClass.getId();
        } else if (option.superClassId != null) {
            this.superClassId = option.superClassId;
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionOption = false;
        boolean copyIds = Id.equals(option.id);
        if (option.unusedChildren != null) {
            this.unusedChildren = option.unusedChildren;
        }
        if (option.isAbstract != null) {
            this.isAbstract = option.isAbstract;
        }
        if (option.command != null) {
            this.command = option.command;
        }
        if (option.commandFalse != null) {
            this.commandFalse = option.commandFalse;
        }
        if (option.isForScannerDiscovery != null) {
            this.isForScannerDiscovery = option.isForScannerDiscovery;
        }
        if (option.tip != null) {
            this.tip = option.tip;
        }
        if (option.contextId != null) {
            this.contextId = option.contextId;
        }
        if (option.categoryId != null) {
            this.categoryId = option.categoryId;
        }
        if (option.builtIns != null) {
            this.builtIns = new ArrayList<OptionStringValue>(option.builtIns);
        }
        if (option.browseType != null) {
            this.browseType = option.browseType;
        }
        if (option.browseFilterPath != null) {
            this.browseFilterPath = option.browseFilterPath;
        }
        if (option.browseFilterExtensions != null) {
            this.browseFilterExtensions = (String[])option.browseFilterExtensions.clone();
        }
        if (option.resourceFilter != null) {
            this.resourceFilter = option.resourceFilter;
        }
        if (option.applicableValuesList != null) {
            this.applicableValuesList = new ArrayList<String>(option.applicableValuesList);
            this.commandsMap = new HashMap<String, String>(option.commandsMap);
            this.namesMap = new HashMap<String, String>(option.namesMap);
        }
        if (option.treeRoot != null) {
            this.treeRoot = new TreeRoot((TreeRoot)option.treeRoot);
        }
        if (option.valueType != null) {
            this.valueType = option.valueType;
        }
        try {
            int vType = option.getValueType();
            switch (vType) {
                case 0: {
                    if (option.value != null) {
                        this.value = option.value;
                    }
                    if (option.defaultValue != null) {
                        this.defaultValue = option.defaultValue;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 12: {
                    if (option.value != null) {
                        this.value = option.value;
                    }
                    if (option.defaultValue != null) {
                        this.defaultValue = option.defaultValue;
                    }
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    ArrayList list;
                    if (option.value != null) {
                        this.value = list = new ArrayList((ArrayList)option.value);
                    }
                    if (option.defaultValue == null) break;
                    this.defaultValue = list = new ArrayList((ArrayList)option.defaultValue);
                }
                default: {
                    break;
                }
            }
        }
        catch (BuildException buildException) {
            // empty catch block
        }
        this.category = option.category;
        this.defaultValueGeneratorElement = option.defaultValueGeneratorElement;
        this.defaultValueGenerator = option.defaultValueGenerator;
        this.commandGeneratorElement = option.commandGeneratorElement;
        this.commandGenerator = option.commandGenerator;
        this.applicabilityCalculatorElement = option.applicabilityCalculatorElement;
        this.applicabilityCalculator = option.applicabilityCalculator;
        this.booleanExpressionCalculator = option.booleanExpressionCalculator;
        if (option.valueHandlerElement != null) {
            this.valueHandlerElement = option.valueHandlerElement;
            this.valueHandler = option.valueHandler;
        }
        if (option.valueHandlerExtraArgument != null) {
            this.valueHandlerExtraArgument = option.valueHandlerExtraArgument;
        }
        if (option.fieldEditorId != null) {
            this.fieldEditorId = option.fieldEditorId;
        }
        if (option.fieldEditorExtraArgument != null) {
            this.fieldEditorExtraArgument = option.fieldEditorExtraArgument;
        }
        if (copyIds) {
            this.isDirty = option.isDirty;
            this.rebuildState = option.rebuildState;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String applicabilityCalculatorStr;
        String browseTypeStr;
        String defaultValueGeneratorStr;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = Boolean.parseBoolean(isAbs);
        }
        if ((defaultValueGeneratorStr = element.getAttribute("defaultValueGenerator")) != null && element instanceof DefaultManagedConfigElement) {
            this.defaultValueGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.command = SafeStringInterner.safeIntern((String)element.getAttribute("command"));
        String commandGeneratorStr = element.getAttribute("commandGenerator");
        if (commandGeneratorStr != null && element instanceof DefaultManagedConfigElement) {
            this.commandGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.commandFalse = SafeStringInterner.safeIntern((String)element.getAttribute("commandFalse"));
        String isForSD = element.getAttribute("useByScannerDiscovery");
        if (isForSD != null) {
            this.isForScannerDiscovery = Boolean.parseBoolean(isForSD);
        }
        this.tip = SafeStringInterner.safeIntern((String)element.getAttribute("tip"));
        this.contextId = SafeStringInterner.safeIntern((String)element.getAttribute("contextId"));
        String valueTypeStr = element.getAttribute("valueType");
        if (valueTypeStr != null) {
            this.valueType = this.ValueTypeStrToInt(valueTypeStr);
        }
        if ((browseTypeStr = element.getAttribute("browseType")) == null) {
            this.browseType = null;
        } else if (browseTypeStr.equals("none")) {
            this.browseType = 0;
        } else if (browseTypeStr.equals("file")) {
            this.browseType = 1;
        } else if (browseTypeStr.equals("directory")) {
            this.browseType = 2;
        }
        this.browseFilterPath = SafeStringInterner.safeIntern((String)element.getAttribute("browseFilterPath"));
        String browseFilterExtensionsStr = element.getAttribute("browseFilterExtensions");
        if (browseFilterExtensionsStr != null) {
            this.browseFilterExtensions = SafeStringInterner.safeIntern((String[])browseFilterExtensionsStr.split("\\s*,\\s*"));
        }
        this.categoryId = SafeStringInterner.safeIntern((String)element.getAttribute("category"));
        String resFilterStr = element.getAttribute("resourceFilter");
        if (resFilterStr == null) {
            this.resourceFilter = null;
        } else if (resFilterStr.equals("all")) {
            this.resourceFilter = 0;
        } else if (resFilterStr.equals("file")) {
            this.resourceFilter = 1;
        } else if (resFilterStr.equals("project")) {
            this.resourceFilter = 2;
        }
        IManagedConfigElement[] enablements = element.getChildren("enablement");
        if (enablements.length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        if ((applicabilityCalculatorStr = element.getAttribute("applicabilityCalculator")) != null && element instanceof DefaultManagedConfigElement) {
            this.applicabilityCalculatorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        } else {
            this.applicabilityCalculator = this.booleanExpressionCalculator;
        }
        String valueHandler = element.getAttribute("valueHandler");
        if (valueHandler != null && element instanceof DefaultManagedConfigElement) {
            this.valueHandlerElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.valueHandlerExtraArgument = SafeStringInterner.safeIntern((String)element.getAttribute("valueHandlerExtraArgument"));
        this.fieldEditorId = element.getAttribute("fieldEditor");
        this.fieldEditorExtraArgument = element.getAttribute("fieldEditorExtraArgument");
    }

    protected void loadFromProject(ICStorageElement element) {
        String browseFilterExtensionsStr;
        String isForSD;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionOption(this.superClassId);
        }
        if (element.getAttribute("unusedChildren") != null) {
            this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        }
        if (element.getAttribute("isAbstract") != null && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = Boolean.parseBoolean(isAbs);
        }
        if (element.getAttribute("command") != null) {
            this.command = SafeStringInterner.safeIntern((String)element.getAttribute("command"));
        }
        if (element.getAttribute("commandFalse") != null) {
            this.commandFalse = SafeStringInterner.safeIntern((String)element.getAttribute("commandFalse"));
        }
        if (element.getAttribute("useByScannerDiscovery") != null && (isForSD = element.getAttribute("useByScannerDiscovery")) != null) {
            this.isForScannerDiscovery = Boolean.parseBoolean(isForSD);
        }
        if (element.getAttribute("tip") != null) {
            this.tip = SafeStringInterner.safeIntern((String)element.getAttribute("tip"));
        }
        if (element.getAttribute("contextId") != null) {
            this.contextId = SafeStringInterner.safeIntern((String)element.getAttribute("contextId"));
        }
        if (element.getAttribute("valueType") != null) {
            String valueTypeStr = element.getAttribute("valueType");
            this.valueType = this.ValueTypeStrToInt(valueTypeStr);
        }
        try {
            int valType = this.getValueType();
            switch (valType) {
                case 0: {
                    if (element.getAttribute("value") != null) {
                        this.value = Boolean.valueOf(element.getAttribute("value"));
                    }
                    if (element.getAttribute("defaultValue") != null) {
                        this.defaultValue = Boolean.valueOf(element.getAttribute("defaultValue"));
                    }
                    break;
                }
                case 2: {
                    if (element.getAttribute("value") != null) {
                        this.value = SafeStringInterner.safeIntern((String)element.getAttribute("value"));
                    }
                    if (element.getAttribute("defaultValue") != null) {
                        this.defaultValue = SafeStringInterner.safeIntern((String)element.getAttribute("defaultValue"));
                    }
                    break;
                }
                case 1: {
                    if (element.getAttribute("value") != null) {
                        this.value = SafeStringInterner.safeIntern((String)element.getAttribute("value"));
                    }
                    if (element.getAttribute("defaultValue") != null) {
                        this.defaultValue = SafeStringInterner.safeIntern((String)element.getAttribute("defaultValue"));
                    }
                    ICStorageElement[] configElements = element.getChildren();
                    int i = 0;
                    while (i < configElements.length) {
                        ICStorageElement configNode = configElements[i];
                        if (configNode.getName().equals("enumeratedOptionValue")) {
                            Boolean isDefault;
                            ICStorageElement configElement = configNode;
                            String optId = SafeStringInterner.safeIntern((String)configElement.getAttribute("id"));
                            if (i == 0) {
                                this.applicableValuesList = new ArrayList<String>();
                                if (this.defaultValue == null) {
                                    this.defaultValue = optId;
                                }
                            }
                            this.applicableValuesList.add(optId);
                            if (configElement.getAttribute("command") != null) {
                                this.getCommandMap().put(optId, SafeStringInterner.safeIntern((String)configElement.getAttribute("command")));
                            } else {
                                this.getCommandMap().put(optId, EMPTY_STRING);
                            }
                            this.getNameMap().put(optId, SafeStringInterner.safeIntern((String)configElement.getAttribute("name")));
                            if (configElement.getAttribute("isDefault") != null && (isDefault = Boolean.valueOf(configElement.getAttribute("isDefault"))).booleanValue()) {
                                this.defaultValue = optId;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 12: {
                    if (element.getAttribute("value") != null) {
                        this.value = element.getAttribute("value");
                    }
                    if (element.getAttribute("defaultValue") != null) {
                        this.defaultValue = element.getAttribute("defaultValue");
                    }
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    ICStorageElement[] configElements;
                    ArrayList<OptionStringValue> vList = null;
                    ArrayList<OptionStringValue> biList = null;
                    ICStorageElement[] iCStorageElementArray = configElements = element.getChildren();
                    int n = configElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICStorageElement veNode = iCStorageElementArray[n2];
                        if (vList == null) {
                            vList = new ArrayList<OptionStringValue>();
                        }
                        if (biList == null) {
                            biList = new ArrayList<OptionStringValue>();
                        }
                        if (veNode.getName().equals("listOptionValue")) {
                            OptionStringValue ve = new OptionStringValue(veNode);
                            if (ve.isBuiltIn()) {
                                biList.add(ve);
                            } else {
                                vList.add(ve);
                            }
                        }
                        ++n2;
                    }
                    this.value = vList != null && vList.size() != 0 ? vList : null;
                    if (biList != null && biList.size() != 0) {
                        this.builtIns = biList;
                        break;
                    }
                    this.builtIns = null;
                    break;
                }
            }
        }
        catch (BuildException valType) {
            // empty catch block
        }
        if (element.getAttribute("browseType") != null) {
            String browseTypeStr = element.getAttribute("browseType");
            if (browseTypeStr == null) {
                this.browseType = null;
            } else if (browseTypeStr.equals("none")) {
                this.browseType = 0;
            } else if (browseTypeStr.equals("file")) {
                this.browseType = 1;
            } else if (browseTypeStr.equals("directory")) {
                this.browseType = 2;
            }
        }
        if (element.getAttribute("browseFilterPath") != null) {
            this.browseFilterPath = SafeStringInterner.safeIntern((String)element.getAttribute("browseFilterPath"));
        }
        if (element.getAttribute("browseFilterExtensions") != null && (browseFilterExtensionsStr = element.getAttribute("browseFilterExtensions")) != null) {
            this.browseFilterExtensions = SafeStringInterner.safeIntern((String[])browseFilterExtensionsStr.split("\\s*,\\s*"));
        }
        if (element.getAttribute("category") != null) {
            this.categoryId = SafeStringInterner.safeIntern((String)element.getAttribute("category"));
            if (this.categoryId != null) {
                this.category = this.holder.getOptionCategory(this.categoryId);
            }
        }
        if (element.getAttribute("resourceFilter") != null) {
            String resFilterStr = element.getAttribute("resourceFilter");
            if (resFilterStr == null) {
                this.resourceFilter = null;
            } else if (resFilterStr.equals("all")) {
                this.resourceFilter = 0;
            } else if (resFilterStr.equals("file")) {
                this.resourceFilter = 1;
            } else if (resFilterStr.equals("project")) {
                this.resourceFilter = 2;
            }
        }
        if (element.getAttribute("valueHandlerExtraArgument") != null) {
            this.valueHandlerExtraArgument = SafeStringInterner.safeIntern((String)element.getAttribute("valueHandlerExtraArgument"));
        }
    }

    private int ValueTypeStrToInt(String valueTypeStr) {
        if (valueTypeStr == null) {
            return -1;
        }
        if (valueTypeStr.equals("string")) {
            return 2;
        }
        if (valueTypeStr.equals("stringList")) {
            return 3;
        }
        if (valueTypeStr.equals("boolean")) {
            return 0;
        }
        if (valueTypeStr.equals("enumerated")) {
            return 1;
        }
        if (valueTypeStr.equals("includePath")) {
            return 4;
        }
        if (valueTypeStr.equals("libs")) {
            return 6;
        }
        if (valueTypeStr.equals("userObjs")) {
            return 7;
        }
        if (valueTypeStr.equals("definedSymbols")) {
            return 5;
        }
        if (valueTypeStr.equals("libPaths")) {
            return 9;
        }
        if (valueTypeStr.equals("libFiles")) {
            return 10;
        }
        if (valueTypeStr.equals("includeFiles")) {
            return 8;
        }
        if (valueTypeStr.equals("symbolFiles")) {
            return 11;
        }
        if (valueTypeStr.equals("undefIncludePath")) {
            return -4;
        }
        if (valueTypeStr.equals("undefDefinedSymbols")) {
            return -5;
        }
        if (valueTypeStr.equals("undefLibPaths")) {
            return -9;
        }
        if (valueTypeStr.equals("undefLibFiles")) {
            return -10;
        }
        if (valueTypeStr.equals("undefIncludeFiles")) {
            return -8;
        }
        if (valueTypeStr.equals("undefSymbolFiles")) {
            return -11;
        }
        if (valueTypeStr.equals("tree")) {
            return 12;
        }
        ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "Invalid option type=\"" + valueTypeStr + "\" specified for option " + this.getId()));
        return 5;
    }

    public void serialize(ICStorageElement element) throws BuildException {
        String str;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        } else if (this.superClassId != null) {
            element.setAttribute("superClass", this.superClassId);
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.unusedChildren != null) {
            element.setAttribute("unusedChildren", this.unusedChildren);
        }
        if (this.isAbstract != null) {
            element.setAttribute("isAbstract", this.isAbstract.toString());
        }
        if (this.command != null) {
            element.setAttribute("command", this.command);
        }
        if (this.commandFalse != null) {
            element.setAttribute("commandFalse", this.commandFalse);
        }
        if (this.isForScannerDiscovery != null) {
            element.setAttribute("useByScannerDiscovery", this.isForScannerDiscovery.toString());
        }
        if (this.tip != null) {
            element.setAttribute("tip", this.tip);
        }
        if (this.contextId != null) {
            element.setAttribute("contextId", this.contextId);
        }
        boolean storeValueType = false;
        if (this.value != null) {
            storeValueType = true;
            switch (this.getValueType()) {
                case 0: {
                    element.setAttribute("value", ((Boolean)this.value).toString());
                    break;
                }
                case 1: 
                case 2: 
                case 12: {
                    element.setAttribute("value", (String)this.value);
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    if (this.value != null) {
                        ArrayList stringList = (ArrayList)this.value;
                        for (Object optValue : stringList) {
                            ICStorageElement valueElement = element.createChild("listOptionValue");
                            ((OptionStringValue)optValue).serialize(valueElement);
                        }
                    }
                    if (this.builtIns == null) break;
                    for (OptionStringValue optionValue : this.builtIns) {
                        ICStorageElement valueElement = element.createChild("listOptionValue");
                        optionValue.serialize(valueElement);
                    }
                    break;
                }
            }
        }
        if (this.defaultValue != null) {
            storeValueType = true;
            switch (this.getValueType()) {
                case 0: {
                    element.setAttribute("defaultValue", ((Boolean)this.defaultValue).toString());
                    break;
                }
                case 1: 
                case 2: 
                case 12: {
                    element.setAttribute("defaultValue", (String)this.defaultValue);
                    break;
                }
            }
        }
        if (storeValueType) {
            switch (this.getValueType()) {
                case 0: {
                    str = "boolean";
                    break;
                }
                case 2: {
                    str = "string";
                    break;
                }
                case 1: {
                    str = "enumerated";
                    break;
                }
                case 3: {
                    str = "stringList";
                    break;
                }
                case 4: {
                    str = "includePath";
                    break;
                }
                case 6: {
                    str = "libs";
                    break;
                }
                case 7: {
                    str = "userObjs";
                    break;
                }
                case 5: {
                    str = "definedSymbols";
                    break;
                }
                case 8: {
                    str = "includeFiles";
                    break;
                }
                case 9: {
                    str = "libPaths";
                    break;
                }
                case 10: {
                    str = "libFiles";
                    break;
                }
                case 11: {
                    str = "symbolFiles";
                    break;
                }
                case -4: {
                    str = "undefIncludePath";
                    break;
                }
                case -5: {
                    str = "undefDefinedSymbols";
                    break;
                }
                case -8: {
                    str = "undefIncludeFiles";
                    break;
                }
                case -9: {
                    str = "undefLibPaths";
                    break;
                }
                case -10: {
                    str = "undefLibFiles";
                    break;
                }
                case -11: {
                    str = "undefSymbolFiles";
                    break;
                }
                case 12: {
                    str = "tree";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("valueType", str);
        }
        if (this.browseType != null) {
            switch (this.getBrowseType()) {
                case 0: {
                    str = "none";
                    break;
                }
                case 1: {
                    str = "file";
                    break;
                }
                case 2: {
                    str = "directory";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("browseType", str);
        }
        if (this.browseFilterPath != null) {
            element.setAttribute("browseFilterPath", this.browseFilterPath);
        }
        if (this.browseFilterExtensions != null) {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = this.browseFilterExtensions;
            int n = this.browseFilterExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                sb.append(ext).append(',');
                ++n2;
            }
            element.setAttribute("browseFilterExtensions", sb.toString());
        }
        if (this.categoryId != null) {
            element.setAttribute("category", this.categoryId);
        }
        if (this.resourceFilter != null) {
            switch (this.getResourceFilter()) {
                case 0: {
                    str = "all";
                    break;
                }
                case 1: {
                    str = "file";
                    break;
                }
                case 2: {
                    str = "project";
                    break;
                }
                default: {
                    str = EMPTY_STRING;
                }
            }
            element.setAttribute("resourceFilter", str);
        }
        if (this.valueHandlerExtraArgument != null) {
            element.setAttribute("valueHandlerExtraArgument", this.valueHandlerExtraArgument);
        }
        this.isDirty = false;
    }

    @Override
    public IOptionContextData getOptionContextData(IHoldsOptions holder) {
        return new OptionContextData(this, (IBuildObject)holder);
    }

    @Override
    public IBuildObject getParent() {
        return this.holder;
    }

    @Override
    public IHoldsOptions getOptionHolder() {
        return this.holder;
    }

    @Override
    public IOption getSuperClass() {
        return this.superClass;
    }

    @Override
    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    @Override
    public String[] getApplicableValues() {
        if (this.applicableValuesList == null) {
            if (this.superClass != null) {
                return this.superClass.getApplicableValues();
            }
            return EMPTY_STRING_ARRAY;
        }
        if (this.applicableValuesList.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] enumNames = new String[this.applicableValuesList.size()];
        int index = 0;
        while (index < this.applicableValuesList.size()) {
            enumNames[index] = this.getNameMap().get(this.applicableValuesList.get(index));
            ++index;
        }
        return enumNames;
    }

    @Override
    public boolean getBooleanValue() {
        return (Boolean)this.getValue();
    }

    @Override
    public int getBrowseType() {
        if (this.browseType == null) {
            if (this.superClass != null) {
                return this.superClass.getBrowseType();
            }
            return 0;
        }
        return this.browseType;
    }

    @Override
    public String getBrowseFilterPath() {
        if (this.browseFilterPath == null) {
            if (this.superClass != null) {
                return this.superClass.getBrowseFilterPath();
            }
            return null;
        }
        return this.browseFilterPath;
    }

    @Override
    public String[] getBrowseFilterExtensions() {
        if (this.browseFilterExtensions == null) {
            if (this.superClass != null) {
                return this.superClass.getBrowseFilterExtensions();
            }
            return null;
        }
        return (String[])this.browseFilterExtensions.clone();
    }

    @Override
    public int getResourceFilter() {
        if (this.resourceFilter == null) {
            if (this.superClass != null) {
                return this.superClass.getResourceFilter();
            }
            return 0;
        }
        return this.resourceFilter;
    }

    public IConfigurationElement getApplicabilityCalculatorElement() {
        return this.applicabilityCalculatorElement;
    }

    @Override
    public IOptionApplicability getApplicabilityCalculator() {
        if (this.applicabilityCalculator == null) {
            if (this.applicabilityCalculatorElement != null) {
                try {
                    if (this.applicabilityCalculatorElement.getAttribute("applicabilityCalculator") != null) {
                        this.applicabilityCalculator = (IOptionApplicability)this.applicabilityCalculatorElement.createExecutableExtension("applicabilityCalculator");
                    }
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            } else if (this.superClass != null) {
                this.applicabilityCalculator = this.superClass.getApplicabilityCalculator();
            }
        }
        return this.applicabilityCalculator;
    }

    @Override
    public String[] getBuiltIns() {
        List<OptionStringValue> list = this.getExactBuiltinsList();
        List<String> valueList = this.listValueListToValueList(list);
        if (valueList == null) {
            return EMPTY_STRING_ARRAY;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    public List<OptionStringValue> getExactBuiltinsList() {
        if (this.builtIns == null) {
            if (this.superClass != null) {
                return ((Option)this.superClass).getExactBuiltinsList();
            }
            return null;
        }
        return this.builtIns;
    }

    @Override
    public IOptionCategory getCategory() {
        if (this.category == null) {
            if (this.superClass != null) {
                return this.superClass.getCategory();
            }
            if (this.getOptionHolder() instanceof ITool) {
                return ((ITool)this.getOptionHolder()).getTopOptionCategory();
            }
            return null;
        }
        return this.category;
    }

    @Override
    public IOptionDefaultValueGenerator getDefaultValueGenerator() {
        if (this.defaultValueGenerator == null) {
            if (this.defaultValueGeneratorElement != null) {
                try {
                    if (this.defaultValueGeneratorElement.getAttribute("defaultValueGenerator") != null) {
                        this.defaultValueGenerator = (IOptionDefaultValueGenerator)this.defaultValueGeneratorElement.createExecutableExtension("defaultValueGenerator");
                    }
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            } else if (this.superClass != null) {
                this.defaultValueGenerator = this.superClass.getDefaultValueGenerator();
            }
        }
        return this.defaultValueGenerator;
    }

    @Override
    public String getCommand() {
        if (this.command == null) {
            if (this.superClass != null) {
                return this.superClass.getCommand();
            }
            return EMPTY_STRING;
        }
        return this.command;
    }

    @Override
    public IOptionCommandGenerator getCommandGenerator() {
        if (this.commandGenerator == null) {
            if (this.commandGeneratorElement != null) {
                try {
                    if (this.commandGeneratorElement.getAttribute("commandGenerator") != null) {
                        this.commandGenerator = (IOptionCommandGenerator)this.commandGeneratorElement.createExecutableExtension("commandGenerator");
                    }
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            } else if (this.superClass != null) {
                this.commandGenerator = this.superClass.getCommandGenerator();
            }
        }
        return this.commandGenerator;
    }

    @Override
    public String getCommandFalse() {
        if (this.commandFalse == null) {
            if (this.superClass != null) {
                return this.superClass.getCommandFalse();
            }
            return EMPTY_STRING;
        }
        return this.commandFalse;
    }

    @Override
    public boolean isForScannerDiscovery() {
        if (this.isForScannerDiscovery == null) {
            this.isForScannerDiscovery = this.superClass != null && this.superClass.isForScannerDiscovery();
        }
        return this.isForScannerDiscovery;
    }

    @Override
    public String getToolTip() {
        if (this.tip == null) {
            if (this.superClass != null) {
                return this.superClass.getToolTip();
            }
            return EMPTY_STRING;
        }
        return this.tip;
    }

    @Override
    public String getContextId() {
        if (this.contextId == null) {
            if (this.superClass != null) {
                return this.superClass.getContextId();
            }
            return EMPTY_STRING;
        }
        return this.contextId;
    }

    @Override
    public String[] getDefinedSymbols() throws BuildException {
        if (this.getValueType() != 5) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    @Override
    public String getCommand(String id) throws BuildException {
        if (id == null) {
            return EMPTY_STRING;
        }
        if (this.applicableValuesList == null) {
            if (this.superClass != null) {
                return this.superClass.getCommand(id);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1 && this.getValueType() != 12) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        String cmd = this.getCommandMap().get(id);
        if (cmd == null) {
            for (String realID : this.applicableValuesList) {
                String name = this.getNameMap().get(realID);
                if (!id.equals(name)) continue;
                cmd = this.getCommandMap().get(realID);
                break;
            }
        }
        return cmd == null ? EMPTY_STRING : cmd;
    }

    @Override
    public String getEnumCommand(String id) throws BuildException {
        return this.getCommand(id);
    }

    @Override
    public String getEnumName(String id) throws BuildException {
        return this.getName(id);
    }

    @Override
    public String getName(String id) throws BuildException {
        if (id == null) {
            return EMPTY_STRING;
        }
        if (this.applicableValuesList == null) {
            if (this.superClass != null) {
                return this.superClass.getName(id);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        String name = this.getNameMap().get(id);
        if (name == null) {
            name = id;
        }
        return name;
    }

    private Map<String, String> getCommandMap() {
        if (this.commandsMap == null) {
            this.commandsMap = new HashMap<String, String>();
        }
        return this.commandsMap;
    }

    @Override
    public String getEnumeratedId(String name) throws BuildException {
        return this.getId(name);
    }

    @Override
    public String getId(String name) throws BuildException {
        if (name == null) {
            return null;
        }
        if (this.applicableValuesList == null) {
            if (this.superClass != null) {
                return this.superClass.getId(name);
            }
            return EMPTY_STRING;
        }
        if (this.getValueType() != 1 && this.getValueType() != 12) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        Set<String> idSet = this.getNameMap().keySet();
        for (String id : idSet) {
            String enumName = this.getNameMap().get(id);
            if (!name.equals(enumName)) continue;
            return id;
        }
        return null;
    }

    private Map<String, String> getNameMap() {
        if (this.namesMap == null) {
            this.namesMap = new HashMap<String, String>();
        }
        return this.namesMap;
    }

    @Override
    public String[] getIncludePaths() throws BuildException {
        if (this.getValueType() != 4) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    @Override
    public String[] getLibraries() throws BuildException {
        if (this.getValueType() != 6) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    @Override
    public String[] getLibraryFiles() throws BuildException {
        if (this.getValueType() != 10) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    @Override
    public String[] getLibraryPaths() throws BuildException {
        if (this.getValueType() != 9) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    @Override
    public String getSelectedEnum() throws BuildException {
        if (this.getValueType() != 1) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.getStringValue();
    }

    @Override
    public String[] getStringListValue() throws BuildException {
        if (this.getValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    @Override
    public String getStringValue() throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1 && this.getValueType() != 12) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.getValue() == null ? EMPTY_STRING : (String)this.getValue();
    }

    @Override
    public String[] getUserObjects() throws BuildException {
        if (this.getValueType() != 7) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        v.trimToSize();
        return v.toArray(new String[v.size()]);
    }

    @Override
    public int getValueType() throws BuildException {
        if (this.valueType == null) {
            if (this.superClass != null) {
                return this.superClass.getValueType();
            }
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        return this.valueType;
    }

    @Override
    public Object getValue() {
        ArrayList val = this.getRawValue();
        if (val == null && (val = this.getDefaultValue()) == null) {
            int valType;
            try {
                valType = this.getValueType();
            }
            catch (BuildException e) {
                return EMPTY_STRING;
            }
            switch (valType) {
                case 0: {
                    val = Boolean.FALSE;
                    break;
                }
                case 2: 
                case 12: {
                    val = EMPTY_STRING;
                    break;
                }
                case 1: {
                    val = EMPTY_STRING;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    val = new ArrayList();
                    break;
                }
                default: {
                    val = EMPTY_STRING;
                }
            }
        }
        return val;
    }

    public Object getExactValue() {
        ArrayList val = this.getExactRawValue();
        if (val == null && (val = this.getExactDefaultValue()) == null) {
            int valType;
            try {
                valType = this.getValueType();
            }
            catch (BuildException e) {
                return EMPTY_STRING;
            }
            switch (valType) {
                case 0: {
                    val = Boolean.FALSE;
                    break;
                }
                case 2: 
                case 12: {
                    val = EMPTY_STRING;
                    break;
                }
                case 1: {
                    val = EMPTY_STRING;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -5: 
                case -4: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    val = new ArrayList();
                    break;
                }
                default: {
                    val = EMPTY_STRING;
                }
            }
        }
        return val;
    }

    public Object getRawValue() {
        Object ev = this.getExactRawValue();
        if (ev instanceof List) {
            List<String> evList = this.listValueListToValueList((List)ev);
            return evList;
        }
        return ev;
    }

    public Object getExactRawValue() {
        if (this.value == null && this.superClass != null) {
            Option mySuperClass = (Option)this.superClass;
            return mySuperClass.getExactRawValue();
        }
        return this.value;
    }

    private List<String> listValueListToValueList(List<OptionStringValue> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> valueList = new ArrayList<String>(list.size());
        int i = 0;
        while (i < list.size()) {
            OptionStringValue el = list.get(i);
            valueList.add(el.getValue());
            ++i;
        }
        return valueList;
    }

    private List<OptionStringValue> valueListToListValueList(List<String> list, boolean builtIn) {
        if (list == null) {
            return null;
        }
        ArrayList<OptionStringValue> lvList = new ArrayList<OptionStringValue>(list.size());
        int i = 0;
        while (i < list.size()) {
            String v = list.get(i);
            lvList.add(new OptionStringValue(v, builtIn));
            ++i;
        }
        return lvList;
    }

    @Override
    public Object getDefaultValue() {
        Object ev = this.getExactDefaultValue();
        if (ev instanceof List) {
            List<String> evList = this.listValueListToValueList((List)ev);
            return evList;
        }
        return ev;
    }

    public Object getExactDefaultValue() {
        if (this.defaultValue == null && this.superClass != null) {
            return ((Option)this.superClass).getExactDefaultValue();
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object v) {
        List<OptionStringValue> vList;
        this.defaultValue = v instanceof List ? (vList = this.valueListToListValueList((List)v, false)) : v;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    @Override
    public void setCategory(IOptionCategory category) {
        if (this.category != category) {
            this.category = category;
            this.categoryId = category != null ? category.getId() : null;
            if (!this.isExtensionElement()) {
                this.setDirty(true);
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setCommandFalse(String cmd) {
        if (cmd == null && this.commandFalse == null) {
            return;
        }
        if (cmd == null || this.commandFalse == null || !cmd.equals(this.commandFalse)) {
            this.commandFalse = cmd;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setToolTip(String tooltip) {
        if (tooltip == null && this.tip == null) {
            return;
        }
        if (tooltip == null || this.tip == null || !tooltip.equals(this.tip)) {
            this.tip = tooltip;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setContextId(String id) {
        if (id == null && this.contextId == null) {
            return;
        }
        if (id == null || this.contextId == null || !id.equals(this.contextId)) {
            this.contextId = id;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setResourceFilter(int filter) {
        if (this.resourceFilter == null || filter != this.resourceFilter) {
            this.resourceFilter = filter;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setBrowseType(int type) {
        if (this.browseType == null || type != this.browseType) {
            this.browseType = type;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setBrowseFilterPath(String path) {
        if (this.browseFilterPath == null || !this.browseFilterPath.equals(path)) {
            this.browseFilterPath = path;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setBrowseFilterExtensions(String[] extensions) {
        if (this.browseFilterExtensions == null || !this.browseFilterExtensions.equals(extensions)) {
            this.browseFilterExtensions = extensions;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public void setValue(boolean value) throws BuildException {
        if (this.getValueType() != 0) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = value;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    @Override
    public void setValue(String value) throws BuildException {
        if (this.getValueType() != 2 && this.getValueType() != 1 && this.getValueType() != 12) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        this.value = value;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    @Override
    public void setValue(String[] value) throws BuildException {
        if (this.getValueType() == 3 || this.getValueType() == 4 || this.getValueType() == 5 || this.getValueType() == 6 || this.getValueType() == 7 || this.getValueType() == 8 || this.getValueType() == 9 || this.getValueType() == 10 || this.getValueType() == 11 || this.getValueType() == -4 || this.getValueType() == -5 || this.getValueType() == -8 || this.getValueType() == -9 || this.getValueType() == -10 || this.getValueType() == -11) {
            this.value = value == null ? null : this.valueListToListValueList(Arrays.asList(value), false);
        } else {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    public void setValue(OptionStringValue[] value) throws BuildException {
        if (this.getValueType() == 3 || this.getValueType() == 4 || this.getValueType() == 5 || this.getValueType() == 6 || this.getValueType() == 7 || this.getValueType() == 8 || this.getValueType() == 9 || this.getValueType() == 10 || this.getValueType() == 11 || this.getValueType() == -4 || this.getValueType() == -5 || this.getValueType() == -8 || this.getValueType() == -9 || this.getValueType() == -10 || this.getValueType() == -11) {
            this.value = value == null ? null : new ArrayList<OptionStringValue>(Arrays.asList(value));
        } else {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    @Override
    public void setValue(Object v) {
        List<OptionStringValue> vList;
        this.value = v instanceof List ? (vList = this.valueListToListValueList((List)v, false)) : v;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    @Override
    public void setValueType(int type) {
        if (this.valueType == null || this.valueType != type) {
            this.valueType = type;
            if (!this.isExtensionElement()) {
                this.setDirty(true);
                this.rebuildState = true;
            }
        }
    }

    public IConfigurationElement getValueHandlerElement() {
        if (this.valueHandlerElement == null && this.superClass != null) {
            return ((Option)this.superClass).getValueHandlerElement();
        }
        return this.valueHandlerElement;
    }

    public void setValueHandlerElement(IConfigurationElement element) {
        this.valueHandlerElement = element;
        if (!this.isExtensionElement()) {
            this.setDirty(true);
            this.rebuildState = true;
        }
    }

    @Override
    public IManagedOptionValueHandler getValueHandler() {
        if (this.valueHandler != null) {
            return this.valueHandler;
        }
        IConfigurationElement element = this.getValueHandlerElement();
        if (element != null) {
            try {
                if (element.getAttribute("valueHandler") != null) {
                    this.valueHandler = (IManagedOptionValueHandler)element.createExecutableExtension("valueHandler");
                    return this.valueHandler;
                }
            }
            catch (CoreException e) {
                ManagedBuildManager.optionValueHandlerError(element.getAttribute("valueHandler"), this.getId());
                this.valueHandler = ManagedOptionValueHandler.getManagedOptionValueHandler();
                return this.valueHandler;
            }
        }
        return ManagedOptionValueHandler.getManagedOptionValueHandler();
    }

    @Override
    public String getValueHandlerExtraArgument() {
        if (this.valueHandlerExtraArgument == null) {
            if (this.superClass != null) {
                return this.superClass.getValueHandlerExtraArgument();
            }
            return EMPTY_STRING;
        }
        return this.valueHandlerExtraArgument;
    }

    @Override
    public void setValueHandlerExtraArgument(String extraArgument) {
        if (extraArgument == null && this.valueHandlerExtraArgument == null) {
            return;
        }
        if (extraArgument == null || this.valueHandlerExtraArgument == null || !extraArgument.equals(this.valueHandlerExtraArgument)) {
            this.valueHandlerExtraArgument = extraArgument;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public String getFieldEditorId() {
        if (this.fieldEditorId == null && this.superClass != null) {
            return ((Option)this.superClass).getFieldEditorId();
        }
        return this.fieldEditorId;
    }

    @Override
    public String getFieldEditorExtraArgument() {
        if (this.fieldEditorExtraArgument == null) {
            if (this.superClass != null) {
                return this.superClass.getFieldEditorExtraArgument();
            }
            return null;
        }
        return this.fieldEditorExtraArgument;
    }

    @Override
    public void setFieldEditorExtraArgument(String extraArgument) {
        if (extraArgument == null && this.fieldEditorExtraArgument == null) {
            return;
        }
        if (extraArgument == null || this.fieldEditorExtraArgument == null || !extraArgument.equals(this.fieldEditorExtraArgument)) {
            this.fieldEditorExtraArgument = extraArgument;
            if (!this.isExtensionElement()) {
                this.isDirty = true;
                this.rebuildState = true;
            }
        }
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionOption;
    }

    public boolean isDirty() {
        if (this.isExtensionOption) {
            return false;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionOption(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "option", this.getId());
                } else {
                    ((Option)this.superClass).resolveReferences();
                }
            }
            if (this.categoryId != null) {
                this.category = this.holder.getOptionCategory(this.categoryId);
                if (this.category == null) {
                    ManagedBuildManager.outputResolveError("category", this.categoryId, "option", this.getId());
                }
            }
            try {
                IManagedConfigElement element = ManagedBuildManager.getConfigElement(this);
                switch (this.getValueType()) {
                    case 0: {
                        String val = element.getAttribute("value");
                        if (val != null) {
                            this.value = Boolean.valueOf(val);
                        }
                        if ((val = element.getAttribute("defaultValue")) != null) {
                            this.defaultValue = Boolean.valueOf(val);
                        }
                        break;
                    }
                    case 2: {
                        this.value = element.getAttribute("value");
                        this.defaultValue = element.getAttribute("defaultValue");
                        break;
                    }
                    case 1: {
                        this.value = element.getAttribute("value");
                        this.defaultValue = element.getAttribute("defaultValue");
                        IManagedConfigElement[] enumElements = element.getChildren("enumeratedOptionValue");
                        int i = 0;
                        while (i < enumElements.length) {
                            String optId = SafeStringInterner.safeIntern((String)enumElements[i].getAttribute("id"));
                            if (i == 0) {
                                this.applicableValuesList = new ArrayList<String>();
                                if (this.defaultValue == null) {
                                    this.defaultValue = optId;
                                }
                            }
                            this.applicableValuesList.add(optId);
                            this.getCommandMap().put(optId, SafeStringInterner.safeIntern((String)enumElements[i].getAttribute("command")));
                            this.getNameMap().put(optId, SafeStringInterner.safeIntern((String)enumElements[i].getAttribute("name")));
                            Boolean isDefault = Boolean.valueOf(enumElements[i].getAttribute("isDefault"));
                            if (isDefault.booleanValue()) {
                                this.defaultValue = optId;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 12: {
                        this.value = element.getAttribute("value");
                        this.defaultValue = element.getAttribute("defaultValue");
                        IManagedConfigElement[] treeRootConfigs = element.getChildren("treeOptionRoot");
                        if (treeRootConfigs != null && treeRootConfigs.length == 1) {
                            IManagedConfigElement treeRootConfig = treeRootConfigs[0];
                            this.treeRoot = new TreeRoot(treeRootConfig, element, this.getParent() instanceof IToolChain);
                            this.applicableValuesList = new ArrayList<String>();
                            Option.iterateOnTree(this.treeRoot, new ITreeNodeIterator(){

                                @Override
                                public void iterateOnNode(IOption.ITreeOption node) {
                                }

                                @Override
                                public void iterateOnLeaf(IOption.ITreeOption leafNode) {
                                    Option.this.applicableValuesList.add(leafNode.getID());
                                    Option.this.getCommandMap().put(leafNode.getID(), leafNode.getCommand());
                                    Option.this.getNameMap().put(leafNode.getID(), leafNode.getName());
                                }
                            });
                        }
                        break;
                    }
                    case -11: 
                    case -10: 
                    case -9: 
                    case -8: 
                    case -5: 
                    case -4: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        IManagedConfigElement[] vElements;
                        ArrayList<OptionStringValue> vList = null;
                        IManagedConfigElement[] iManagedConfigElementArray = vElements = element.getChildren("listOptionValue");
                        int n = vElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            OptionStringValue ve;
                            IManagedConfigElement vElement = iManagedConfigElementArray[n2];
                            if (vList == null) {
                                vList = new ArrayList<OptionStringValue>();
                                this.builtIns = new ArrayList<OptionStringValue>();
                            }
                            if ((ve = new OptionStringValue(vElement)).isBuiltIn()) {
                                this.builtIns.add(ve);
                            } else {
                                vList.add(ve);
                            }
                            ++n2;
                        }
                        this.value = vList;
                        break;
                    }
                }
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    protected boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    private void verify() {
        if (this.verified) {
            return;
        }
        this.verified = true;
        if (this.getOptionHolder() instanceof IToolChain && !this.isAbstract()) {
            if (this.getCategory() == null) {
                ManagedBuildManager.optionValidError(0, this.getId());
                this.isValid = false;
            }
            if (this.resourceFilter != null) {
                switch (this.getResourceFilter()) {
                    case 1: {
                        ManagedBuildManager.optionValidError(1, this.getId());
                        this.isValid = false;
                    }
                }
            }
        }
    }

    @Override
    public boolean isValid() {
        if (!this.verified && this.resolved) {
            this.verify();
        }
        return this.isValid;
    }

    public boolean wasOptRef() {
        return this.wasOptRef;
    }

    public void setWasOptRef(boolean was) {
        this.wasOptRef = was;
    }

    @Override
    public Version getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator(boolean isExtensionAdjustment) {
        if (this.booleanExpressionCalculator == null && !isExtensionAdjustment && this.superClass != null) {
            return ((Option)this.superClass).getBooleanExpressionCalculator(isExtensionAdjustment);
        }
        return this.booleanExpressionCalculator;
    }

    public boolean isAdjustedExtension() {
        return this.isUdjusted;
    }

    public void setAdjusted(boolean adjusted) {
        this.isUdjusted = adjusted;
    }

    public void setSuperClass(IOption superClass) {
        if (this.superClass != superClass) {
            this.superClass = superClass;
            this.superClassId = this.superClass == null ? null : this.superClass.getId();
            if (!this.isExtensionElement()) {
                this.setDirty(true);
            }
        }
    }

    public boolean needsRebuild() {
        return this.rebuildState;
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        this.rebuildState = rebuild;
    }

    public boolean matches(IOption option) {
        block3: {
            try {
                if (option.getValueType() == this.getValueType()) break block3;
                return false;
            }
            catch (BuildException e) {
                return false;
            }
        }
        return option.getName().equals(this.getName());
    }

    @Override
    public String[] getRequiredTypeIds() {
        return new String[0];
    }

    @Override
    public String[] getSupportedTypeIds() {
        String[] referenced = null;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null) {
            referenced = calc.getReferencedPropertyIds();
        }
        if (referenced == null) {
            referenced = new String[]{};
        }
        return referenced;
    }

    @Override
    public String[] getSupportedValueIds(String typeId) {
        String[] referenced = null;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null) {
            referenced = calc.getReferencedValueIds(typeId);
        }
        if (referenced == null) {
            referenced = new String[]{};
        }
        return referenced;
    }

    @Override
    public boolean requiresType(String typeId) {
        return false;
    }

    @Override
    public boolean supportsType(String id) {
        boolean supports = false;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null && calc.referesProperty(id)) {
            supports = true;
        }
        return supports;
    }

    @Override
    public boolean supportsValue(String typeId, String valueId) {
        boolean supports = false;
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator(false);
        if (calc != null && calc.referesPropertyValue(typeId, valueId)) {
            supports = true;
        }
        return supports;
    }

    @Override
    public String[] getBasicStringListValue() throws BuildException {
        if (this.getBasicValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getValue();
        if (v == null) {
            return EMPTY_STRING_ARRAY;
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public OptionStringValue[] getBasicStringListValueElements() throws BuildException {
        if (this.getBasicValueType() != 3) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        ArrayList v = (ArrayList)this.getExactValue();
        if (v == null) {
            return EMPTY_LV_ARRAY;
        }
        return v.toArray(new OptionStringValue[v.size()]);
    }

    @Override
    public int getBasicValueType() throws BuildException {
        switch (this.getValueType()) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 12: {
                return 12;
            }
        }
        return 3;
    }

    public boolean hasCustomSettings() {
        if (this.superClass == null) {
            return true;
        }
        return this.value != null && !this.value.equals(this.superClass.getValue());
    }

    public static int getOppositeType(int type) {
        switch (type) {
            case 4: {
                return -4;
            }
            case 5: {
                return -5;
            }
            case 8: {
                return -8;
            }
            case 9: {
                return -9;
            }
            case 10: {
                return -10;
            }
            case 11: {
                return -11;
            }
            case -4: {
                return 4;
            }
            case -5: {
                return 5;
            }
            case -8: {
                return 8;
            }
            case -9: {
                return 9;
            }
            case -10: {
                return 10;
            }
            case -11: {
                return 11;
            }
        }
        return 0;
    }

    public static void iterateOnTree(IOption.ITreeOption parent, ITreeNodeIterator it) {
        IOption.ITreeOption[] children;
        it.iterateOnNode(parent);
        if (!parent.isContainer()) {
            it.iterateOnLeaf(parent);
        }
        if ((children = parent.getChildren()) != null) {
            IOption.ITreeOption[] iTreeOptionArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IOption.ITreeOption option = iTreeOptionArray[n2];
                Option.iterateOnTree(option, it);
                ++n2;
            }
        }
    }

    @Override
    public IOption.ITreeRoot getTreeRoot() throws BuildException {
        if (this.getValueType() != 12) {
            throw new BuildException(ManagedMakeMessages.getResourceString("Option.error.bad_value_type"));
        }
        if (this.treeRoot == null) {
            if (this.superClass != null) {
                return this.superClass.getTreeRoot();
            }
            return null;
        }
        return this.treeRoot;
    }

    public static interface ITreeNodeIterator {
        public void iterateOnNode(IOption.ITreeOption var1);

        public void iterateOnLeaf(IOption.ITreeOption var1);
    }

    private static class TreeOption
    implements IOption.ITreeOption {
        private String treeNodeId;
        private String treeNodeName;
        protected String description;
        protected String icon;
        protected String command;
        protected List<IOption.ITreeOption> children = null;
        private int order = 1000;
        private IOption.ITreeOption parent;

        TreeOption(IManagedConfigElement element, IOption.ITreeOption parent, boolean readTool) {
            this.treeNodeId = element.getAttribute("id");
            this.treeNodeName = element.getAttribute("name");
            this.description = element.getAttribute("description");
            this.command = element.getAttribute("command");
            this.icon = element.getAttribute("icon");
            String orderStr = element.getAttribute("order");
            if (orderStr != null && orderStr.trim().length() > 0) {
                try {
                    this.order = Integer.parseInt(orderStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.parent = parent;
            IManagedConfigElement[] treeChildren = element.getChildren("treeOption");
            if (treeChildren != null && treeChildren.length > 0) {
                this.children = new ArrayList<IOption.ITreeOption>();
                IManagedConfigElement[] iManagedConfigElementArray = treeChildren;
                int n = treeChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    IManagedConfigElement configElement = iManagedConfigElementArray[n2];
                    this.children.add(new TreeOption(configElement, this, readTool));
                    ++n2;
                }
            }
        }

        TreeOption(TreeOption clone, IOption.ITreeOption parent) {
            this.treeNodeId = clone.treeNodeId;
            this.treeNodeName = clone.treeNodeName;
            this.description = clone.description;
            this.command = clone.command;
            this.icon = clone.icon;
            this.order = clone.order;
            this.parent = parent;
            if (clone.children != null) {
                this.children = new ArrayList<IOption.ITreeOption>();
                for (IOption.ITreeOption cloneChild : clone.children) {
                    this.children.add(new TreeOption((TreeOption)cloneChild, this));
                }
            }
        }

        private TreeOption(String id, String name, IOption.ITreeOption parent) {
            this.treeNodeId = id;
            this.treeNodeName = name;
            this.parent = parent;
        }

        @Override
        public IOption.ITreeOption addChild(String id, String name) {
            TreeOption option = new TreeOption(id, name, this);
            if (this.children == null) {
                this.children = new ArrayList<IOption.ITreeOption>();
            }
            this.children.add(0, option);
            return option;
        }

        @Override
        public boolean isContainer() {
            return this.children != null && !this.children.isEmpty();
        }

        @Override
        public String getName() {
            return this.treeNodeName;
        }

        @Override
        public String getID() {
            return this.treeNodeId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public String getIcon() {
            return this.icon;
        }

        @Override
        public IOption.ITreeOption[] getChildren() {
            if (this.children == null) {
                return null;
            }
            return this.children.toArray(new IOption.ITreeOption[this.children.size()]);
        }

        @Override
        public IOption.ITreeOption getChild(String name) {
            if (this.children == null || name == null) {
                return null;
            }
            for (IOption.ITreeOption child : this.children) {
                if (!name.equals(child.getName())) continue;
                return child;
            }
            return null;
        }

        @Override
        public IOption.ITreeOption getParent() {
            return this.parent;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public void setOrder(int order) {
            this.order = order;
        }

        @Override
        public void remove() {
            ((TreeOption)this.parent).children.remove(this);
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class TreeRoot
    extends TreeOption
    implements IOption.ITreeRoot {
        private boolean selectLeafOnly = true;

        TreeRoot(IManagedConfigElement element, IManagedConfigElement buildOption, boolean readTool) {
            super(element, null, readTool);
            String leaf = element.getAttribute("selectLeafOnly");
            if (leaf != null) {
                this.selectLeafOnly = Boolean.valueOf(leaf);
            }
            String toolTip = buildOption.getAttribute("tip");
            if (this.description == null && toolTip != null) {
                this.description = toolTip;
            }
        }

        public TreeRoot() {
            super(Option.EMPTY_STRING, Option.EMPTY_STRING, null);
        }

        public TreeRoot(TreeRoot clone) {
            super(clone, null);
            this.selectLeafOnly = clone.selectLeafOnly;
        }

        @Override
        public boolean isSelectLeafsOnly() {
            return this.selectLeafOnly;
        }

        @Override
        public IOption.ITreeOption findNode(String id) {
            if (id == null) {
                return null;
            }
            return this.find(id, this.children);
        }

        private IOption.ITreeOption find(String id, List<IOption.ITreeOption> children) {
            IOption.ITreeOption found = null;
            if (children != null) {
                for (IOption.ITreeOption child : children) {
                    if (id.equals(child.getID())) {
                        found = child;
                        break;
                    }
                    found = this.find(id, ((TreeOption)child).children);
                    if (found != null) break;
                }
            }
            return found;
        }

        @Override
        public IOption.ITreeOption addNode(String id, String name, String category, Integer order) {
            IOption.ITreeOption parent = this;
            if (category != null && category.length() > 0) {
                String[] categories;
                String[] stringArray = categories = category.split("\\.");
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    String cat = stringArray[n2];
                    IOption.ITreeOption tempParent = parent.getChild(cat);
                    if (tempParent == null) {
                        tempParent = parent.addChild(cat, cat);
                        if (order != null) {
                            tempParent.setOrder(order);
                        }
                    }
                    parent = tempParent;
                    ++n2;
                }
            }
            IOption.ITreeOption child = parent.addChild(id, name);
            if (order != null) {
                child.setOrder(order);
            }
            return child;
        }
    }
}

