/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.viewport;

import net.sourceforge.nattable.layer.LayerUtil;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.viewport.ScrollBarHandlerTemplate;
import net.sourceforge.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class VerticalScrollBarHandler
extends ScrollBarHandlerTemplate
implements Listener {
    public VerticalScrollBarHandler(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        super(viewportLayer, scrollBar);
    }

    int pageScrollDistance() {
        int viewportHeight;
        int heightOfRowBeingScrolled = this.scrollableLayer.getRowHeightByPosition(this.getScrollablePosition());
        return heightOfRowBeingScrolled > (viewportHeight = this.viewportLayer.getClientAreaHeight()) ? heightOfRowBeingScrolled : viewportHeight;
    }

    int getSpanByPosition(int scrollablePosition) {
        return this.scrollableLayer.getRowHeightByPosition(scrollablePosition);
    }

    int getScrollablePosition() {
        return LayerUtil.convertRowPosition(this.viewportLayer, 0, this.scrollableLayer);
    }

    int getStartPixelOfPosition(int position) {
        return this.scrollableLayer.getStartYOfRowPosition(position);
    }

    int getPositionByPixel(int pixelValue) {
        return this.scrollableLayer.getRowPositionByY(pixelValue);
    }

    void setViewportOrigin(int position) {
        this.viewportLayer.invalidateVerticalStructure();
        this.viewportLayer.setOriginRowPosition(position);
        this.scrollBar.setIncrement(this.viewportLayer.getRowHeightByPosition(0));
    }

    SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int eventDetail) {
        return eventDetail == 0x1000005 || eventDetail == 0x1000001 ? SelectionLayer.MoveDirectionEnum.UP : SelectionLayer.MoveDirectionEnum.DOWN;
    }

    boolean keepScrolling() {
        return !this.viewportLayer.isLastRowCompletelyDisplayed();
    }

    int getViewportWindowSpan() {
        return this.viewportLayer.getClientAreaHeight();
    }

    int getScrollableLayerSpan() {
        return this.scrollableLayer.getHeight();
    }
}

