/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.ui.matcher;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.edit.EditConfigAttributes;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.layer.LabelStack;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.ui.matcher.IMouseEventMatcher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.swt.events.MouseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyCellEditorMouseEventMatcher
implements IMouseEventMatcher {
    private Class<?> cellEditorClass;

    public BodyCellEditorMouseEventMatcher(Class<?> cellEditorClass) {
        this.cellEditorClass = cellEditorClass;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        if (regionLabels != null && regionLabels.hasLabel("BODY")) {
            LayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
            ICellEditor cellEditor = natTable.getConfigRegistry().getConfigAttribute(EditConfigAttributes.CELL_EDITOR, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
            if (this.cellEditorClass.isInstance(cellEditor)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BodyCellEditorMouseEventMatcher)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BodyCellEditorMouseEventMatcher rhs = (BodyCellEditorMouseEventMatcher)obj;
        return new EqualsBuilder().append(this.cellEditorClass, rhs.cellEditorClass).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(43, 21).append(this.cellEditorClass).toHashCode();
    }
}

