/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public interface IQueryResultViewModelListener {
  public abstract void matcherAdded(final QueryResultTreeMatcher matcher);
  
  public abstract void matcherFilterUpdated(final QueryResultTreeMatcher matcher);
  
  public abstract void matcherRemoved(final QueryResultTreeMatcher matcher);
  
  public abstract void matchAdded(final QueryResultTreeMatcher matcher, final IPatternMatch match);
  
  public abstract void matchUpdated(final QueryResultTreeMatcher matcher, final IPatternMatch match);
  
  public abstract void matchRemoved(final QueryResultTreeMatcher matcher, final IPatternMatch match);
}
