/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeConnections<T extends NodeConnections<T>> {
    private T next;
    private T previous;
    private Set<T> copiedTo = new HashSet<T>();
    private T copiedFrom;

    public T[] getCopiedTo(T[] a) {
        return (NodeConnections[])this.copiedTo.toArray(a);
    }

    public Collection<T> getCopiedToAsCollection() {
        return new ArrayList<T>(this.copiedTo);
    }

    public T getCopiedFrom() {
        return this.copiedFrom;
    }

    public void setNext(T nextNode) {
        if (nextNode == null) {
            throw new IllegalArgumentException("Node can't be null");
        }
        if (this.next != null && this.next.equals(nextNode)) {
            return;
        }
        T tmp1 = this.next;
        T tmp2 = ((NodeConnections)nextNode).previous;
        this.next = nextNode;
        ((NodeConnections)nextNode).previous = this.convertThisToGeneric();
        if (tmp1 != null) {
            ((NodeConnections)tmp1).previous = null;
        }
        if (tmp2 != null) {
            ((NodeConnections)tmp2).next = null;
        }
        this.validate();
    }

    public void removeNext() {
        if (this.next != null) {
            ((NodeConnections)this.next).previous = null;
            this.next = null;
        }
    }

    public void setPrevious(T prevNode) {
        if (prevNode == null) {
            throw new IllegalArgumentException("Node can't be null");
        }
        ((NodeConnections)prevNode).setNext(this.convertThisToGeneric());
    }

    public void removePrevious() {
        if (this.previous != null) {
            ((NodeConnections)this.previous).next = null;
            this.previous = null;
        }
    }

    public void addCopiedTo(T node) {
        this.addCopiedTo(node, true);
    }

    protected void addCopiedTo(T node, boolean canValidate) {
        if (node == null) {
            throw new IllegalArgumentException("Node can't be null");
        }
        if (this.copiedTo.contains(node)) {
            return;
        }
        T tmp = ((NodeConnections)node).copiedFrom;
        this.copiedTo.add(node);
        ((NodeConnections)node).copiedFrom = this.convertThisToGeneric();
        if (tmp != null) {
            ((NodeConnections)tmp).removeCopiedTo(node);
        }
        if (canValidate) {
            this.validate();
        }
    }

    public void removeCopiedTo(T node) {
        if (node == null) {
            throw new IllegalArgumentException("Node can't be null");
        }
        if (!this.copiedTo.isEmpty()) {
            Iterator<T> iter = this.copiedTo.iterator();
            while (iter.hasNext()) {
                NodeConnections copyTo = (NodeConnections)iter.next();
                if (!copyTo.equals(node)) continue;
                copyTo.copiedFrom = null;
                iter.remove();
                break;
            }
        }
    }

    public void removeAllCopiedTo() {
        if (!this.copiedTo.isEmpty()) {
            Iterator<T> iter = this.copiedTo.iterator();
            while (iter.hasNext()) {
                NodeConnections copyTo = (NodeConnections)iter.next();
                copyTo.copiedFrom = null;
                iter.remove();
            }
        }
    }

    public void addCopiedTo(T[] nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("Nodes can't be null");
        }
        T[] TArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            T node = TArray[n2];
            this.addCopiedTo(node, false);
            ++n2;
        }
        this.validate();
    }

    public void setCopiedFrom(T node) {
        if (node == null) {
            throw new IllegalArgumentException("Node can't be null");
        }
        ((NodeConnections)node).addCopiedTo(this.convertThisToGeneric());
    }

    public void removeCopiedFrom() {
        if (this.copiedFrom != null) {
            ((NodeConnections)this.copiedFrom).removeCopiedTo(this.convertThisToGeneric());
        }
    }

    public T getNext() {
        return this.next;
    }

    public T getPrevious() {
        return this.previous;
    }

    public Iterator<T> iterateRevisionsChain() {
        return new Iterator<T>(){
            protected T nextNode;
            {
                this.nextNode = NodeConnections.this.getStartNodeInChain();
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object res = this.nextNode;
                this.nextNode = ((NodeConnections)this.nextNode).next;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public T getStartNodeInChain() {
        T node = this.convertThisToGeneric();
        while (((NodeConnections)node).getPrevious() != null) {
            node = ((NodeConnections)node).getPrevious();
        }
        return node;
    }

    public T getEndNodeInChain() {
        T node = this.convertThisToGeneric();
        while (((NodeConnections)node).getNext() != null) {
            node = ((NodeConnections)node).getNext();
        }
        return node;
    }

    public T getStartNodeInGraph() {
        T copiedFrom;
        T first = this.getStartNodeInChain();
        while ((copiedFrom = ((NodeConnections)first).getCopiedFrom()) != null) {
            first = ((NodeConnections)copiedFrom).getStartNodeInChain();
        }
        return first;
    }

    protected void validate() {
    }

    protected T convertThisToGeneric() {
        return (T)this;
    }

    public static <T extends NodeConnections<T>> void showGraph(T node) {
        System.out.println("\r\n------------------");
        T first = node.getStartNodeInGraph();
        NodeConnections.doShowGraph(first);
    }

    public static <T extends NodeConnections<T>> void doShowGraph(T node) {
        ArrayList<NodeConnections> nextNodes = new ArrayList<NodeConnections>();
        System.out.println();
        Iterator<T> iter = node.iterateRevisionsChain();
        while (iter.hasNext()) {
            NodeConnections start = (NodeConnections)iter.next();
            StringBuffer str = new StringBuffer();
            str.append(start);
            if (start.getCopiedFrom() != null) {
                str.append("\r\n\tcopied from node: " + start.getCopiedFrom() + ", ");
            }
            if (!start.copiedTo.isEmpty()) {
                str.append("\r\n\tcopy to nodes: ");
                for (NodeConnections copyToNode : start.copiedTo) {
                    nextNodes.add(copyToNode);
                    str.append("\r\n\t" + copyToNode);
                }
            }
            System.out.println(str);
        }
        for (NodeConnections nextNode : nextNodes) {
            NodeConnections.doShowGraph(nextNode);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends NodeConnections<T>> void showChain(T node) {
        block2: {
            str = new StringBuffer();
            start = node;
            while ((prev = start.getPrevious()) != null) {
                start = prev;
            }
            break block2;
lbl7:
            // 1 sources

            while (true) {
                str.append(start).append("\r\n");
                start = start.getNext();
                break;
            }
        }
        ** while (start != null)
lbl13:
        // 1 sources

        System.out.println(str);
    }
}

