/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSStorage;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.ByteCountOutputStream;
import org.eclipse.team.internal.ccvs.core.client.CRLFDetectInputStream;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.ConsoleListeners;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.Connection;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.core.streams.CRLFtoLFInputStream;
import org.eclipse.team.internal.core.streams.LFtoCRLFInputStream;
import org.eclipse.team.internal.core.streams.ProgressMonitorInputStream;
import org.eclipse.team.internal.core.streams.SizeConstrainedInputStream;

public class Session {
    public static final String CURRENT_LOCAL_FOLDER = ".";
    public static final String CURRENT_REMOTE_FOLDER = "";
    public static final String SERVER_SEPARATOR = "/";
    private static final int TRANSFER_BUFFER_SIZE = 8192;
    private static final int TRANSFER_PROGRESS_INCREMENT = 32768;
    public static final boolean IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").getBytes(), new byte[]{13, 10});
    private CVSRepositoryLocation location;
    private ICVSFolder localRoot;
    private boolean outputToConsole;
    private Connection connection = null;
    private String validRequests = null;
    private Date modTime = null;
    private boolean noLocalChanges = false;
    private boolean createBackups = true;
    private int compressionLevel = 0;
    private List expansions;
    private Collection textTransferOverrideSet = null;
    private boolean ignoringLocalChanges = false;
    private String sendFileTitleMessage;
    private Map responseHandlers;
    private List errors = new ArrayList();
    private Command currentCommand;

    public Session(ICVSRepositoryLocation location, ICVSFolder localRoot) {
        this(location, localRoot, true);
    }

    public Session(ICVSRepositoryLocation location, ICVSFolder localRoot, boolean outputToConsole) {
        this.location = (CVSRepositoryLocation)location;
        this.localRoot = localRoot;
        this.outputToConsole = outputToConsole;
    }

    protected void addModuleExpansion(String expansion) {
        this.expansions.add(expansion);
    }

    protected void resetModuleExpansion() {
        if (this.expansions == null) {
            this.expansions = new ArrayList();
        } else {
            this.expansions.clear();
        }
    }

    public void open(IProgressMonitor monitor) throws CVSException {
        this.open(monitor, true);
    }

    public void open(IProgressMonitor monitor, boolean writeAccess) throws CVSException {
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        boolean opened = false;
        try {
            boolean useMT;
            this.connection = this.getLocationForConnection(writeAccess).openConnection(Policy.subMonitorFor(monitor, 50));
            boolean bl = useMT = this.location.getServerPlatform() != 1;
            if (!useMT) {
                this.removeResponseHandler("MT");
            }
            this.connection.writeLine("Valid-responses " + this.makeResponseList());
            this.connection.flush();
            IStatus status = Request.VALID_REQUESTS.execute(this, Policy.subMonitorFor(monitor, 40));
            if (!status.isOK()) {
                throw new CVSException(status);
            }
            this.connection.writeLine("Root " + this.getRepositoryRoot());
            this.compressionLevel = CVSProviderPlugin.getPlugin().getCompressionLevel();
            if (this.compressionLevel != 0 && this.isValidRequest("gzip-file-contents")) {
                this.connection.writeLine("gzip-file-contents " + Integer.toString(this.compressionLevel));
            } else {
                this.compressionLevel = 0;
            }
            if (CVSProviderPlugin.getPlugin().isDetermineVersionEnabled() && this.location.getServerPlatform() == 0) {
                Command.VERSION.execute(this, this.location, Policy.subMonitorFor(monitor, 10));
            }
            opened = true;
        }
        finally {
            if (this.connection != null && !opened) {
                this.close();
            }
            monitor.done();
        }
    }

    private CVSRepositoryLocation getLocationForConnection(boolean writeAccess) {
        return this.location;
    }

    public void close() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            this.validRequests = null;
        }
    }

    public boolean isValidRequest(String request) {
        return this.validRequests == null || this.validRequests.indexOf(" " + request + " ") != -1;
    }

    public boolean isCVSNT() {
        if (this.location.getServerPlatform() == 0) {
            return this.location.getRootDirectory().indexOf(58) == 1;
        }
        return this.location.getServerPlatform() == 2;
    }

    public ICVSFolder getLocalRoot() {
        return this.localRoot;
    }

    public String[] getModuleExpansions() {
        if (this.expansions == null) {
            return new String[0];
        }
        return this.expansions.toArray(new String[this.expansions.size()]);
    }

    public String getRepositoryRoot() {
        return this.location.getRootDirectory();
    }

    public ICVSRepositoryLocation getCVSRepositoryLocation() {
        return this.location;
    }

    public String readLine() throws CVSException {
        return this.connection.readLine();
    }

    public void writeLine(String line) throws CVSException {
        this.connection.writeLine(line);
    }

    public void sendArgument(String arg) throws CVSException {
        int pos;
        this.connection.write("Argument ");
        int oldPos = 0;
        while ((pos = arg.indexOf(10, oldPos)) != -1) {
            this.connection.writeLine(this.stripTrainingCR(arg.substring(oldPos, pos)));
            this.connection.write("Argumentx ");
            oldPos = pos + 1;
        }
        this.connection.writeLine(this.stripTrainingCR(arg.substring(oldPos)));
    }

    private String stripTrainingCR(String string) {
        if (string.endsWith("\r")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void sendRequest(String requestId) throws CVSException {
        this.connection.writeLine(requestId);
        this.connection.flush();
    }

    public void sendIsModified(ICVSFile file, boolean isBinary, IProgressMonitor monitor) throws CVSException {
        if (this.isValidRequest("Is-modified")) {
            this.connection.writeLine("Is-modified " + file.getName());
        } else {
            this.sendModified(file, isBinary, monitor);
        }
    }

    public void sendStaticDirectory() throws CVSException {
        this.connection.writeLine("Static-directory");
    }

    public void sendConstructedDirectory(String localDir) throws CVSException {
        String path = Util.appendPath(this.getRepositoryRoot(), localDir);
        this.sendDirectory(localDir, path);
    }

    public void sendDirectory(String localDir, String remoteDir) throws CVSException {
        if (localDir.length() == 0) {
            localDir = CURRENT_LOCAL_FOLDER;
        }
        this.connection.writeLine("Directory " + localDir);
        this.connection.writeLine(remoteDir);
    }

    public void sendLocalRootDirectory() throws CVSException {
        this.sendDirectory(CURRENT_LOCAL_FOLDER, this.localRoot.getRemoteLocation(this.localRoot));
    }

    public void sendConstructedRootDirectory() throws CVSException {
        this.sendConstructedDirectory(CURRENT_REMOTE_FOLDER);
    }

    public void sendEntry(byte[] syncBytes, String serverTimestamp) throws CVSException {
        int start;
        this.connection.write("Entry ");
        if (serverTimestamp == null) {
            serverTimestamp = CURRENT_REMOTE_FOLDER;
        }
        if ((start = Util.getOffsetOfDelimeter(syncBytes, (byte)47, 0, 3)) == -1) {
            this.connection.writeLine(new String(syncBytes));
            return;
        }
        int end = Util.getOffsetOfDelimeter(syncBytes, (byte)47, start + 1, 1);
        if (end == -1) {
            this.connection.writeLine(new String(syncBytes));
            return;
        }
        this.connection.write(new String(syncBytes, 0, start + 1));
        this.connection.write(serverTimestamp);
        this.connection.writeLine(new String(syncBytes, end, syncBytes.length - end));
    }

    public void sendGlobalOption(String option) throws CVSException {
        this.connection.writeLine("Global_option " + option);
    }

    public void sendUnchanged(ICVSFile file) throws CVSException {
        this.connection.writeLine("Unchanged " + file.getName());
    }

    public void sendNotify(ICVSFolder parent, NotifyInfo info) throws CVSException {
        String filename = info.getName();
        this.connection.writeLine("Notify " + filename);
        this.connection.writeLine(info.getServerLine(parent));
    }

    public void sendQuestionable(ICVSResource resource) throws CVSException {
        this.connection.writeLine("Questionable " + resource.getName());
    }

    public void sendSticky(String tag) throws CVSException {
        this.connection.writeLine("Sticky " + tag);
    }

    public void sendModified(ICVSFile file, boolean isBinary, IProgressMonitor monitor) throws CVSException {
        this.sendModified(file, isBinary, true, monitor);
    }

    public void sendModified(ICVSFile file, boolean isBinary, boolean sendBinary, IProgressMonitor monitor) throws CVSException {
        String filename = file.getName();
        this.connection.writeLine("Modified " + filename);
        if (file.isExecutable()) {
            this.connection.writeLine(ResourceSyncInfo.getDefaultExecutablePermissions());
        } else {
            this.connection.writeLine(ResourceSyncInfo.getDefaultPermissions());
        }
        this.sendFile(file, isBinary, sendBinary, monitor);
    }

    public void sendFile(ICVSStorage file, boolean isBinary, boolean sendBinary, IProgressMonitor monitor) throws CVSException {
        block23: {
            if (this.textTransferOverrideSet != null && this.textTransferOverrideSet.contains(file)) {
                isBinary = false;
            }
            final String title = NLS.bind((String)this.getSendFileTitleMessage(), (Object[])new Object[]{Util.toTruncatedPath(file, this.localRoot, 3)});
            monitor.subTask(NLS.bind((String)CVSMessages.Session_transferNoSize, (Object[])new String[]{title}));
            try (InputStream in = null;){
                if (isBinary && !sendBinary) {
                    byte[] bytes = "hello".getBytes();
                    this.sendUncompressedBytes(new ByteArrayInputStream(bytes), bytes.length);
                    return;
                }
                if (this.compressionLevel == 0) {
                    long length;
                    in = file.getContents();
                    if (!isBinary && IS_CRLF_PLATFORM) {
                        byte[] buffer = new byte[8192];
                        in = new CRLFtoLFInputStream(in);
                        try (ByteCountOutputStream counter = new ByteCountOutputStream();){
                            int count;
                            while ((count = in.read(buffer)) != -1) {
                                counter.write(buffer, 0, count);
                            }
                        }
                        in.close();
                        length = counter.getSize();
                        in = new CRLFtoLFInputStream(file.getContents());
                    } else {
                        length = file.getSize();
                    }
                    in = new ProgressMonitorInputStream(in, length, 32768, monitor){

                        protected void updateMonitor(long bytesRead, long bytesTotal, IProgressMonitor monitor) {
                            if (bytesRead == 0L) {
                                return;
                            }
                            Assert.isTrue((bytesRead <= bytesTotal ? 1 : 0) != 0);
                            monitor.subTask(NLS.bind((String)CVSMessages.Session_transfer, (Object[])new Object[]{title, Long.toString(bytesRead >> 10), Long.toString(bytesTotal >> 10)}));
                        }
                    };
                    this.sendUncompressedBytes(in, length);
                    break block23;
                }
                monitor.subTask(NLS.bind((String)CVSMessages.Session_calculatingCompressedSize, (Object[])new String[]{Util.toTruncatedPath(file, this.localRoot, 3)}));
                in = file.getContents();
                byte[] buffer = new byte[8192];
                ByteCountOutputStream counter = new ByteCountOutputStream();
                GZIPOutputStream zout = new GZIPOutputStream(counter);
                if (!isBinary && IS_CRLF_PLATFORM) {
                    in = new CRLFtoLFInputStream(in);
                }
                try {
                    int count;
                    while ((count = in.read(buffer)) != -1) {
                        ((OutputStream)zout).write(buffer, 0, count);
                    }
                }
                finally {
                    ((OutputStream)zout).close();
                }
                in.close();
                in = file.getContents();
                in = new ProgressMonitorInputStream(in, file.getSize(), 32768, monitor){

                    protected void updateMonitor(long bytesRead, long bytesTotal, IProgressMonitor monitor) {
                        if (bytesRead == 0L) {
                            return;
                        }
                        Assert.isTrue((bytesRead <= bytesTotal ? 1 : 0) != 0);
                        monitor.subTask(NLS.bind((String)CVSMessages.Session_transfer, (Object[])new Object[]{title, Long.toString(bytesRead >> 10), Long.toString(bytesTotal >> 10)}));
                    }
                };
                if (!isBinary && IS_CRLF_PLATFORM) {
                    in = new CRLFtoLFInputStream(in);
                }
                this.sendCompressedBytes(in, counter.getSize());
            }
            catch (IOException e) {
                throw CVSException.wrapException(e);
            }
        }
    }

    private void sendCompressedBytes(InputStream in, long length) throws IOException, CVSException {
        int count;
        String sizeLine = "z" + Long.toString(length);
        this.writeLine(sizeLine);
        OutputStream out = this.connection.getOutputStream();
        GZIPOutputStream zo = new GZIPOutputStream(out);
        byte[] buffer = new byte[8192];
        while ((count = in.read(buffer)) != -1) {
            zo.write(buffer, 0, count);
        }
        zo.finish();
    }

    private void sendUncompressedBytes(InputStream in, long length) throws IOException, CVSException {
        int count;
        OutputStream out = this.connection.getOutputStream();
        String sizeLine = Long.toString(length);
        this.writeLine(sizeLine);
        byte[] buffer = new byte[8192];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    public void receiveFile(ICVSStorage file, boolean isBinary, int responseType, IProgressMonitor monitor) throws CVSException {
        long size;
        if (this.textTransferOverrideSet != null && this.textTransferOverrideSet.contains(file)) {
            isBinary = false;
        }
        final String title = NLS.bind((String)CVSMessages.Session_receiving, (Object[])new Object[]{Util.toTruncatedPath(file, this.localRoot, 3)});
        monitor.subTask(NLS.bind((String)CVSMessages.Session_transferNoSize, (Object[])new String[]{title}));
        boolean compressed = false;
        String sizeLine = null;
        try {
            sizeLine = this.readLine();
            if (sizeLine.charAt(0) == 'z') {
                compressed = true;
                sizeLine = sizeLine.substring(1);
            }
            size = Long.parseLong(sizeLine, 10);
        }
        catch (NumberFormatException e) {
            if (sizeLine != null && sizeLine.startsWith("E")) {
                this.handleErrorLine(sizeLine.substring(1).trim(), Status.OK_STATUS);
                return;
            }
            CVSStatus status = new CVSStatus(4, 4, CVSMessages.Session_badInt, (Throwable)e, this.localRoot);
            throw new CVSException((IStatus)status);
        }
        Object in = new SizeConstrainedInputStream(this.connection.getInputStream(), size, true);
        in = new ProgressMonitorInputStream((InputStream)in, size, 32768, monitor){

            protected void updateMonitor(long bytesRead, long bytesTotal, IProgressMonitor monitor) {
                if (bytesRead == 0L) {
                    return;
                }
                monitor.subTask(NLS.bind((String)CVSMessages.Session_transfer, (Object[])new Object[]{title, Long.toString(bytesRead >> 10), Long.toString(bytesTotal >> 10)}));
            }
        };
        if (compressed) {
            try {
                in = new GZIPInputStream((InputStream)in);
            }
            catch (IOException e) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw CVSException.wrapException(e);
            }
        }
        if (!isBinary) {
            if (IS_CRLF_PLATFORM && CVSProviderPlugin.getPlugin().isUsePlatformLineend()) {
                in = new CRLFtoLFInputStream((InputStream)in);
                in = new LFtoCRLFInputStream((InputStream)in);
            } else {
                in = new CRLFDetectInputStream((InputStream)in, file);
            }
        }
        file.setContents((InputStream)in, responseType, true, (IProgressMonitor)new NullProgressMonitor());
    }

    void setModTime(Date modTime) {
        this.modTime = modTime;
    }

    Date getModTime() {
        return this.modTime;
    }

    void setNoLocalChanges(boolean noLocalChanges) {
        this.noLocalChanges = noLocalChanges;
    }

    boolean isNoLocalChanges() {
        return this.noLocalChanges;
    }

    void setValidRequests(String validRequests) {
        this.validRequests = " " + validRequests + " ";
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    void setCreateBackups(boolean createBackups) {
        this.createBackups = createBackups;
    }

    boolean isCreateBackups() {
        return this.createBackups;
    }

    String getSendFileTitleMessage() {
        if (this.sendFileTitleMessage == null) {
            return CVSMessages.Session_sending;
        }
        return this.sendFileTitleMessage;
    }

    public void setSendFileTitleKey(String sendFileTitleMessage) {
        this.sendFileTitleMessage = sendFileTitleMessage;
    }

    public void setTextTransferOverride(Collection textTransferOverrideSet) {
        this.textTransferOverrideSet = textTransferOverrideSet;
    }

    protected Command.GlobalOption[] filterGlobalOptions(Command.GlobalOption[] globalOptions) {
        if (!Command.DO_NOT_CHANGE.isElementOf(globalOptions)) {
            Command.QuietOption quietOption = CVSProviderPlugin.getPlugin().getQuietness();
            if (quietOption != null) {
                globalOptions = quietOption.addToEnd(globalOptions);
            }
            if (this.isWatchEditEnabled() && !Command.MAKE_READ_ONLY.isElementOf(globalOptions)) {
                globalOptions = Command.MAKE_READ_ONLY.addToEnd(globalOptions);
            }
        }
        return globalOptions;
    }

    private boolean isWatchEditEnabled() {
        if (CVSProviderPlugin.getPlugin().getPluginPreferences().getBoolean("cvs.read.only")) {
            return true;
        }
        try {
            RepositoryProvider provider;
            IResource resource = this.getLocalRoot().getIResource();
            if (resource != null && resource.getType() != 8 && (provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId())) != null) {
                return ((CVSTeamProvider)provider).isWatchEditEnabled();
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    protected void setIgnoringLocalChanges(boolean b) {
        this.ignoringLocalChanges = b;
    }

    protected boolean isIgnoringLocalChanges() {
        return this.ignoringLocalChanges;
    }

    protected Map getReponseHandlers() {
        if (this.responseHandlers == null) {
            this.responseHandlers = Request.getReponseHandlerMap();
        }
        return this.responseHandlers;
    }

    private String makeResponseList() {
        StringBuffer result = new StringBuffer("ok error M E");
        Iterator elements = this.getReponseHandlers().keySet().iterator();
        while (elements.hasNext()) {
            result.append(' ');
            result.append((String)elements.next());
        }
        return result.toString();
    }

    public void registerResponseHandler(ResponseHandler handler) {
        this.getReponseHandlers().put(handler.getResponseID(), handler);
    }

    public void removeResponseHandler(String responseID) {
        this.getReponseHandlers().remove(responseID);
    }

    public ResponseHandler getResponseHandler(String responseID) {
        return (ResponseHandler)this.getReponseHandlers().get(responseID);
    }

    public void addError(IStatus status) {
        if (!status.isOK()) {
            this.errors.add(status);
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public IStatus[] getErrors() {
        return this.errors.toArray(new IStatus[this.errors.size()]);
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public void setCurrentCommand(Command c) {
        this.currentCommand = c;
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public void handleErrorLine(String line, IStatus status) {
        ConsoleListeners.getInstance().errorLineReceived(this, line, status);
    }

    public void handleResponseError(IStatus status) {
        this.addError(status);
        this.handleErrorLine(NLS.bind((String)CVSMessages.Session_0, (Object[])new String[]{status.getMessage()}), status);
    }
}

