/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.sapphire.ConversionService;
import org.eclipse.sapphire.Serialization;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DateToStringConversionServiceForProperty
extends ConversionService<Date, String> {
    private DateFormat format;

    public DateToStringConversionServiceForProperty() {
        super(Date.class, String.class);
    }

    @Override
    protected void init() {
        Serialization serialization = this.context(ValueProperty.class).getAnnotation(Serialization.class);
        this.format = new SimpleDateFormat(serialization.primary());
    }

    @Override
    public synchronized String convert(Date date) {
        return this.format.format(date);
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.getTypeClass() == Date.class && property.hasAnnotation(Serialization.class);
        }
    }
}

