/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.proxy.protocol.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.remote.proxy.protocol.core.StreamChannelManager;

public class StreamChannel {
    public static final int CAPACITY = 8192;
    private final StreamChannelManager mux;
    private final int channelId;
    private final ChannelInputStream min = new ChannelInputStream(this);
    private final ChannelOutputStream mout = new ChannelOutputStream(this);
    private boolean open;

    public StreamChannel(StreamChannelManager mux, int id) {
        this.mux = mux;
        this.channelId = id;
        this.open = true;
    }

    public int getId() {
        return this.channelId;
    }

    public InputStream getInputStream() {
        return this.min;
    }

    public OutputStream getOutputStream() {
        return this.mout;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() throws IOException {
        this.mux.sendCloseCmd(this);
    }

    void receive(byte[] buf, int len) throws IOException {
        this.min.receive(buf, len);
    }

    void request(int len) {
        this.mout.request(len);
    }

    void disconnect() {
        this.min.disconnect();
        this.mout.disconnect();
    }

    void setClosed() {
        this.open = false;
    }

    void disconnectInput() {
        this.min.disconnect();
    }

    void disconnectOutput() {
        this.mout.disconnect();
    }

    void closeInput() throws IOException {
        this.mux.sendCloseInputCmd(this);
    }

    void closeOutput() throws IOException {
        this.mux.sendCloseOutputCmd(this);
    }

    boolean isInputConnected() {
        return this.min.isConnected();
    }

    boolean isOutputConnected() {
        return this.mout.isConnected();
    }

    private class ChannelInputStream
    extends InputStream {
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();
        private final StreamChannel channel;
        private int currentPos;
        private int currentSize;
        private boolean connected = true;
        private int inputRequestCount;
        private byte[] buffer = new byte[8192];

        public ChannelInputStream(StreamChannel channel) {
            this.channel = channel;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) != 1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int available() throws IOException {
            this.lock.lock();
            try {
                int n = this.currentSize - this.currentPos;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int moreSpace;
            if (len <= 0) {
                return 0;
            }
            this.lock.lock();
            try {
                if (this.currentPos >= this.currentSize) {
                    this.currentSize = 0;
                    this.currentPos = 0;
                } else if (this.currentPos >= 4096) {
                    System.arraycopy(this.buffer, this.currentPos, this.buffer, 0, this.currentSize - this.currentPos);
                    this.currentSize -= this.currentPos;
                    this.currentPos = 0;
                }
                int freeSpace = 8192 - this.currentSize;
                moreSpace = Math.max(freeSpace - this.inputRequestCount, 0);
            }
            finally {
                this.lock.unlock();
            }
            if (moreSpace > 0) {
                StreamChannel.this.mux.sendRequestCmd(StreamChannel.this, moreSpace);
            }
            this.lock.lock();
            try {
                this.inputRequestCount += moreSpace;
                while (this.currentPos >= this.currentSize && this.connected) {
                    try {
                        this.cond.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.connected && this.currentPos >= this.currentSize) {
                    return -1;
                }
                int available = this.currentSize - this.currentPos;
                if (len < available) {
                    System.arraycopy(this.buffer, this.currentPos, b, off, len);
                    this.currentPos += len;
                    int n = len;
                    return n;
                }
                System.arraycopy(this.buffer, this.currentPos, b, off, available);
                this.currentSize = 0;
                this.currentPos = 0;
                int n = available;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.channel.closeOutput();
            this.disconnect();
        }

        void receive(byte[] buf, int len) throws IOException {
            this.lock.lock();
            try {
                if (this.currentPos > 0 && 8192 - this.currentSize < len) {
                    System.arraycopy(this.buffer, this.currentPos, this.buffer, 0, this.currentSize - this.currentPos);
                    this.currentSize -= this.currentPos;
                    this.currentPos = 0;
                }
                if (8192 - this.currentSize < len) {
                    throw new IOException("Receive buffer overflow");
                }
                System.arraycopy(buf, 0, this.buffer, this.currentSize, len);
                this.currentSize += len;
                this.inputRequestCount -= len;
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        void disconnect() {
            this.lock.lock();
            try {
                this.connected = false;
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean isConnected() {
            this.lock.lock();
            try {
                boolean bl = this.connected;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class ChannelOutputStream
    extends OutputStream {
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();
        private final StreamChannel channel;
        private int currentPos;
        private byte[] buffer = new byte[8192];
        private boolean connected = true;
        private int outputRequestCount;

        public ChannelOutputStream(StreamChannel channel) {
            this.channel = channel;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            while (this.currentPos >= 8192) {
                this.send();
            }
            this.buffer[this.currentPos++] = (byte)b;
        }

        @Override
        public synchronized void flush() throws IOException {
            while (this.currentPos > 0) {
                this.send();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        void send() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.channel.closeInput();
            this.disconnect();
        }

        void request(int len) {
            this.lock.lock();
            this.outputRequestCount += len;
            this.cond.signalAll();
            this.lock.unlock();
        }

        void disconnect() {
            this.lock.lock();
            try {
                this.connected = false;
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean isConnected() {
            this.lock.lock();
            try {
                boolean bl = this.connected;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

