/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.databinding;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingMode implements Enumerator
{
    TWO_WAY(0, "TwoWay", "TwoWay"),
    ONE_WAY(1, "OneWay", "OneWay"),
    ONE_TIME(2, "OneTime", "OneTime");

    public static final int TWO_WAY_VALUE = 0;
    public static final int ONE_WAY_VALUE = 1;
    public static final int ONE_TIME_VALUE = 2;
    private static final BindingMode[] VALUES_ARRAY;
    public static final List<BindingMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingMode[]{TWO_WAY, ONE_WAY, ONE_TIME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingMode get(int value) {
        switch (value) {
            case 0: {
                return TWO_WAY;
            }
            case 1: {
                return ONE_WAY;
            }
            case 2: {
                return ONE_TIME;
            }
        }
        return null;
    }

    private BindingMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

