/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.model.checkrules.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.marker.MarkerUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.pmf.model.checkrules.manager.LiveValidationContentAdapter;
import org.eclipse.pmf.model.checkrules.manager.RuleManager;

public class CheckRuleManager
implements RuleManager {
    private List<String> constraints;
    private String namespaceUri;
    Resource resource;
    static Logger log = Logger.getLogger(CheckRuleManager.class.getName());

    public CheckRuleManager(Resource resource) {
        this.resource = resource;
        EObject eObject = (EObject)resource.getContents().get(0);
        this.constraints = new ArrayList<String>();
        this.namespaceUri = eObject.eClass().getEPackage().getNsURI();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    private List<String> getConstraints(String namespaceUri) {
        ArrayList<String> constraintSet = new ArrayList<String>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.emf.validation.constraintProviders");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            String pluginId = extension.getContributor().getName();
            boolean isPackage = false;
            IConfigurationElement[] iConfigurationElementArray = configElements;
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configuration = iConfigurationElementArray[n4];
                if (configuration.getName().equals("constraintProvider")) {
                    IConfigurationElement childConfig;
                    IConfigurationElement[] iConfigurationElementArray2 = configuration.getChildren("package");
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        childConfig = iConfigurationElementArray2[n6];
                        if (childConfig.getAttribute("namespaceUri").equals(namespaceUri)) {
                            isPackage = true;
                        }
                        ++n6;
                    }
                    if (isPackage) {
                        iConfigurationElementArray2 = configuration.getChildren("constraints");
                        n5 = iConfigurationElementArray2.length;
                        n6 = 0;
                        while (n6 < n5) {
                            childConfig = iConfigurationElementArray2[n6];
                            IConfigurationElement[] iConfigurationElementArray3 = childConfig.getChildren("constraint");
                            int n7 = iConfigurationElementArray3.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                IConfigurationElement childConstraint = iConfigurationElementArray3[n8];
                                constraintSet.add(String.valueOf(pluginId) + "." + childConstraint.getAttribute("id"));
                                ++n8;
                            }
                            ++n6;
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return constraintSet;
    }

    @Override
    public void enableConstraint(String id) {
        ConstraintRegistry.getInstance().getDescriptor(id).setEnabled(true);
    }

    @Override
    public void disableConstraint(String id) {
        ConstraintRegistry.getInstance().getDescriptor(id).setEnabled(false);
    }

    @Override
    public IStatus invokeModelChecking() {
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setOption(IBatchValidator.OPTION_INCLUDE_LIVE_CONSTRAINTS, (Object)true);
        validator.setOption(IBatchValidator.OPTION_TRACK_RESOURCES, (Object)true);
        IStatus status = validator.validate((Collection)this.resource.getContents());
        try {
            MarkerUtil.updateMarkers((IStatus)status);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return status;
    }

    @Override
    public void enableAutoChecking() {
        if (!this.resourceHasAdapter(this.resource)) {
            LiveValidationContentAdapter liveValidationContentAdapter = new LiveValidationContentAdapter(this.resource);
            this.resource.eAdapters().add((Object)liveValidationContentAdapter);
        }
    }

    @Override
    public void disableAutoChecking() {
        ArrayList<LiveValidationContentAdapter> adapters = new ArrayList<LiveValidationContentAdapter>();
        for (Adapter next : this.resource.eAdapters()) {
            if (!(next instanceof LiveValidationContentAdapter)) continue;
            adapters.add((LiveValidationContentAdapter)next);
        }
        this.resource.eAdapters().removeAll(adapters);
    }

    private boolean resourceHasAdapter(Resource r) {
        for (Adapter next : r.eAdapters()) {
            if (!(next instanceof LiveValidationContentAdapter)) continue;
            return true;
        }
        return false;
    }
}

