/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.assistants.generator;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.filters.CompoundFilter;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.filters.FiltersFactory;
import org.eclipse.papyrus.infra.filters.OperatorKind;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistedElementTypeFilter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ElementTypeFilter;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.uml.filters.ProfileApplied;
import org.eclipse.papyrus.uml.filters.UMLFiltersFactory;
import org.eclipse.papyrus.uml.profile.assistants.generator.ModelingAssistantProviderRule;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class FiltersUtil {
    @Extension
    private static FiltersFactory filtersFactory = FiltersFactory.eINSTANCE;
    @Extension
    private static UMLFiltersFactory umlFiltersFactory = UMLFiltersFactory.eINSTANCE;
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private UML _uML;
    @Inject
    @Extension
    private ModelingAssistantProviderRule _modelingAssistantProviderRule;
    private final HashMap<ArrayList<?>, ElementTypeFilter> _createCache_toElementTypeFilter = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, ElementTypeFilter> _createCache_internalToFilter = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, ElementTypeFilter> _createCache_internalToFilter_1 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, CompoundFilter> _createCache_toFilter = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, ProfileApplied> _createCache_toAppliedFilter = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, AssistedElementTypeFilter> _createCache_toAssistedElementTypeFilter = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementTypeFilter toElementTypeFilter(String typeID, Profile umlProfile) {
        ElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{typeID, umlProfile});
        HashMap<ArrayList<?>, ElementTypeFilter> hashMap = this._createCache_toElementTypeFilter;
        synchronized (hashMap) {
            ElementTypeFilter _createElementTypeFilter;
            if (this._createCache_toElementTypeFilter.containsKey(_cacheKey)) {
                return this._createCache_toElementTypeFilter.get(_cacheKey);
            }
            _result = _createElementTypeFilter = assistantFactory.createElementTypeFilter();
            this._createCache_toElementTypeFilter.put(_cacheKey, _result);
        }
        this._init_toElementTypeFilter(_result, typeID, umlProfile);
        return _result;
    }

    private void _init_toElementTypeFilter(ElementTypeFilter it, String typeID, Profile umlProfile) {
        it.setElementTypeID(typeID);
        int _lastIndexOf = typeID.lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        it.setName(typeID.substring(_plus));
        this._modelingAssistantProviderRule.toModelingAssistantProvider(this._uML.getRootProfile((NamedElement)umlProfile)).getOwnedFilters().add((Object)it);
    }

    public ElementTypeFilter toFilter(IElementType elementType, Profile umlProfile) {
        return this.internalToFilter(elementType, this._uML.getRootProfile((NamedElement)umlProfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementTypeFilter internalToFilter(IElementType elementType, Profile rootProfile) {
        ElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{elementType, rootProfile});
        HashMap<ArrayList<?>, ElementTypeFilter> hashMap = this._createCache_internalToFilter;
        synchronized (hashMap) {
            ElementTypeFilter _createElementTypeFilter;
            if (this._createCache_internalToFilter.containsKey(_cacheKey)) {
                return this._createCache_internalToFilter.get(_cacheKey);
            }
            _result = _createElementTypeFilter = assistantFactory.createElementTypeFilter();
            this._createCache_internalToFilter.put(_cacheKey, _result);
        }
        this._init_internalToFilter(_result, elementType, rootProfile);
        return _result;
    }

    private void _init_internalToFilter(ElementTypeFilter it, IElementType elementType, Profile rootProfile) {
        it.setElementTypeID(elementType.getId());
        it.setName(elementType.getDisplayName());
        this._modelingAssistantProviderRule.toModelingAssistantProvider(rootProfile).getOwnedFilters().add((Object)it);
    }

    public ElementTypeFilter toFilter(ElementTypeConfiguration elementType, Profile umlProfile) {
        return this.internalToFilter(elementType, this._uML.getRootProfile((NamedElement)umlProfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementTypeFilter internalToFilter(ElementTypeConfiguration elementType, Profile rootProfile) {
        ElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{elementType, rootProfile});
        HashMap<ArrayList<?>, ElementTypeFilter> hashMap = this._createCache_internalToFilter_1;
        synchronized (hashMap) {
            ElementTypeFilter _createElementTypeFilter;
            if (this._createCache_internalToFilter_1.containsKey(_cacheKey)) {
                return this._createCache_internalToFilter_1.get(_cacheKey);
            }
            _result = _createElementTypeFilter = assistantFactory.createElementTypeFilter();
            this._createCache_internalToFilter_1.put(_cacheKey, _result);
        }
        this._init_internalToFilter_1(_result, elementType, rootProfile);
        return _result;
    }

    private void _init_internalToFilter_1(ElementTypeFilter it, ElementTypeConfiguration elementType, Profile rootProfile) {
        it.setElementTypeID(elementType.getIdentifier());
        it.setName(elementType.getName());
        this._modelingAssistantProviderRule.toModelingAssistantProvider(rootProfile).getOwnedFilters().add((Object)it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundFilter toFilter(Profile umlProfile) {
        CompoundFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, CompoundFilter> hashMap = this._createCache_toFilter;
        synchronized (hashMap) {
            CompoundFilter _createCompoundFilter;
            if (this._createCache_toFilter.containsKey(_cacheKey)) {
                return this._createCache_toFilter.get(_cacheKey);
            }
            _result = _createCompoundFilter = filtersFactory.createCompoundFilter();
            this._createCache_toFilter.put(_cacheKey, _result);
        }
        this._init_toFilter(_result, umlProfile);
        return _result;
    }

    private void _init_toFilter(CompoundFilter it, Profile umlProfile) {
        it.setOperator(OperatorKind.OR);
        String _qualifiedName = umlProfile.getQualifiedName();
        String _plus = "pertains to Profile " + _qualifiedName;
        it.setName(_plus);
        CollectionExtensions.addAll((Collection)it.getOwnedFilters(), (Object[])new Filter[]{this.toAppliedFilter(umlProfile), this.toAssistedElementTypeFilter(umlProfile)});
        this._modelingAssistantProviderRule.toModelingAssistantProvider(this._uML.getRootProfile((NamedElement)umlProfile)).getOwnedFilters().add((Object)it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileApplied toAppliedFilter(Profile umlProfile) {
        ProfileApplied _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, ProfileApplied> hashMap = this._createCache_toAppliedFilter;
        synchronized (hashMap) {
            ProfileApplied _createProfileApplied;
            if (this._createCache_toAppliedFilter.containsKey(_cacheKey)) {
                return this._createCache_toAppliedFilter.get(_cacheKey);
            }
            _result = _createProfileApplied = umlFiltersFactory.createProfileApplied();
            this._createCache_toAppliedFilter.put(_cacheKey, _result);
        }
        this._init_toAppliedFilter(_result, umlProfile);
        return _result;
    }

    private void _init_toAppliedFilter(ProfileApplied it, Profile umlProfile) {
        it.setProfileURI(EcoreUtil.getURI((EObject)umlProfile).toString());
        it.setProfileQualifiedName(umlProfile.getQualifiedName());
        String _qualifiedName = umlProfile.getQualifiedName();
        String _plus = String.valueOf(_qualifiedName) + " is applied in context";
        it.setName(_plus);
    }

    protected Filter _andProfileApplied(Void filter, Profile umlProfile) {
        return null;
    }

    protected Filter _andProfileApplied(Filter filter, Profile umlProfile) {
        CompoundFilter _filter = this.toFilter(umlProfile);
        return this.operator_and((Filter)_filter, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssistedElementTypeFilter toAssistedElementTypeFilter(Profile umlProfile) {
        AssistedElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, AssistedElementTypeFilter> hashMap = this._createCache_toAssistedElementTypeFilter;
        synchronized (hashMap) {
            AssistedElementTypeFilter _createAssistedElementTypeFilter;
            if (this._createCache_toAssistedElementTypeFilter.containsKey(_cacheKey)) {
                return this._createCache_toAssistedElementTypeFilter.get(_cacheKey);
            }
            _result = _createAssistedElementTypeFilter = assistantFactory.createAssistedElementTypeFilter();
            this._createCache_toAssistedElementTypeFilter.put(_cacheKey, _result);
        }
        this._init_toAssistedElementTypeFilter(_result, umlProfile);
        return _result;
    }

    private void _init_toAssistedElementTypeFilter(AssistedElementTypeFilter it, Profile umlProfile) {
    }

    protected boolean _isCompound(Void filter) {
        return false;
    }

    protected boolean _isCompound(Filter filter) {
        return false;
    }

    protected boolean _isCompound(CompoundFilter filter) {
        return true;
    }

    protected Filter _reduce(Void filter) {
        return null;
    }

    protected Filter _reduce(Filter filter) {
        return filter;
    }

    protected Filter _reduce(CompoundFilter filter) {
        CompoundFilter _switchResult = null;
        int _size = filter.getFilters().size();
        switch (_size) {
            case 0: {
                _switchResult = null;
                break;
            }
            case 1: {
                _switchResult = (Filter)filter.getFilters().get(0);
                break;
            }
            default: {
                _switchResult = filter;
            }
        }
        return _switchResult;
    }

    private boolean add(CompoundFilter compound, Filter other) {
        boolean _xifexpression = false;
        EObject _eContainer = other.eContainer();
        boolean _notEquals = !Objects.equal((Object)_eContainer, null);
        _xifexpression = _notEquals ? compound.getFilters().add((Object)other) : compound.getOwnedFilters().add((Object)other);
        return _xifexpression;
    }

    private Boolean addAll(final CompoundFilter compound, CompoundFilter other) {
        boolean _notEquals;
        boolean _xifexpression = false;
        EObject _eContainer = other.eContainer();
        boolean bl = _notEquals = !Objects.equal((Object)_eContainer, null);
        if (_notEquals) {
            Consumer<Filter> _function = new Consumer<Filter>(){

                @Override
                public void accept(Filter it) {
                    FiltersUtil.this.add(compound, it);
                }
            };
            other.getFilters().forEach((Consumer)_function);
        } else {
            boolean _xblockexpression = false;
            compound.getOwnedFilters().addAll((Collection)other.getOwnedFilters());
            _xifexpression = _xblockexpression = compound.getFilters().addAll((Collection)other.getFilters());
        }
        return _xifexpression;
    }

    protected Filter _operator_or(Void left, Filter right) {
        return right;
    }

    protected Filter _operator_or(Filter left, Filter right) {
        return this.createOr(left, right);
    }

    private CompoundFilter createOr(final Filter left, final Filter right) {
        CompoundFilter _createCompoundFilter = filtersFactory.createCompoundFilter();
        Procedures.Procedure1<CompoundFilter> _function = new Procedures.Procedure1<CompoundFilter>(){

            public void apply(CompoundFilter it) {
                it.setOperator(OperatorKind.OR);
                FiltersUtil.this.add(it, left);
                FiltersUtil.this.add(it, right);
            }
        };
        return (CompoundFilter)ObjectExtensions.operator_doubleArrow((Object)_createCompoundFilter, (Procedures.Procedure1)_function);
    }

    protected Filter _operator_or(CompoundFilter left, Filter right) {
        CompoundFilter _switchResult = null;
        OperatorKind _operator = left.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case OR: {
                    CompoundFilter _xblockexpression = null;
                    this.add(left, right);
                    _switchResult = _xblockexpression = left;
                    break;
                }
                default: {
                    _switchResult = this.createOr((Filter)left, right);
                    break;
                }
            }
        } else {
            _switchResult = this.createOr((Filter)left, right);
        }
        return _switchResult;
    }

    protected Filter _operator_or(Filter left, CompoundFilter right) {
        CompoundFilter _switchResult = null;
        OperatorKind _operator = right.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case OR: {
                    CompoundFilter _xblockexpression = null;
                    this.add(right, left);
                    _switchResult = _xblockexpression = right;
                    break;
                }
                default: {
                    _switchResult = this.createOr(left, (Filter)right);
                    break;
                }
            }
        } else {
            _switchResult = this.createOr(left, (Filter)right);
        }
        return _switchResult;
    }

    protected Filter _operator_or(CompoundFilter left, CompoundFilter right) {
        CompoundFilter _switchResult = null;
        OperatorKind _operator = left.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case OR: {
                    CompoundFilter _xblockexpression = null;
                    OperatorKind _operator_1 = right.getOperator();
                    if (_operator_1 != null) {
                        switch (_operator_1) {
                            case OR: {
                                EObject _eContainer = right.eContainer();
                                boolean _equals = Objects.equal((Object)_eContainer, null);
                                if (_equals) {
                                    this.addAll(left, right);
                                    break;
                                }
                                this.add(left, (Filter)right);
                                break;
                            }
                            default: {
                                this.add(left, (Filter)right);
                                break;
                            }
                        }
                    } else {
                        this.add(left, (Filter)right);
                    }
                    _switchResult = _xblockexpression = left;
                    break;
                }
                default: {
                    _switchResult = this.createOr((Filter)left, (Filter)right);
                    break;
                }
            }
        } else {
            _switchResult = this.createOr((Filter)left, (Filter)right);
        }
        return _switchResult;
    }

    protected Filter _operator_and(Void left, Filter right) {
        return right;
    }

    protected Filter _operator_and(Filter left, Filter right) {
        return this.createAnd(left, right);
    }

    private CompoundFilter createAnd(final Filter left, final Filter right) {
        CompoundFilter _createCompoundFilter = filtersFactory.createCompoundFilter();
        Procedures.Procedure1<CompoundFilter> _function = new Procedures.Procedure1<CompoundFilter>(){

            public void apply(CompoundFilter it) {
                it.setOperator(OperatorKind.AND);
                FiltersUtil.this.add(it, left);
                FiltersUtil.this.add(it, right);
            }
        };
        return (CompoundFilter)ObjectExtensions.operator_doubleArrow((Object)_createCompoundFilter, (Procedures.Procedure1)_function);
    }

    protected Filter _operator_and(CompoundFilter left, Filter right) {
        CompoundFilter _switchResult = null;
        OperatorKind _operator = left.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case AND: {
                    CompoundFilter _xblockexpression = null;
                    this.add(left, right);
                    _switchResult = _xblockexpression = left;
                    break;
                }
                default: {
                    _switchResult = this.createAnd((Filter)left, right);
                    break;
                }
            }
        } else {
            _switchResult = this.createAnd((Filter)left, right);
        }
        return _switchResult;
    }

    protected Filter _operator_and(Filter left, CompoundFilter right) {
        CompoundFilter _switchResult = null;
        OperatorKind _operator = right.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case AND: {
                    CompoundFilter _xblockexpression = null;
                    this.add(right, left);
                    _switchResult = _xblockexpression = right;
                    break;
                }
                default: {
                    _switchResult = this.createAnd(left, (Filter)right);
                    break;
                }
            }
        } else {
            _switchResult = this.createAnd(left, (Filter)right);
        }
        return _switchResult;
    }

    protected Filter _operator_and(CompoundFilter left, CompoundFilter right) {
        CompoundFilter _switchResult = null;
        OperatorKind _operator = left.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case AND: {
                    CompoundFilter _xblockexpression = null;
                    OperatorKind _operator_1 = right.getOperator();
                    if (_operator_1 != null) {
                        switch (_operator_1) {
                            case AND: {
                                EObject _eContainer = right.eContainer();
                                boolean _equals = Objects.equal((Object)_eContainer, null);
                                if (_equals) {
                                    this.addAll(left, right);
                                    break;
                                }
                                this.add(left, (Filter)right);
                                break;
                            }
                            default: {
                                this.add(left, (Filter)right);
                                break;
                            }
                        }
                    } else {
                        this.add(left, (Filter)right);
                    }
                    _switchResult = _xblockexpression = left;
                    break;
                }
                default: {
                    _switchResult = this.createAnd((Filter)left, (Filter)right);
                    break;
                }
            }
        } else {
            _switchResult = this.createAnd((Filter)left, (Filter)right);
        }
        return _switchResult;
    }

    public Filter andProfileApplied(Filter filter, Profile umlProfile) {
        if (filter != null) {
            return this._andProfileApplied(filter, umlProfile);
        }
        if (filter == null) {
            return this._andProfileApplied((Void)null, umlProfile);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(filter, umlProfile).toString());
    }

    public boolean isCompound(Filter filter) {
        if (filter instanceof CompoundFilter) {
            return this._isCompound((CompoundFilter)filter);
        }
        if (filter != null) {
            return this._isCompound(filter);
        }
        if (filter == null) {
            return this._isCompound((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(filter).toString());
    }

    public Filter reduce(Filter filter) {
        if (filter instanceof CompoundFilter) {
            return this._reduce((CompoundFilter)filter);
        }
        if (filter != null) {
            return this._reduce(filter);
        }
        if (filter == null) {
            return this._reduce((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(filter).toString());
    }

    public Filter operator_or(Filter left, Filter right) {
        if (left instanceof CompoundFilter && right instanceof CompoundFilter) {
            return this._operator_or((CompoundFilter)left, (CompoundFilter)right);
        }
        if (left instanceof CompoundFilter && right != null) {
            return this._operator_or((CompoundFilter)left, right);
        }
        if (left != null && right instanceof CompoundFilter) {
            return this._operator_or(left, (CompoundFilter)right);
        }
        if (left != null && right != null) {
            return this._operator_or(left, right);
        }
        if (left == null && right != null) {
            return this._operator_or((Void)null, right);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(left, right).toString());
    }

    public Filter operator_and(Filter left, Filter right) {
        if (left instanceof CompoundFilter && right instanceof CompoundFilter) {
            return this._operator_and((CompoundFilter)left, (CompoundFilter)right);
        }
        if (left instanceof CompoundFilter && right != null) {
            return this._operator_and((CompoundFilter)left, right);
        }
        if (left != null && right instanceof CompoundFilter) {
            return this._operator_and(left, (CompoundFilter)right);
        }
        if (left != null && right != null) {
            return this._operator_and(left, right);
        }
        if (left == null && right != null) {
            return this._operator_and((Void)null, right);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(left, right).toString());
    }
}

