/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevalidateAction
extends ValidateAction {
    private static final String MARKER_TYPE = "org.eclipse.core.resources.problemmarker";
    private static final String ELEMENT_URI = "elementuri";
    private static final String CONSTRAINT_NAME = "constraintname";
    private final Collection<EObject> contextObjects;
    private final String constraintName;
    private final org.eclipse.ocl.ecore.OCLExpression invariant;
    private final OppositeEndFinder oppositeEndFinder;
    private final OCLFactory oclFactory;

    public RevalidateAction(String constraintName, Collection<EObject> contextObjects, org.eclipse.ocl.ecore.OCLExpression invariant, OCLFactory oclFactory, OppositeEndFinder oppositeEndFinder) {
        this.contextObjects = contextObjects;
        this.constraintName = constraintName;
        this.invariant = invariant;
        this.oclFactory = oclFactory;
        this.oppositeEndFinder = oppositeEndFinder;
    }

    public void run() {
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    RevalidateAction.this.validateConstraints(progressMonitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.eclipseResourcesUtil != null) {
            runnableWithProgress = this.eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
        }
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
    }

    private void validateConstraints(IProgressMonitor progressMonitor) throws CoreException {
        int selectionSize = this.contextObjects.size();
        progressMonitor.beginTask("", selectionSize);
        OCL ocl = this.oclFactory.createOCL(this.oppositeEndFinder);
        for (EObject eObject : this.contextObjects) {
            System.out.println("Re-validating " + this.constraintName + " on " + EcoreUtil.getURI((EObject)eObject));
            IFile fileForContext = this.getFile(eObject);
            URI eObjectURI = EcoreUtil.getURI((EObject)eObject);
            this.removeMarker(eObjectURI, fileForContext);
            boolean valid = (Boolean)ocl.evaluate((Object)eObject, (OCLExpression)this.invariant);
            if (valid || fileForContext == null) continue;
            IMarker marker = fileForContext.createMarker(MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)("Constraint " + this.constraintName + " violated on " + eObject));
            marker.setAttribute(CONSTRAINT_NAME, (Object)this.constraintName);
            marker.setAttribute(ELEMENT_URI, (Object)eObjectURI.toString());
        }
    }

    private void removeMarker(URI eObjectURI, IFile fileForContext) throws CoreException {
        IMarker[] markers = fileForContext.findMarkers(MARKER_TYPE, false, 0);
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.getAttribute(CONSTRAINT_NAME, "").equals(this.constraintName) && marker.getAttribute(ELEMENT_URI, "").equals(eObjectURI.toString())) {
                    marker.delete();
                }
                ++n2;
            }
        }
    }

    private IFile getFile(EObject eObject) {
        URI uri = EcoreUtil.getURI((EObject)eObject);
        String platformResourceString = uri.toPlatformString(true);
        return platformResourceString != null ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString)) : null;
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
        String parentMessage;
        String message = diagnostic.getMessage();
        if (parentDiagnostic != null && (parentMessage = parentDiagnostic.getMessage()) != null) {
            message = message != null ? String.valueOf(parentMessage) + ". " + message : parentMessage;
        }
        return message;
    }

    protected void createMarkers(IResource resource, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        if (resource != null && resource.exists()) {
            IMarker marker = resource.createMarker(MARKER_TYPE);
            int severity = diagnostic.getSeverity();
            if (severity < 2) {
                marker.setAttribute("severity", 0);
            } else if (severity < 4) {
                marker.setAttribute("severity", 1);
            } else {
                marker.setAttribute("severity", 2);
            }
            String message = this.composeMessage(diagnostic, parentDiagnostic);
            if (message != null) {
                marker.setAttribute("message", (Object)message);
            }
        }
    }
}

