/*******************************************************************************
 * Copyright (c) 2008-2010 Sonatype, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *      Sonatype, Inc. - initial API and implementation
 *******************************************************************************/

package org.eclipse.m2e.core.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;


/**
 * @author Eugene Kuleshov
 */
public class MavenVersionDecorator implements ILabelDecorator {

  private Map<ILabelProviderListener, IMavenProjectChangedListener> listeners = new HashMap<ILabelProviderListener, IMavenProjectChangedListener>();

  public Image decorateImage(Image image, Object element) {
    return null;
  }

  public String decorateText(String text, Object element) {
    if(element instanceof IResource) {
      IResource resource = (IResource) element;
      IProject project = resource.getProject();
      if(project != null) {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade facade = projectManager.create(project, new NullProgressMonitor());
        if(facade != null) {
          ArtifactKey mavenProject = facade.getArtifactKey();
          if(mavenProject != null) {
            String name = resource.getName();
            int start = text.indexOf(name);
            if(start > -1) {
              int n = text.indexOf(' ', start + name.length());
              if(n > -1) {
                return text.substring(0, n) + "  " + mavenProject.getVersion() + text.substring(n); //$NON-NLS-1$
              }
            }
            return text + "  " + mavenProject.getVersion(); //$NON-NLS-1$
          }
        }
      }
    }
    return null;
  }

  public boolean isLabelProperty(Object element, String property) {
    return false;
  }

  public void addListener(final ILabelProviderListener listener) {
    IMavenProjectChangedListener projectChangeListener = new IMavenProjectChangedListener() {
      public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        ArrayList<IResource> pomList = new ArrayList<IResource>();
        for(int i = 0; i < events.length; i++ ) {
          // pomList.add(events[i].getSource());
          if(events[i] != null && events[i].getMavenProject() != null) {
            IFile pom = events[i].getMavenProject().getPom();
            pomList.add(pom);
            if(pom.getParent().getType() == IResource.PROJECT) {
              pomList.add(pom.getParent());
            }
          }
        }
        listener.labelProviderChanged(new LabelProviderChangedEvent(MavenVersionDecorator.this, pomList.toArray()));
      }
    };

    listeners.put(listener, projectChangeListener);

    IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
    projectManager.addMavenProjectChangedListener(projectChangeListener);
  }

  public void removeListener(ILabelProviderListener listener) {
    IMavenProjectChangedListener projectChangeListener = listeners.get(listener);
    if(projectChangeListener != null) {
      IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
      projectManager.removeMavenProjectChangedListener(projectChangeListener);
    }
  }

  public void dispose() {
    // TODO remove all listeners
  }

}
