/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.model;

import org.eclipse.linuxtools.internal.perf.model.PMLineRef;
import org.eclipse.linuxtools.internal.perf.model.TreeParent;

public class PMSymbol
extends TreeParent {
    private boolean pathConflictFound = false;

    public String getFunctionName() {
        int argloc;
        String tmpName = this.getName();
        if (tmpName.startsWith("[")) {
            tmpName = tmpName.substring(4);
        }
        if ((argloc = tmpName.indexOf(40)) != -1) {
            tmpName = tmpName.substring(0, argloc);
        }
        return tmpName;
    }

    public PMSymbol(String symbolName, float pc, double samples) {
        super(symbolName, pc, samples);
    }

    public void addPercent(Integer lineNum, Float percent) {
        PMLineRef current = (PMLineRef)this.getChild(lineNum.toString());
        if (current == null) {
            current = new PMLineRef(lineNum, percent.floatValue());
            this.addChild(current);
        } else {
            current.addPercent(percent);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getPercent()) + "% (" + this.getFormattedSamples() + " samples) in " + this.getName() + (this.pathConflictFound ? "(Warning multiple paths found for this symbol!)" : "");
    }

    public void markConflict() {
        this.pathConflictFound = true;
    }

    public boolean conflicted() {
        return this.pathConflictFound;
    }
}

