/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.dependencies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.core.model.IPackageImport;
import org.eclipse.libra.framework.editor.core.model.IServiceReference;
import org.eclipse.libra.framework.editor.ui.internal.SearchControl;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependency;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyContentResult;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.PackageBundleDependency;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.ServiceReferenceBundleDependency;
import org.eclipse.ui.internal.ide.StringMatcher;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDependencyContentProvider
implements IGraphContentProvider,
ISelectionChangedListener {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private Map<Long, IBundle> bundles;
    private BundleDependencyContentResult contentResult;
    private Map<IBundle, Set<BundleDependency>> dependenciesByBundle;
    private int incomingDependencyDegree = 1;
    private int outgoingDependencyDegree = 1;
    private final SearchControl searchControl;
    private Set<BundleDependency> selectedDependencies = new HashSet<BundleDependency>();
    private boolean showPackage = true;
    private boolean showServices = false;
    private final GraphViewer viewer;

    public BundleDependencyContentProvider(GraphViewer viewer, SearchControl control) {
        this.viewer = viewer;
        this.searchControl = control;
    }

    public void clearSelection() {
        for (BundleDependency dep : this.selectedDependencies) {
            this.viewer.unReveal((Object)dep);
        }
        this.selectedDependencies.clear();
        Object[] objectArray = this.viewer.getNodeElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.viewer.update(node, null);
            ++n2;
        }
        objectArray = this.viewer.getConnectionElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object connection = objectArray[n2];
            this.viewer.update(connection, null);
            ++n2;
        }
    }

    public void dispose() {
    }

    public BundleDependencyContentResult getContentResult() {
        return this.contentResult;
    }

    public Object getDestination(Object rel) {
        if (rel instanceof BundleDependency) {
            return ((BundleDependency)rel).getExportingBundle();
        }
        return null;
    }

    public Object[] getElements(Object input) {
        if (input instanceof Collection) {
            HashSet<Object> alreadyProcessedBundles;
            HashSet<Object> bundlesToProcess;
            this.dependenciesByBundle = new HashMap<IBundle, Set<BundleDependency>>();
            HashSet<IBundle> bundles = new HashSet<IBundle>((Collection)input);
            if (!"type filter text".equals(this.searchControl.getSearchText().getText()) && this.searchControl.getSearchText().getText().trim().length() > 0) {
                String searchText = String.valueOf(this.searchControl.getSearchText().getText().trim()) + "*";
                StringMatcher matcher = new StringMatcher(searchText, true, false);
                for (IBundle dep : new HashSet<IBundle>(bundles)) {
                    boolean filter = true;
                    if (matcher.match(dep.getSymbolicName())) {
                        filter = false;
                    }
                    if (matcher.match(String.valueOf(dep.getSymbolicName()) + " (" + dep.getVersion() + ")")) {
                        filter = false;
                    }
                    if (!filter) continue;
                    bundles.remove(dep);
                }
            }
            this.contentResult = new BundleDependencyContentResult(bundles);
            HashSet<BundleDependency> dependencies = new HashSet<BundleDependency>();
            if (this.showPackage) {
                HashSet<Object> copy;
                bundlesToProcess = new HashSet<IBundle>(bundles);
                alreadyProcessedBundles = new HashSet<IBundle>();
                int degree = 0;
                do {
                    ++degree;
                    copy = new HashSet<IBundle>(bundlesToProcess);
                    bundlesToProcess = new HashSet();
                    for (IBundle iBundle : copy) {
                        bundlesToProcess.addAll(this.addOutgoingPackageDependencies(dependencies, iBundle, degree, alreadyProcessedBundles));
                    }
                } while (bundlesToProcess.size() > 0);
                bundlesToProcess = new HashSet<IBundle>(bundles);
                alreadyProcessedBundles = new HashSet();
                degree = 0;
                do {
                    ++degree;
                    copy = new HashSet<Object>(bundlesToProcess);
                    bundlesToProcess = new HashSet();
                    for (IBundle iBundle : copy) {
                        bundlesToProcess.addAll(this.addIncomingPackageDependencies(dependencies, iBundle, degree, alreadyProcessedBundles));
                    }
                } while (bundlesToProcess.size() > 0);
            } else if (this.showServices) {
                HashSet<Object> copy;
                bundlesToProcess = new HashSet<IBundle>(bundles);
                alreadyProcessedBundles = new HashSet();
                int degree = 0;
                do {
                    ++degree;
                    copy = new HashSet<IBundle>(bundlesToProcess);
                    bundlesToProcess = new HashSet();
                    for (IBundle iBundle : copy) {
                        bundlesToProcess.addAll(this.addOutgoingServiceDependencies(dependencies, iBundle, degree, alreadyProcessedBundles));
                    }
                } while (bundlesToProcess.size() > 0);
                bundlesToProcess = new HashSet<IBundle>(bundles);
                alreadyProcessedBundles = new HashSet();
                degree = 0;
                do {
                    ++degree;
                    copy = new HashSet<Object>(bundlesToProcess);
                    bundlesToProcess = new HashSet();
                    for (IBundle iBundle : copy) {
                        bundlesToProcess.addAll(this.addIncomingServiceDependencies(dependencies, iBundle, degree, alreadyProcessedBundles));
                    }
                } while (bundlesToProcess.size() > 0);
            }
            if ("type filter text".equals(this.searchControl.getSearchText().getText()) || this.searchControl.getSearchText().getText().trim().length() == 0) {
                this.contentResult = null;
            }
            return dependencies.toArray(new BundleDependency[dependencies.size()]);
        }
        return NO_ELEMENTS;
    }

    public Object getSource(Object rel) {
        if (rel instanceof BundleDependency) {
            return ((BundleDependency)rel).getImportingBundle();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isSelected(IBundle bundle) {
        for (BundleDependency dep : this.selectedDependencies) {
            if (!dep.getExportingBundle().equals(bundle)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected(BundleDependency deb) {
        return this.selectedDependencies != null && this.selectedDependencies.contains(deb);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (BundleDependency dep : this.selectedDependencies) {
            this.viewer.unReveal((Object)dep);
        }
        this.selectedDependencies = new HashSet<BundleDependency>();
        HashSet newSelection = new HashSet();
        for (Object selectedObject : (IStructuredSelection)event.getSelection()) {
            BundleDependency dep2;
            if (selectedObject instanceof IBundle) {
                newSelection.add(selectedObject);
                if (!this.dependenciesByBundle.containsKey(selectedObject)) continue;
                for (BundleDependency dep2 : this.dependenciesByBundle.get(selectedObject)) {
                    this.selectedDependencies.add(dep2);
                    newSelection.add(dep2.getExportingBundle());
                }
                continue;
            }
            if (!(selectedObject instanceof BundleDependency)) continue;
            dep2 = (BundleDependency)selectedObject;
            this.selectedDependencies.add(dep2);
            newSelection.add(dep2.getExportingBundle());
            newSelection.add(dep2.getImportingBundle());
        }
        Object[] objectArray = this.viewer.getNodeElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.viewer.update(node, null);
            ++n2;
        }
        objectArray = this.viewer.getConnectionElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object connection = objectArray[n2];
            this.viewer.update(connection, null);
            ++n2;
        }
        for (BundleDependency dep : this.selectedDependencies) {
            this.viewer.reveal((Object)dep);
        }
    }

    public void setBundles(Map<Long, IBundle> bundles) {
        this.bundles = new HashMap<Long, IBundle>(bundles);
    }

    public void setIncomingDependencyDegree(int degree) {
        this.incomingDependencyDegree = degree;
    }

    public void setOutgoingDependencyDegree(int degree) {
        this.outgoingDependencyDegree = degree;
    }

    public void setShowPackage(boolean showPackage) {
        this.showPackage = showPackage;
    }

    public void setShowServices(boolean showServices) {
        this.showServices = showServices;
    }

    private Set<IBundle> addIncomingPackageDependencies(Set<BundleDependency> dependencies, IBundle bundle, int degree, Set<IBundle> processedBundles) {
        if (processedBundles.contains(bundle)) {
            return Collections.emptySet();
        }
        processedBundles.add(bundle);
        HashSet<IBundle> dependentBundles = new HashSet<IBundle>();
        if (this.incomingDependencyDegree >= degree) {
            String id = bundle.getId();
            for (IBundle dependantBundle : this.bundles.values()) {
                for (IPackageImport packageImport : dependantBundle.getPackageImports()) {
                    if (!packageImport.getSupplierId().equals(id)) continue;
                    Set<Object> bundleDependencies = null;
                    if (this.dependenciesByBundle.containsKey(dependantBundle)) {
                        bundleDependencies = this.dependenciesByBundle.get(dependantBundle);
                    } else {
                        bundleDependencies = new HashSet();
                        this.dependenciesByBundle.put(dependantBundle, bundleDependencies);
                    }
                    PackageBundleDependency bundleDependency = null;
                    for (BundleDependency bundleDependency2 : bundleDependencies) {
                        if (!bundleDependency2.getExportingBundle().equals(bundle) || !(bundleDependency2 instanceof PackageBundleDependency)) continue;
                        bundleDependency = (PackageBundleDependency)bundleDependency2;
                        break;
                    }
                    if (bundleDependency == null) {
                        bundleDependency = new PackageBundleDependency(bundle, dependantBundle);
                        bundleDependencies.add(bundleDependency);
                        dependencies.add(bundleDependency);
                    }
                    this.contentResult.addIncomingDependency(degree, dependantBundle);
                    bundleDependency.addPackageImport(packageImport);
                    dependentBundles.add(dependantBundle);
                }
            }
        }
        if (this.incomingDependencyDegree > degree) {
            return dependentBundles;
        }
        return Collections.emptySet();
    }

    private Set<IBundle> addIncomingServiceDependencies(Set<BundleDependency> dependencies, IBundle bundle, int degree, Set<IBundle> processedBundles) {
        if (processedBundles.contains(bundle)) {
            return Collections.emptySet();
        }
        processedBundles.add(bundle);
        HashSet<IBundle> dependentBundles = new HashSet<IBundle>();
        if (this.incomingDependencyDegree >= degree) {
            for (IServiceReference pe : bundle.getRegisteredServices()) {
                for (Long id : pe.getUsingBundleIds()) {
                    IBundle dependantBundle = this.bundles.get(id);
                    Set<Object> bundleDependencies = null;
                    if (this.dependenciesByBundle.containsKey(bundle)) {
                        bundleDependencies = this.dependenciesByBundle.get(bundle);
                    } else {
                        bundleDependencies = new HashSet();
                        this.dependenciesByBundle.put(bundle, bundleDependencies);
                    }
                    ServiceReferenceBundleDependency bundleDependency = null;
                    for (BundleDependency bundleDependency2 : bundleDependencies) {
                        if (!bundleDependency2.getExportingBundle().equals(dependantBundle) || !(bundleDependency2 instanceof ServiceReferenceBundleDependency)) continue;
                        bundleDependency = (ServiceReferenceBundleDependency)bundleDependency2;
                        break;
                    }
                    if (bundleDependency == null) {
                        bundleDependency = new ServiceReferenceBundleDependency(bundle, dependantBundle);
                        bundleDependencies.add(bundleDependency);
                        dependencies.add(bundleDependency);
                    }
                    this.contentResult.addIncomingDependency(degree, dependantBundle);
                    bundleDependency.addServiceReferece(pe);
                    dependentBundles.add(dependantBundle);
                }
            }
        }
        if (this.incomingDependencyDegree > degree) {
            return dependentBundles;
        }
        return Collections.emptySet();
    }

    private Set<IBundle> addOutgoingPackageDependencies(Set<BundleDependency> dependencies, IBundle bundle, int degree, Set<IBundle> processedBundles) {
        if (processedBundles.contains(bundle)) {
            return Collections.emptySet();
        }
        processedBundles.add(bundle);
        HashSet<IBundle> dependentBundles = new HashSet<IBundle>();
        if (this.outgoingDependencyDegree >= degree) {
            for (IPackageImport pe : bundle.getPackageImports()) {
                IBundle dependantBundle = this.bundles.get(Long.valueOf(pe.getSupplierId()));
                if (dependantBundle == null) continue;
                Set<Object> bundleDependencies = null;
                if (this.dependenciesByBundle.containsKey(bundle)) {
                    bundleDependencies = this.dependenciesByBundle.get(bundle);
                } else {
                    bundleDependencies = new HashSet();
                    this.dependenciesByBundle.put(bundle, bundleDependencies);
                }
                PackageBundleDependency bundleDependency = null;
                for (BundleDependency bundleDependency2 : bundleDependencies) {
                    if (!bundleDependency2.getExportingBundle().equals(dependantBundle) || !(bundleDependency2 instanceof PackageBundleDependency)) continue;
                    bundleDependency = (PackageBundleDependency)bundleDependency2;
                    break;
                }
                if (bundleDependency == null) {
                    bundleDependency = new PackageBundleDependency(dependantBundle, bundle);
                    bundleDependencies.add(bundleDependency);
                    dependencies.add(bundleDependency);
                }
                this.contentResult.addOutgoingDependency(degree, dependantBundle);
                bundleDependency.addPackageImport(pe);
                dependentBundles.add(dependantBundle);
            }
        }
        if (this.outgoingDependencyDegree > degree) {
            return dependentBundles;
        }
        return Collections.emptySet();
    }

    private Set<IBundle> addOutgoingServiceDependencies(Set<BundleDependency> dependencies, IBundle bundle, int degree, Set<IBundle> processedBundles) {
        if (processedBundles.contains(bundle)) {
            return Collections.emptySet();
        }
        processedBundles.add(bundle);
        HashSet<IBundle> dependentBundles = new HashSet<IBundle>();
        if (this.outgoingDependencyDegree >= degree) {
            for (IServiceReference pe : bundle.getServicesInUse()) {
                IBundle dependantBundle = this.bundles.get(pe.getBundleId());
                Set<Object> bundleDependencies = null;
                if (this.dependenciesByBundle.containsKey(bundle)) {
                    bundleDependencies = this.dependenciesByBundle.get(bundle);
                } else {
                    bundleDependencies = new HashSet();
                    this.dependenciesByBundle.put(bundle, bundleDependencies);
                }
                ServiceReferenceBundleDependency bundleDependency = null;
                for (BundleDependency bundleDependency2 : bundleDependencies) {
                    if (!bundleDependency2.getExportingBundle().equals(dependantBundle) || !(bundleDependency2 instanceof ServiceReferenceBundleDependency)) continue;
                    bundleDependency = (ServiceReferenceBundleDependency)bundleDependency2;
                    break;
                }
                if (bundleDependency == null) {
                    bundleDependency = new ServiceReferenceBundleDependency(dependantBundle, bundle);
                    bundleDependencies.add(bundleDependency);
                    dependencies.add(bundleDependency);
                }
                this.contentResult.addOutgoingDependency(degree, dependantBundle);
                bundleDependency.addServiceReferece(pe);
                dependentBundles.add(dependantBundle);
            }
        }
        if (this.outgoingDependencyDegree > degree) {
            return dependentBundles;
        }
        return Collections.emptySet();
    }
}

