/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.core.launching;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class LaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace((byte)3, "Launch configuration could not find runtime instance");
        }
        OSGIFrameworkInstanceBehaviorDelegate oribd = (OSGIFrameworkInstanceBehaviorDelegate)((Object)server.loadAdapter(OSGIFrameworkInstanceBehaviorDelegate.class, null));
        String mainTypeName = oribd.getFrameworkClass();
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            runner = vm.getVMRunner("run");
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        String[] envp = this.getEnvironment(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(envp);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        if ("profile".equals(mode)) {
            try {
                ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vm, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
            }
            catch (CoreException ce) {
                oribd.stopImpl();
                throw ce;
            }
        }
        oribd.setupLaunch(launch, mode, monitor);
        try {
            runner.run(runConfig, launch, monitor);
            oribd.addProcessListener(launch.getProcesses()[0]);
        }
        catch (Exception exception) {
            oribd.stopImpl();
        }
    }
}

