/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.view.pages;

import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.pages.activityEditor.WEEditorSheet;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.jwt.we.misc.wizards.view.ViewConfWizard;
import org.eclipse.jwt.we.parts.JWTEditPartFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class PreviewViewConfWizardPage
extends WizardPage {
    static final Logger logger = Logger.getLogger(PreviewViewConfWizardPage.class);
    private Combo activityCombo;
    private Canvas previewCanvas;
    private Thumbnail thumbnail;
    private GraphicalViewerImpl gv;

    public PreviewViewConfWizardPage(String pageId, IWorkbench workbench) {
        super(pageId);
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)GeneralHelper.getActiveInstance().getAdapter(AdapterFactory.class);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)WizardHelper.createData(4, 4, true, false, -1, -1));
        Label activityLabel = new Label(composite, 16384);
        activityLabel.setText(PluginProperties.wizards_ViewConfPreviewSelect_label);
        activityLabel.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, 1, 1));
        this.activityCombo = new Combo(composite, 12);
        activityLabel.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, 1, 1));
        Set availableElements = EMFHelper.collectRelevantElements((EObject)((EObject)GeneralHelper.getActiveInstance().getModel()));
        for (Object object : availableElements) {
            if (!((EObject)object instanceof Activity)) continue;
            String activityName = "";
            if (((Activity)object).getName() != null) {
                activityName = ((Activity)object).getName();
            }
            this.activityCombo.add(activityName);
            this.activityCombo.setData(activityName, object);
        }
        this.previewCanvas = new Canvas(composite, 0);
        this.previewCanvas.setBackground(PreferenceReader.appearanceEditorColor.get());
        this.previewCanvas.setLayoutData((Object)WizardHelper.createData(4, 4, true, true, 1, 2));
        this.activityCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreviewViewConfWizardPage.this.loadPreview();
            }
        });
        if (this.activityCombo.getItemCount() > 0) {
            this.activityCombo.select(0);
            this.loadPreview();
        }
        this.setMessage(null);
        this.setControl((Control)composite);
        this.getShell().pack();
        WizardHelper.resizeDialog(this.getShell());
    }

    private void loadPreview() {
        if (this.activityCombo.getItemCount() > 0 && this.activityCombo.getSelectionIndex() > -1) {
            Activity selectedActivity = (Activity)this.activityCombo.getData(this.activityCombo.getText());
            ScalableFreeformRootEditPart rootEditPart = null;
            if (GeneralHelper.getActiveInstance().getOpenActivities().contains(selectedActivity)) {
                IActivityEditor activityEditor = GeneralHelper.getActiveInstance().getPageForActivity(selectedActivity);
                if (activityEditor instanceof WEEditorSheet) {
                    rootEditPart = ((WEEditorSheet)activityEditor).getRootEditPart();
                }
            } else {
                if (this.gv != null) {
                    this.gv.setEditDomain(null);
                    this.gv.setEditPartFactory(null);
                    this.gv.getControl().dispose();
                }
                this.gv = new GraphicalViewerImpl();
                this.gv.createControl((Composite)this.previewCanvas);
                this.gv.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
                this.gv.setEditPartFactory((EditPartFactory)new JWTEditPartFactory());
                this.gv.setEditDomain((EditDomain)GeneralHelper.getActiveInstance().getEditDomain());
                this.gv.setContents(this.activityCombo.getData(this.activityCombo.getText()));
                rootEditPart = (ScalableFreeformRootEditPart)this.gv.getRootEditPart();
                rootEditPart.getFigure().setBackgroundColor(PreferenceReader.appearanceEditorColor.get());
            }
            if (rootEditPart != null) {
                if (this.thumbnail != null) {
                    this.thumbnail.deactivate();
                    this.previewCanvas.redraw();
                }
                this.thumbnail = new Thumbnail((IFigure)((Viewport)rootEditPart.getFigure()));
                this.thumbnail.setSource(rootEditPart.getLayer((Object)"Printable Layers"));
                LightweightSystem lws = new LightweightSystem(this.previewCanvas);
                lws.setContents((IFigure)this.thumbnail);
            }
        }
    }

    public IWizardPage getNextPage() {
        ((ViewConfWizard)this.getWizard()).updatePreview();
        return null;
    }

    public void dispose() {
        if (this.gv != null) {
            this.gv.setEditDomain(null);
            this.gv.setEditPartFactory(null);
            this.gv.getControl().dispose();
        }
        if (this.activityCombo != null && !this.activityCombo.isDisposed()) {
            this.activityCombo.dispose();
            this.activityCombo = null;
        }
        if (this.previewCanvas != null && !this.previewCanvas.isDisposed()) {
            this.previewCanvas.dispose();
            this.previewCanvas = null;
        }
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
        super.dispose();
    }
}

