/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewuml;

import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jwt.we.IFactoryRegistry;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.palette.IPaletteFactory;
import org.eclipse.jwt.we.figures.IFigureFactory;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.StandardFigureFactory;
import org.eclipse.jwt.we.figures.internal.CompositeFigureFactory;
import org.eclipse.jwt.we.figures.internal.ImageFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.parts.JWTEditPartFactory;
import org.eclipse.jwt.we.plugins.viewuml.figures.UmlFigureFactory;
import org.eclipse.jwt.we.plugins.viewuml.palette.UMLPaletteFactory;

public class UmlFactoryRegistry
implements IFactoryRegistry {
    private static final Logger logger = Logger.getLogger(UmlFactoryRegistry.class);
    private static final String ICONS_BASE_PATH = "icons/";
    protected IImageFactory imageFactory;
    protected IFigureFactory figureFactory;
    protected EditPartFactory editPartFactory;
    protected IPaletteFactory paletteFactory;

    public IImageFactory getImageFactory(Object ... objects) {
        if (this.imageFactory == null) {
            ImageRegistry imageRegistry = Plugin.getInstance().getImageRegistry();
            this.imageFactory = new ImageFactory(imageRegistry, (EclipseUIPlugin)Plugin.getDefault(), ICONS_BASE_PATH);
        }
        return this.imageFactory;
    }

    public IPaletteFactory getPaletteFactory() {
        if (this.paletteFactory == null) {
            this.paletteFactory = new UMLPaletteFactory();
        }
        return this.paletteFactory;
    }

    public IFigureFactory getFigureFactory() {
        if (this.figureFactory == null) {
            logger.info("**** getFigureFactory in UML called !!!!!!");
            CompositeFigureFactory compositeFigureFactory = new CompositeFigureFactory();
            UmlFigureFactory figureFactory = new UmlFigureFactory();
            compositeFigureFactory.addFigureFactory((IFigureFactory)figureFactory);
            figureFactory = new StandardFigureFactory();
            compositeFigureFactory.addFigureFactory((IFigureFactory)figureFactory);
            this.figureFactory = compositeFigureFactory;
        }
        return this.figureFactory;
    }

    public EditPartFactory getEditPartFactory() {
        if (this.editPartFactory == null) {
            this.editPartFactory = new JWTEditPartFactory();
        }
        return this.editPartFactory;
    }
}

