/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.properties;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.core.PackageableElement;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.data.DataMapping;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.jwt.transformations.api.TransformationService;
import org.eclipse.jwt.transformations.properties.ChainedPropertyProcessor;
import org.eclipse.jwt.transformations.properties.PropertyProcessor;
import org.eclipse.jwt.transformations.properties.PropertyProcessorsExtensionPoint;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.aspects.AspectManager;
import org.eclipse.jwt.we.conf.property.model.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractPropertiesService
extends TransformationService {
    private Map<String, String> resources;

    public void transform(String inFilePath, String propertiesFile) throws IOException, TransformationException {
        Model jwtModel = this.getJWTModel(inFilePath);
        try {
            this.resources = this.processProperties(jwtModel, propertiesFile);
        }
        catch (IOException iOException) {
            throw new TransformationException("Cannot write properties file aside of XPDL file");
        }
    }

    public Map<String, String> getAttachedResources() {
        return this.resources;
    }

    private Model getJWTModel(String inFilePath) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File(inFilePath).getAbsolutePath());
        Resource resource = resourceSet.getResource(fileURI, true);
        Model jwtModel = (Model)resource.getContents().get(0);
        return jwtModel;
    }

    public Map<String, String> processProperties(Model jwtModel, String outFileName) throws IOException {
        PrintStream out = new PrintStream(outFileName);
        this.resources = new HashMap<String, String>();
        this.processProperties((Package)jwtModel, out);
        return this.resources;
    }

    private void processProperties(Package jwtPackage, PrintStream out) {
        out.println("## Begin package " + jwtPackage.getName());
        for (Object subpackage : jwtPackage.getSubpackages()) {
            this.processProperties((Package)subpackage, out);
        }
        for (Object element : jwtPackage.getElements()) {
            if (element instanceof Activity) {
                Activity activity = (Activity)element;
                this.processActivity(activity, out);
                continue;
            }
            this.processProperties((PackageableElement)element, out);
        }
        out.println("## End package " + jwtPackage.getName());
    }

    private void processActivity(Activity activity, PrintStream out) {
        out.println("## Begin activity " + activity.getName());
        for (Object node : activity.getNodes()) {
            if (!(node instanceof Action)) continue;
            Action action = (Action)node;
            this.processActionIO(action, activity, out);
            Application app = action.getExecutedBy();
            this.processApplication(app, action, activity, out);
        }
        out.println("## End activity " + activity.getName());
    }

    private void processApplication(Application app, Action action, Activity activity, PrintStream out) {
        if (app == null) {
            return;
        }
        out.println("# Data mapping of action " + action.getName() + ":");
        int i = 0;
        for (Object inObj : app.getInput()) {
            for (Object mapObj : action.getMappings()) {
                Iterator mapping = (DataMapping)mapObj;
                if (!inObj.equals(mapping.getBoundParameter())) continue;
                out.println(this.buildPropertySetterString(activity, action, "argVariable" + i, mapping.getParameter().getName()));
                ++i;
            }
        }
        int j = 0;
        for (Object outObj : app.getOutput()) {
            for (Object mapObj : action.getMappings()) {
                DataMapping mapping = (DataMapping)mapObj;
                if (!outObj.equals(mapping.getBoundParameter())) continue;
                out.println(this.buildPropertySetterString(activity, action, "resVariable" + (j != 0 ? Integer.valueOf(j) : ""), mapping.getParameter().getName()));
                ++j;
            }
        }
        out.println("# Other properties of application of action " + action.getName() + ":");
        for (EObject objFeature : app.eClass().getEAllAttributes()) {
            if (!(objFeature instanceof EStructuralFeature)) continue;
            EStructuralFeature feature = (EStructuralFeature)objFeature;
            PropertyProcessor propProcessor = this.getPropertyProcessor((EObject)app, feature);
            for (Map.Entry<String, Object> propEntry : propProcessor.getEntries().entrySet()) {
                out.println(this.buildPropertySetterString(activity, action, propEntry.getKey(), propEntry.getValue()));
            }
            Map<String, String> propResources = propProcessor.getResources();
            if (propResources == null) continue;
            this.resources.putAll(propResources);
        }
        out.println("# Aspect properties of application of action " + action.getName() + ":");
        for (AspectInstance aspect : AspectManager.INSTANCE.getAspectInstances((EObject)app)) {
            if (aspect instanceof Property) {
                Property property = (Property)aspect;
                out.println(this.buildPropertySetterString(activity, action, property.getId(), property.getValue()));
                continue;
            }
            for (EObject objFeature : aspect.eClass().getEAllAttributes()) {
                if (!(objFeature instanceof EStructuralFeature)) continue;
                EStructuralFeature feature = (EStructuralFeature)objFeature;
                PropertyProcessor propProcessor = this.getPropertyProcessor((EObject)aspect, feature);
                for (Map.Entry<String, Object> propEntry : propProcessor.getEntries().entrySet()) {
                    out.println(this.buildPropertySetterString(activity, action, propEntry.getKey(), propEntry.getValue()));
                }
                Map<String, String> propResources = propProcessor.getResources();
                if (propResources == null) continue;
                this.resources.putAll(propResources);
            }
        }
    }

    private void processActionIO(Action action, Activity activity, PrintStream out) {
        out.println("# IO Properties of action " + action.getName() + ":");
        int i = 0;
        for (Object inObj : action.getInputs()) {
            Data data = (Data)inObj;
            out.println(this.buildPropertySetterString(activity, action, "input" + i, data.getName()));
            ++i;
        }
        int j = 0;
        for (Object outObj : action.getOutputs()) {
            Data data = (Data)outObj;
            out.println(this.buildPropertySetterString(activity, action, "output" + j, data.getName()));
            ++j;
        }
        out.println("# Other properties of action " + action.getName() + ":");
        for (EObject objFeature : action.eClass().getEAllAttributes()) {
            if (!(objFeature instanceof EStructuralFeature)) continue;
            EStructuralFeature feature = (EStructuralFeature)objFeature;
            PropertyProcessor propProcessor = this.getPropertyProcessor((EObject)action, feature);
            for (Map.Entry<String, Object> propEntry : propProcessor.getEntries().entrySet()) {
                out.println(this.buildPropertySetterString(activity, action, propEntry.getKey(), propEntry.getValue()));
            }
            Map<String, String> propResources = propProcessor.getResources();
            if (propResources == null) continue;
            this.resources.putAll(propResources);
        }
        out.println("# Aspect properties of action " + action.getName() + ":");
        for (AspectInstance aspect : AspectManager.INSTANCE.getAspectInstances((EObject)action)) {
            if (aspect instanceof Property) {
                Property property = (Property)aspect;
                out.println(this.buildPropertySetterString(activity, action, property.getId(), property.getValue()));
                continue;
            }
            for (EObject objFeature : aspect.eClass().getEAllAttributes()) {
                if (!(objFeature instanceof EStructuralFeature)) continue;
                EStructuralFeature feature = (EStructuralFeature)objFeature;
                PropertyProcessor propProcessor = this.getPropertyProcessor((EObject)aspect, feature);
                for (Map.Entry<String, Object> propEntry : propProcessor.getEntries().entrySet()) {
                    out.println(this.buildPropertySetterString(activity, action, propEntry.getKey(), propEntry.getValue()));
                }
                Map<String, String> propResources = propProcessor.getResources();
                if (propResources == null) continue;
                this.resources.putAll(propResources);
            }
        }
    }

    private void processProperties(PackageableElement element, PrintStream out) {
        out.println("# Properties of package element " + element.getName() + ":");
        for (EObject objFeature : element.eClass().getEAllAttributes()) {
            if (!(objFeature instanceof EStructuralFeature)) continue;
            EStructuralFeature feature = (EStructuralFeature)objFeature;
            PropertyProcessor propProcessor = this.getPropertyProcessor((EObject)element, feature);
            for (Map.Entry<String, Object> propEntry : propProcessor.getEntries().entrySet()) {
                out.println(this.buildPropertySetterString(element, propEntry.getKey(), propEntry.getValue()));
            }
            Map<String, String> propResources = propProcessor.getResources();
            if (propResources == null) continue;
            this.resources.putAll(propResources);
        }
        for (AspectInstance aspect : AspectManager.INSTANCE.getAspectInstances((EObject)element)) {
            if (aspect instanceof Property) {
                Property property = (Property)aspect;
                out.println(this.buildPropertySetterString(element, property.getId(), property.getValue()));
                continue;
            }
            for (EObject objFeature : aspect.eClass().getEAllAttributes()) {
                if (!(objFeature instanceof EStructuralFeature)) continue;
                EStructuralFeature feature = (EStructuralFeature)objFeature;
                PropertyProcessor propProcessor = this.getPropertyProcessor((EObject)aspect, feature);
                for (Map.Entry<String, Object> propEntry : propProcessor.getEntries().entrySet()) {
                    out.println(this.buildPropertySetterString(element, propEntry.getKey(), propEntry.getValue()));
                }
                Map<String, String> propResources = propProcessor.getResources();
                if (propResources == null) continue;
                this.resources.putAll(propResources);
            }
        }
    }

    private PropertyProcessor getPropertyProcessor(EObject app, EStructuralFeature feature) {
        return new ChainedPropertyProcessor(app, feature, PropertyProcessorsExtensionPoint.getPropertyProcessors(app, feature));
    }

    private String buildPropertySetterString(Activity activity, Action action, String propertyName, Object value) {
        if (value == null || value.toString().length() == 0) {
            return "";
        }
        String stringValue = value.toString().replace("\n", "\\n\\\n");
        return String.valueOf(activity.getName()) + "/" + action.getName() + "/" + propertyName + "=" + stringValue;
    }

    private String buildPropertySetterString(PackageableElement element, String propertyName, Object value) {
        if (value == null || value.toString().length() == 0) {
            return "";
        }
        return String.valueOf(element.getName()) + "/" + propertyName + "=" + value;
    }
}

