/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.internal.message;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class MessageHeader {
    public static final int HEADER_START = 35;
    public static final int MESSAGE = 2;
    public static final int REQUEST = 3;
    public static final int RESPONSE = 4;
    private static final int HEADER_VERSION = 1;
    private int m_version;
    private int m_messageType;
    private String m_messageClassName;
    private int m_messageLength = -1;

    public MessageHeader() {
    }

    public MessageHeader(int messageType, Message message) throws IllegalArgumentException {
        if (messageType < 2 || messageType > 4) {
            throw new IllegalArgumentException("invalid message type: " + messageType);
        }
        Validate.notNull((Object)message);
        this.m_version = 1;
        this.m_messageType = messageType;
        this.m_messageClassName = message.getClass().getName();
    }

    public int getMessageType() {
        return this.m_messageType;
    }

    public void setMessageType(int messageType) {
        this.m_messageType = messageType;
    }

    public int getMessageLength() {
        return this.m_messageLength;
    }

    public void setMessageLength(int messageLength) {
        this.m_messageLength = messageLength;
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public void validateVersion() throws InvalidHeaderVersionException {
        if (this.m_version != 1) {
            throw new InvalidHeaderVersionException("Invalid version " + this.m_version + ". Valid is: " + 1, MessageIDs.E_INVALID_HEADER);
        }
    }

    public String getMessageClassName() {
        return this.m_messageClassName;
    }

    public void setMessageClassName(String messageClass) {
        this.m_messageClassName = messageClass;
    }

    public boolean equals(Object object) {
        if (object instanceof MessageHeader) {
            MessageHeader theOther = (MessageHeader)object;
            return new EqualsBuilder().append(this.m_version, theOther.m_version).append(this.m_messageType, theOther.m_messageType).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.m_version).append(this.m_messageType).toHashCode();
    }

    public static class InvalidHeaderVersionException
    extends CommunicationException {
        public InvalidHeaderVersionException(String message, Integer id) {
            super(message, id);
        }
    }
}

