/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMRefreshFailedException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;

public class TransactionSupport {
    private TransactionSupport() {
    }

    public static void transact(ITransaction op) throws Exception {
        EntityManager sess = null;
        Persistor per = Persistor.instance();
        try {
            sess = per.openSession();
            EntityTransaction tx = per.getTransaction(sess);
            LockManager.instance().lockPOs(sess, op.getToLock(), true);
            op.run(sess);
            per.commitTransaction(sess, tx);
        }
        finally {
            per.dropSession(sess);
        }
        TransactionSupport.mergeMasterSession(op);
        TransactionSupport.refreshMasterSession(op);
    }

    private static void refreshMasterSession(ITransaction op) throws PMRefreshFailedException {
        Collection<? extends IPersistentObject> toRefresh = op.getToRefresh();
        if (toRefresh == null || toRefresh.isEmpty()) {
            return;
        }
        try {
            EntityManager master = GeneralStorage.getInstance().getMasterSession();
            for (IPersistentObject iPersistentObject : toRefresh) {
                IPersistentObject iPersistentObject2 = (IPersistentObject)master.find(iPersistentObject.getClass(), (Object)iPersistentObject.getId());
                if (iPersistentObject2 != null) {
                    master.refresh((Object)iPersistentObject2);
                }
                if (!(iPersistentObject2 instanceof INodePO)) continue;
                ((INodePO)iPersistentObject2).getUnmodifiableNodeList();
            }
        }
        catch (Exception e) {
            throw new PMRefreshFailedException(e);
        }
    }

    private static void mergeMasterSession(ITransaction op) throws PMRefreshFailedException {
        Collection<? extends IPersistentObject> toMerge = op.getToMerge();
        if (toMerge == null || toMerge.isEmpty()) {
            return;
        }
        try {
            EntityManager master = GeneralStorage.getInstance().getMasterSession();
            for (IPersistentObject iPersistentObject : toMerge) {
                master.merge((Object)iPersistentObject);
            }
        }
        catch (Exception e) {
            throw new PMRefreshFailedException(e);
        }
    }

    public static interface ITransaction {
        public Collection<? extends IPersistentObject> getToLock();

        public Collection<? extends IPersistentObject> getToRefresh();

        public Collection<? extends IPersistentObject> getToMerge();

        public void run(EntityManager var1) throws Exception;
    }
}

