/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jpt.common.ui.internal.jface.AbstractItemStructuredStateProviderManager;
import org.eclipse.jpt.common.ui.internal.jface.NullItemExtendedLabelProviderFactory;
import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.TreeStateProvider;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class ItemTreeStateProviderManager
extends AbstractItemStructuredStateProviderManager<TreeViewer, ItemTreeContentProvider, ItemTreeContentProvider.Factory>
implements TreeStateProvider,
ItemTreeContentProvider.Manager {
    private final HashMap<Object, ItemTreeContentProvider> itemContentProviders = new HashMap();

    public ItemTreeStateProviderManager(ItemTreeContentProvider.Factory itemContentProviderFactory, ResourceManager resourceManager) {
        this(itemContentProviderFactory, NullItemExtendedLabelProviderFactory.instance(), resourceManager);
    }

    public ItemTreeStateProviderManager(ItemTreeContentProvider.Factory itemContentProviderFactory, ItemExtendedLabelProvider.Factory itemLabelProviderFactory, ResourceManager resourceManager) {
        this(itemContentProviderFactory, itemLabelProviderFactory, resourceManager, JptCommonUiPlugin.exceptionHandler());
    }

    public ItemTreeStateProviderManager(ItemTreeContentProvider.Factory itemContentProviderFactory, ItemExtendedLabelProvider.Factory itemLabelProviderFactory, ResourceManager resourceManager, ExceptionHandler exceptionHandler) {
        super(itemContentProviderFactory, itemLabelProviderFactory, resourceManager, exceptionHandler);
    }

    public boolean hasChildren(Object element) {
        ItemTreeContentProvider provider = this.getItemContentProvider(element);
        return provider != null && provider.hasChildren();
    }

    public Object[] getChildren(Object parentElement) {
        ItemTreeContentProvider provider = this.getItemContentProvider(parentElement);
        if (provider == null) {
            if (PLUG_IN != null) {
                String msg = MessageFormat.format((String)"Unexpected parent: {0}", (Object[])new Object[]{parentElement});
                IllegalArgumentException ex = new IllegalArgumentException(msg);
                PLUG_IN.logError(ex);
            }
            return ObjectTools.EMPTY_OBJECT_ARRAY;
        }
        return provider.getChildren();
    }

    public Object getParent(Object element) {
        ItemTreeContentProvider provider = this.getItemContentProvider(element);
        return provider == null ? null : provider.getParent();
    }

    private ItemTreeContentProvider getItemContentProvider(Object item) {
        return this.itemContentProviders.get(item);
    }

    @Override
    public void childrenChanged(Object item, Iterable<?> addedChildren, Iterable<?> removedChildren) {
        this.checkUIThread();
        if (this.getItemContentProvider(item) != null) {
            this.childrenChanged_(item, addedChildren, removedChildren);
        }
    }

    private void childrenChanged_(Object item, Iterable<?> addedChildren, Iterable<?> removedChildren) {
        this.addAll(item, addedChildren);
        this.removeAll(removedChildren);
        ((TreeViewer)this.viewer).add(item, ArrayTools.array(addedChildren));
        ((TreeViewer)this.viewer).remove(item, ArrayTools.array(removedChildren));
    }

    @Override
    void add(Object parent, Object item) {
        super.add(parent, item);
        ItemTreeContentProvider provider = ((ItemTreeContentProvider.Factory)this.itemContentProviderFactory).buildProvider(item, parent, this);
        this.itemContentProviders.put(item, provider);
        this.addAll(item, provider.getChildren());
    }

    @Override
    void remove(Object item) {
        ItemTreeContentProvider provider = this.itemContentProviders.get(item);
        this.removeAll(provider.getChildren());
        provider.dispose();
        this.itemContentProviders.remove(item);
        super.remove(item);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.itemContentProviders.isEmpty()) {
            String msg = MessageFormat.format((String)"Not all item content providers were disposed: {0}", (Object[])new Object[]{this.itemContentProviders});
            IllegalStateException ex = new IllegalStateException(msg);
            if (PLUG_IN != null) {
                PLUG_IN.logError(ex);
            } else {
                ex.printStackTrace();
            }
        }
    }
}

