/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.dsl.model.EmfFeatureAccess;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.ProviderBinding;
import org.eclipse.emf.parsley.dsl.model.TypeBinding;
import org.eclipse.emf.parsley.dsl.model.ValueBinding;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.typing.EmfParsleyDslTypeSystem;
import org.eclipse.emf.parsley.dsl.util.EmfParsleyDslGuiceModuleHelper;
import org.eclipse.emf.parsley.dsl.validation.AbstractEmfParsleyDslValidator;
import org.eclipse.emf.parsley.dsl.validation.EmfParsleyDslExpectedSuperTypes;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.util.Multimaps2;

public class EmfParsleyDslValidator
extends AbstractEmfParsleyDslValidator {
    public static final String TYPE_MISMATCH = "org.eclipse.emf.parsley.dsl.TypeMismatch";
    public static final String CYCLIC_INHERITANCE = "org.eclipse.emf.parsley.dsl.CyclicInheritance";
    public static final String FINAL_FIELD_NOT_INITIALIZED = "org.eclipse.emf.parsley.dsl.FinalFieldNotInitialized";
    public static final String TOO_LITTLE_TYPE_INFORMATION = "org.eclipse.emf.parsley.dsl.TooLittleTypeInformation";
    public static final String DUPLICATE_BINDING = "org.eclipse.emf.parsley.dsl.DuplicateBinding";
    public static final String DUPLICATE_ELEMENT = "org.eclipse.emf.parsley.dsl.DuplicateElement";
    public static final String NON_COMPLIANT_BINDING = "org.eclipse.emf.parsley.dsl.NonCompliantBinding";
    @Inject
    private EmfParsleyDslTypeSystem typeSystem;
    @Inject
    @Extension
    private EmfParsleyDslExpectedSuperTypes _emfParsleyDslExpectedSuperTypes;
    @Inject
    @Extension
    private EmfParsleyDslGuiceModuleHelper _emfParsleyDslGuiceModuleHelper;
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;
    @Inject
    private ResourceDescriptionsProvider rdp;
    @Inject
    private IContainer.Manager cm;
    private final ModelPackage modelPackage = ModelPackage.eINSTANCE;

    @Check(value=CheckType.NORMAL)
    public void checkDuplicateViewSpecificationAcrossFiles(ViewSpecification viewSpecification) {
        Iterable<IEObjectDescription> descriptions = this.getVisibleEObjectDescriptions(viewSpecification, ModelPackage.Literals.VIEW_SPECIFICATION);
        for (IEObjectDescription desc : descriptions) {
            if (!Objects.equal((Object)desc.getQualifiedName().toString(), (Object)viewSpecification.getId()) || Objects.equal((Object)desc.getEObjectOrProxy(), (Object)viewSpecification) || Objects.equal((Object)desc.getEObjectURI().trimFragment(), (Object)viewSpecification.eResource().getURI())) continue;
            String _id = viewSpecification.getId();
            String _plus = "The part id " + _id;
            String _plus_1 = String.valueOf(_plus) + " is already defined";
            this.error(_plus_1, (EStructuralFeature)this.modelPackage.getViewSpecification_Id(), DUPLICATE_ELEMENT, new String[0]);
            return;
        }
    }

    private Iterable<IEObjectDescription> getVisibleEObjectDescriptions(EObject o, final EClass type) {
        Functions.Function1<IContainer, Iterable<IEObjectDescription>> _function = new Functions.Function1<IContainer, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IContainer container) {
                return container.getExportedObjectsByType(type);
            }
        };
        return Iterables.concat((Iterable)ListExtensions.map(this.getVisibleContainers(o), (Functions.Function1)_function));
    }

    private List<IContainer> getVisibleContainers(EObject o) {
        List _xblockexpression = null;
        IResourceDescriptions index = this.rdp.getResourceDescriptions(o.eResource());
        IResourceDescription rd = index.getResourceDescription(o.eResource().getURI());
        _xblockexpression = this.cm.getVisibleContainers(rd, index);
        return _xblockexpression;
    }

    @Check
    public void checkViewSpecification(ViewSpecification viewSpecification) {
        this.checkType(viewSpecification, viewSpecification.getType(), this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(viewSpecification), (EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__TYPE);
    }

    @Check
    public void checkEmfFeatureAccess(EmfFeatureAccess emfFeatureAccess) {
        this.checkType(emfFeatureAccess, emfFeatureAccess.getParameterType(), this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(emfFeatureAccess), (EStructuralFeature)ModelPackage.Literals.EMF_FEATURE_ACCESS__PARAMETER_TYPE);
    }

    @Check
    public void checkExtendsClause(WithExtendsClause withExtendsClause) {
        if (withExtendsClause.getExtendsClause() != null && !this.hasCycleInHierarchy(withExtendsClause)) {
            this.checkType(withExtendsClause.getExtendsClause(), withExtendsClause.getExtendsClause().getSuperType(), this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(withExtendsClause), (EStructuralFeature)ModelPackage.Literals.EXTENDS_CLAUSE__SUPER_TYPE);
        }
    }

    @Check
    public void checkFieldInitialization(FieldSpecification f) {
        if (!f.isWriteable() && f.getRight() == null) {
            String _name = f.getName();
            String _plus = "The blank final field " + _name;
            String _plus_1 = String.valueOf(_plus) + " may not have been initialized";
            this.error(_plus_1, (EStructuralFeature)ModelPackage.Literals.FIELD_SPECIFICATION__NAME, FINAL_FIELD_NOT_INITIALIZED, new String[0]);
        }
        if (f.getType() == null && f.getRight() == null) {
            String _name_1 = f.getName();
            String _plus_2 = "The field " + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " needs an explicit type since there is no initialization expression to infer the type from.";
            this.error(_plus_3, f, (EStructuralFeature)ModelPackage.Literals.FIELD_SPECIFICATION__NAME, TOO_LITTLE_TYPE_INFORMATION, new String[0]);
        }
    }

    @Check
    public void checkModule(Module module) {
        Iterable methods;
        boolean _isEmpty;
        JvmGenericType guiceModuleClass = this._emfParsleyDslGuiceModuleHelper.getModuleInferredType(module);
        if (guiceModuleClass == null) {
            return;
        }
        PartsSpecifications partsSpecifications = module.getPartsSpecifications();
        if (partsSpecifications != null) {
            this.checkDuplicateViewSpecifications((List<PartSpecification>)partsSpecifications.getParts());
        }
        if (_isEmpty = IterableExtensions.isEmpty((Iterable)(methods = guiceModuleClass.getDeclaredOperations()))) {
            return;
        }
        this.checkDuplicateBindings(methods);
        this.checkCorrectValueBindings(guiceModuleClass, methods, module);
        Iterable<JvmGenericType> _allWithExtendsClauseInferredJavaTypes = this._emfParsleyDslGuiceModuleHelper.getAllWithExtendsClauseInferredJavaTypes(module);
        for (JvmGenericType t : _allWithExtendsClauseInferredJavaTypes) {
            this.checkDuplicateSpecifications(t);
        }
    }

    private void checkDuplicateBindings(Iterable<JvmOperation> methods) {
        ListMultimap map = this.duplicatesMultimap();
        for (JvmOperation m : methods) {
            map.put((Object)m.getSimpleName(), (Object)m);
        }
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation d) {
                EObject source = (EObject)IterableExtensions.head((Iterable)EmfParsleyDslValidator.this._iJvmModelAssociations.getSourceElements((EObject)d));
                EmfParsleyDslValidator.this.error(EmfParsleyDslValidator.this.duplicateBindingMessage(source, d), source, EmfParsleyDslValidator.this.duplicateBindingFeature(source), EmfParsleyDslValidator.DUPLICATE_BINDING, new String[0]);
            }
        };
        this.checkDuplicates(map, _function);
    }

    private void checkDuplicateSpecifications(JvmGenericType inferredType) {
        ResolvedFeatures inferredFeatures = this._emfParsleyDslGuiceModuleHelper.getJavaResolvedFeatures(inferredType);
        List methods = inferredFeatures.getDeclaredOperations();
        ListMultimap map = this.duplicatesMultimap();
        final HashSet errorSourceSeen = CollectionLiterals.newHashSet((Object[])new EObject[0]);
        for (IResolvedOperation m : methods) {
            map.put((Object)this._emfParsleyDslGuiceModuleHelper.getJavaMethodResolvedErasedSignature(m), (Object)m.getDeclaration());
        }
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation d) {
                EObject source = (EObject)IterableExtensions.head((Iterable)EmfParsleyDslValidator.this._iJvmModelAssociations.getSourceElements((EObject)d));
                boolean _add = errorSourceSeen.add(source);
                if (_add) {
                    EmfParsleyDslValidator.this.error("Duplicate element", source, null, EmfParsleyDslValidator.DUPLICATE_ELEMENT, new String[0]);
                }
            }
        };
        this.checkDuplicates(map, _function);
    }

    private void checkDuplicateViewSpecifications(List<PartSpecification> parts) {
        ListMultimap map = this.duplicatesMultimap();
        Iterable _filter = Iterables.filter(parts, ViewSpecification.class);
        for (ViewSpecification p : _filter) {
            map.put((Object)p.getId(), (Object)p);
        }
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject d) {
                EmfParsleyDslValidator.this.error("Duplicate element", d, (EStructuralFeature)EmfParsleyDslValidator.this.modelPackage.getViewSpecification_Id(), EmfParsleyDslValidator.DUPLICATE_ELEMENT, new String[0]);
            }
        };
        this.checkDuplicates(map, _function);
    }

    private <T> void checkDuplicates(ListMultimap<String, T> map, Procedures.Procedure1<? super T> errorReporter) {
        Set _entrySet = map.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (Object d : duplicates) {
                errorReporter.apply(d);
            }
        }
    }

    public void checkCorrectValueBindings(JvmGenericType guiceModuleClass, Iterable<JvmOperation> methods, Module module) {
        Iterable<JvmOperation> superClassValueBindings = this._emfParsleyDslGuiceModuleHelper.getAllGuiceValueBindingsMethodsInSuperclass(guiceModuleClass);
        for (final JvmOperation superBinding : superClassValueBindings) {
            Functions.Function1<JvmOperation, Boolean> _function = new Functions.Function1<JvmOperation, Boolean>(){

                public Boolean apply(JvmOperation it) {
                    String _simpleName = it.getSimpleName();
                    String _simpleName_1 = superBinding.getSimpleName();
                    return Objects.equal((Object)_simpleName, (Object)_simpleName_1);
                }
            };
            JvmOperation matching = (JvmOperation)IterableExtensions.findFirst(methods, (Functions.Function1)_function);
            if (matching == null || this.typeSystem.isConformant((EObject)module, superBinding.getReturnType(), matching.getReturnType())) continue;
            String _simpleName = matching.getReturnType().getSimpleName();
            String _plus = "Incorrect value binding: " + _simpleName;
            String _plus_1 = String.valueOf(_plus) + " is not compliant with inherited binding's type ";
            String _simpleName_1 = superBinding.getReturnType().getSimpleName();
            String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
            this.error(_plus_2, (EObject)IterableExtensions.head((Iterable)this._iJvmModelAssociations.getSourceElements((EObject)matching)), (EStructuralFeature)this.modelPackage.getValueBinding_TypeDecl(), NON_COMPLIANT_BINDING, new String[0]);
        }
    }

    protected void checkType(EObject context, JvmTypeReference actualType, Class<?> expectedType, EStructuralFeature feature) {
        if (actualType != null) {
            boolean _not;
            boolean _isConformant = this.typeSystem.isConformant(context, expectedType, actualType);
            boolean bl = _not = !_isConformant;
            if (_not) {
                String _simpleName = actualType.getSimpleName();
                String _plus = "Type mismatch: cannot convert from " + _simpleName;
                String _plus_1 = String.valueOf(_plus) + " to ";
                String _simpleName_1 = expectedType.getSimpleName();
                String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
                this.error(_plus_2, context, feature, TYPE_MISMATCH, new String[0]);
            }
        }
    }

    protected boolean hasCycleInHierarchy(WithExtendsClause withExtendsClause) {
        boolean _hasCycleInHierarchy;
        JvmType superType;
        JvmTypeReference _superType = withExtendsClause.getExtendsClause().getSuperType();
        JvmType _type = null;
        if (_superType != null) {
            _type = _superType.getType();
        }
        if ((superType = _type) instanceof JvmGenericType && (_hasCycleInHierarchy = this.hasCycleInHierarchy((JvmGenericType)superType, CollectionLiterals.newHashSet((Object[])new JvmGenericType[0])))) {
            String _simpleName = ((JvmGenericType)superType).getSimpleName();
            String _plus = "The inheritance hierarchy of " + _simpleName;
            String _plus_1 = String.valueOf(_plus) + " contains cycles";
            this.error(_plus_1, withExtendsClause.getExtendsClause(), (EStructuralFeature)ModelPackage.Literals.EXTENDS_CLAUSE__SUPER_TYPE, CYCLIC_INHERITANCE, new String[0]);
            return true;
        }
        return false;
    }

    protected boolean hasCycleInHierarchy(JvmGenericType type, Set<JvmGenericType> processedSuperTypes) {
        boolean _contains = processedSuperTypes.contains(type);
        if (_contains) {
            return true;
        }
        processedSuperTypes.add(type);
        Functions.Function1<JvmTypeReference, JvmType> _function = new Functions.Function1<JvmTypeReference, JvmType>(){

            public JvmType apply(JvmTypeReference it) {
                return it.getType();
            }
        };
        Iterable _filter = Iterables.filter((Iterable)ListExtensions.map((List)type.getSuperTypes(), (Functions.Function1)_function), JvmGenericType.class);
        for (JvmGenericType genericType : _filter) {
            boolean _hasCycleInHierarchy = this.hasCycleInHierarchy(genericType, processedSuperTypes);
            if (!_hasCycleInHierarchy) continue;
            return true;
        }
        processedSuperTypes.remove(type);
        return false;
    }

    private <K, T> ListMultimap<K, T> duplicatesMultimap() {
        return Multimaps2.newLinkedHashListMultimap();
    }

    private String duplicateBindingMessage(EObject source, JvmOperation method) {
        String _switchResult = null;
        boolean _matched = false;
        if (source instanceof TypeBinding) {
            _matched = true;
            _switchResult = method.getReturnType().getSimpleName();
        }
        if (!_matched && source instanceof ProviderBinding) {
            _matched = true;
            _switchResult = method.getReturnType().getSimpleName();
        }
        if (!_matched && source instanceof ValueBinding) {
            _matched = true;
            _switchResult = ((ValueBinding)source).getId();
        }
        if (!_matched) {
            _switchResult = method.getReturnType().getSimpleName();
        }
        return "Duplicate binding for: " + _switchResult;
    }

    private EStructuralFeature duplicateBindingFeature(EObject e) {
        EReference _switchResult = null;
        boolean _matched = false;
        if (e instanceof TypeBinding) {
            _matched = true;
            _switchResult = this.modelPackage.getTypeBinding_TypeToBind();
        }
        if (!_matched && e instanceof ProviderBinding) {
            _matched = true;
            _switchResult = this.modelPackage.getProviderBinding_Type();
        }
        if (!_matched && e instanceof ValueBinding) {
            _matched = true;
            _switchResult = this.modelPackage.getValueBinding_Id();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }
}

