/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.eclipse.emf.cdo.server.internal.mongodb.MongoDBStore;

public class Coll {
    protected MongoDBStore store;
    protected DBCollection collection;

    public Coll(MongoDBStore store, String name) {
        this.store = store;
        this.collection = store.getDB().getCollection(name);
    }

    public MongoDBStore getStore() {
        return this.store;
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    public void ensureIndex(String element, String field, boolean asc) {
        BasicDBObject index = new BasicDBObject();
        index.put(String.valueOf(element) + "." + field, (Object)(asc ? 1 : -1));
        this.collection.ensureIndex((DBObject)index);
    }

    public void ensureIndex(String element, String ... fields) {
        BasicDBObject index = new BasicDBObject();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            index.put(String.valueOf(element) + "." + field, (Object)1);
            ++n2;
        }
        this.collection.ensureIndex((DBObject)index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Query<RESULT> {
        private DBObject ref;

        public Query(DBObject ref) {
            this.ref = ref;
        }

        public DBObject getRef() {
            return this.ref;
        }

        public RESULT execute() {
            return this.execute(Coll.this.collection.find(this.ref));
        }

        public RESULT execute(DBObject keys) {
            return this.execute(Coll.this.collection.find(this.ref, keys));
        }

        protected RESULT execute(DBCursor cursor) {
            try {
                while (cursor.hasNext()) {
                    DBObject doc = cursor.next();
                    RESULT result = this.handleDoc(doc);
                    if (result == null) continue;
                    RESULT RESULT = result;
                    return RESULT;
                }
                return null;
            }
            finally {
                cursor.close();
            }
        }

        protected abstract RESULT handleDoc(DBObject var1);
    }
}

