/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.ContributionURIValidator;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionClassDialog;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MImperativeExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImperativeExpressionEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    @Inject
    IEclipseContext eclipseContext;

    @Inject
    public ImperativeExpressionEditor() {
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.obj16.class_obj");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.ImperativeExpressionEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        String contributionURI = ((MImperativeExpression)element).getContributionURI();
        if (contributionURI != null && contributionURI.trim().length() > 0) {
            int lastIndexOf = contributionURI.lastIndexOf(".");
            if (contributionURI.length() > lastIndexOf + 1) {
                return contributionURI.substring(lastIndexOf + 1);
            }
            return contributionURI;
        }
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.CoreExpressionEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = new Composite(parent, 0);
            this.composite.setLayout((Layout)new FillLayout());
            this.createForm(this.composite, this.context, this.getMaster());
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master) {
        Link lnk;
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        final IContributionClassCreator c = this.getEditor().getContributionCreator(UiPackageImpl.Literals.IMPERATIVE_EXPRESSION);
        if (this.project != null && c != null) {
            lnk = new Link(parent, 0);
            lnk.setText("<A>" + this.Messages.HandlerEditor_ClassURI + "</A>");
            lnk.setLayoutData((Object)new GridData(128));
            lnk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    c.createOpen((MContribution)ImperativeExpressionEditor.this.getMaster().getValue(), ImperativeExpressionEditor.this.getEditingDomain(), ImperativeExpressionEditor.this.project, lnk.getShell());
                }
            });
        } else {
            lnk = null;
            Label l = new Label(parent, 0);
            l.setText(this.Messages.HandlerEditor_ClassURI);
            l.setLayoutData((Object)new GridData(128));
        }
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (lnk != null) {
                    lnk.setToolTipText(((Text)e.getSource()).getText());
                }
            }
        });
        Binding binding = context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.CONTRIBUTION__CONTRIBUTION_URI).observeDetail((IObservableValue)this.getMaster()), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new ContributionURIValidator()), new UpdateValueStrategy());
        Util.addDecoration((Control)t, binding);
        final Button b = new Button(parent, 0x800008);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.zoom"));
        b.setText(this.Messages.ModelTooling_Common_FindEllipsis);
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionClassDialog dialog = new ContributionClassDialog(b.getShell(), ImperativeExpressionEditor.this.eclipseContext, ImperativeExpressionEditor.this.getEditingDomain(), (MApplicationElement)((MContribution)ImperativeExpressionEditor.this.getMaster().getValue()), (EStructuralFeature)ApplicationPackageImpl.Literals.CONTRIBUTION__CONTRIBUTION_URI, ImperativeExpressionEditor.this.Messages);
                dialog.open();
            }
        });
        Label l = new Label(parent, 0);
        l.setText(this.Messages.ImperativeExpressionEditor_TrackingLabel);
        l.setLayoutData((Object)new GridData(128));
        Button trackingButton = new Button(parent, 32);
        ISWTObservableValue observeTrackingSelection = WidgetProperties.selection().observe((Widget)trackingButton);
        context.bindValue((IObservableValue)observeTrackingSelection, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.IMPERATIVE_EXPRESSION__TRACKING).observeDetail((IObservableValue)this.getMaster()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MImperativeExpression.class);
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList getChildList(Object element) {
        return null;
    }
}

