/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.dltk.internal.ui.callhierarchy.OpenCallHierarchyAction;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.actions.OpenTypeHierarchyAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.Page;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private boolean fIsTypeHiararchyViewerOwner;
    private boolean fIsCallHiararchyViewerOwner;
    private ISelectionProvider fSelectionProvider;
    private OpenTypeHierarchyAction fOpenTypeHierarchy;
    private OpenCallHierarchyAction fOpenCallHierarchy;
    private PropertyDialogAction fOpenPropertiesDialog;
    boolean disableCallHierarcy = false;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), null);
    }

    public OpenViewActionGroup(Page page, ISelectionProvider selectionProvider) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), selectionProvider);
    }

    public OpenViewActionGroup(IViewPart part) {
        this(part, null);
    }

    public OpenViewActionGroup(IViewPart part, ISelectionProvider selectionProvider) {
        this.createSiteActions((IWorkbenchSite)part.getSite(), selectionProvider);
        String partName = part.getClass().getName();
        this.fIsTypeHiararchyViewerOwner = "org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart".equals(partName);
        this.fIsCallHiararchyViewerOwner = "org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyViewPart".equals(partName);
    }

    public OpenViewActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        this.createSiteActions(site, selectionProvider);
    }

    public OpenViewActionGroup(ScriptEditor part) {
        this.fEditorIsOwner = true;
        if (part.getCallHierarchyID() == null) {
            this.disableCallHierarcy = true;
        }
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction((IEditorPart)part);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.type.hierarchy");
        part.setAction("OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        if (!this.disableCallHierarcy) {
            this.fOpenCallHierarchy = new OpenCallHierarchyAction(part);
            this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.call.hierarchy");
            part.setAction("OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        }
        this.initialize(part.getEditorSite().getSelectionProvider());
    }

    private void createSiteActions(IWorkbenchSite site, ISelectionProvider specialProvider) {
        ISelectionProvider provider;
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(site);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.type.hierarchy");
        this.fOpenTypeHierarchy.setSpecialSelectionProvider(specialProvider);
        if (!this.disableCallHierarcy) {
            this.fOpenCallHierarchy = new OpenCallHierarchyAction(site);
            this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.call.hierarchy");
            this.fOpenCallHierarchy.setSpecialSelectionProvider(specialProvider);
        }
        ISelectionProvider iSelectionProvider = provider = specialProvider != null ? specialProvider : site.getSelectionProvider();
        if (this.getShowProperties()) {
            this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, provider);
            this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        }
        this.initialize(provider);
    }

    private void initialize(ISelectionProvider provider) {
        this.fSelectionProvider = provider;
        ISelection selection = provider.getSelection();
        this.fOpenTypeHierarchy.update(selection);
        if (!this.disableCallHierarcy) {
            this.fOpenCallHierarchy.update(selection);
        }
        if (!this.fEditorIsOwner) {
            if (this.getShowProperties()) {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    this.fOpenPropertiesDialog.selectionChanged(ss);
                } else {
                    this.fOpenPropertiesDialog.selectionChanged(selection);
                }
            }
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
            if (!this.disableCallHierarcy) {
                provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
            }
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.fIsTypeHiararchyViewerOwner) {
            this.appendToGroup(menu, (IAction)this.fOpenTypeHierarchy);
        }
        if (!this.fIsCallHiararchyViewerOwner && !this.disableCallHierarcy) {
            this.appendToGroup(menu, (IAction)this.fOpenCallHierarchy);
        }
        IStructuredSelection selection = this.getStructuredSelection();
        if (this.getShowProperties() && this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection(selection)) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    public void dispose() {
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
        if (!this.disableCallHierarcy) {
            this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        }
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        if (!this.disableCallHierarcy) {
            actionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        }
        if (!this.fEditorIsOwner && this.getShowProperties()) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected boolean getShowProperties() {
        return true;
    }
}

