/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputRequestor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ViewerInputService;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class FlexibleSignalsView
extends AbstractDebugView
implements IViewerUpdateListener,
IDebugContextListener,
IModelChangedListener {
    private PresentationContext fPresentationContext;
    private DelegatingModelPresentation fModelPresentation;
    private IViewerInputRequestor fRequester = new IViewerInputRequestor(){

        public void viewerInputComplete(IViewerInputUpdate update) {
            if (!update.isCanceled()) {
                FlexibleSignalsView.this.viewerInputUpdateComplete(update);
            }
        }
    };
    private ViewerInputService fInputService;

    protected Viewer createViewer(Composite parent) {
        this.getModelPresentation();
        TreeModelViewer signalsViewer = this.createTreeViewer(parent);
        this.fInputService = new ViewerInputService((ITreeModelViewer)signalsViewer, this.fRequester);
        this.getSite().setSelectionProvider((ISelectionProvider)signalsViewer);
        signalsViewer.addModelChangedListener((IModelChangedListener)this);
        signalsViewer.addViewerUpdateListener((IViewerUpdateListener)this);
        return signalsViewer;
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new DelegatingModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected TreeModelViewer createTreeViewer(Composite parent) {
        int style = this.getViewerStyle();
        this.fPresentationContext = new DebugModelPresentationContext(this.getPresentationContextId(), (IWorkbenchPart)this, (IDebugModelPresentation)this.fModelPresentation);
        TreeModelViewer variablesViewer = new TreeModelViewer(parent, style, (IPresentationContext)this.fPresentationContext);
        variablesViewer.getPresentationContext().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IAction action;
                if ("PROPERTY_COLUMNS".equals(event.getProperty()) && (action = FlexibleSignalsView.this.getAction("ShowTypeNames")) != null) {
                    action.setEnabled(event.getNewValue() == null);
                }
            }
        });
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        return variablesViewer;
    }

    protected void viewerInputUpdateComplete(IViewerInputUpdate update) {
        this.setViewerInput(update.getInputElement());
    }

    protected void setViewerInput(Object context) {
        Object current = this.getViewer().getInput();
        if (current == null && context == null) {
            return;
        }
        if (current != null && current.equals(context)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(context);
    }

    protected String getPresentationContextId() {
        return ICDebugUIConstants.ID_SIGNALS_VIEW;
    }

    protected int getViewerStyle() {
        return 268501762;
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SIGNALS_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void viewerUpdatesBegin() {
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.incrementBusy();
        }
    }

    public void viewerUpdatesComplete() {
        IWorkbenchSiteProgressService progressService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progressService != null) {
            progressService.decrementBusy();
        }
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public void updateComplete(IViewerUpdate update) {
        IStatus status = update.getStatus();
        if (!update.isCanceled()) {
            if (status != null && !status.isOK()) {
                this.showMessage(status.getMessage());
            } else {
                this.showViewer();
            }
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    protected void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Object source = ((IStructuredSelection)selection).getFirstElement();
            this.fInputService.resolveViewerInput(source);
        }
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
    }
}

