/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.HashMap;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2113
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public BP2113(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPHeader header, Object parent, WSDLTraversalContext ctx) {
        Definition d = (Definition)ctx.getParameter("definition");
        Message m = d.getMessage(header.getMessage());
        if (m != null) {
            this.checkPart(m.getPart(header.getPart()), ctx.getBinding());
        }
    }

    public void visit(SOAPHeaderFault fault, Object parent, WSDLTraversalContext ctx) {
        Definition d = (Definition)ctx.getParameter("definition");
        Message m = d.getMessage(fault.getMessage());
        if (m != null) {
            this.checkPart(m.getPart(fault.getPart()), ctx.getBinding());
        }
    }

    public void visit(SOAPFault fault, Object parent, WSDLTraversalContext ctx) {
        Operation op;
        String faultName = fault.getName();
        if (faultName == null) {
            faultName = ctx.getBindingFault().getName();
        }
        if ((op = ctx.getBindingOperation().getOperation()) == null) {
            return;
        }
        Fault f = op.getFault(faultName);
        if (f == null) {
            return;
        }
        Message m = f.getMessage();
        if (m == null || m.getParts() == null || m.getParts().size() != 1) {
            return;
        }
        this.checkPart((Part)m.getOrderedParts(null).get(0), ctx.getBinding());
    }

    private void checkPart(Part p, Binding b) {
        if (p != null && p.getElementName() == null) {
            this.errors.add(b.getQName(), p.getName());
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitSOAPHeader(true);
        traversal.visitSOAPHeaderFault(true);
        traversal.visitSOAPFault(true);
        HashMap<String, Definition> m = new HashMap<String, Definition>();
        Definition def = entryContext.getWSDLDocument().getDefinitions();
        WSDLUtil.expandDefinition(def);
        m.put("definition", def);
        traversal.traverse((Binding)entryContext.getEntry().getEntryDetail(), m);
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

