/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.components;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ExposedFieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ExposedPropertyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ThisVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public final class JavaInfoReferenceProvider
implements IReferenceProvider {
    public static boolean LAZY_DETECTED;
    private JavaInfo m_javaInfo;

    public JavaInfoReferenceProvider(JavaInfo javaInfo) {
        this.m_javaInfo = javaInfo;
    }

    public void setJavaInfo(JavaInfo javaInfo) {
        this.m_javaInfo = javaInfo;
    }

    public String getReference() throws Exception {
        return JavaInfoReferenceProvider.getReference(this.m_javaInfo);
    }

    public static String getReference(JavaInfo javaInfo) throws Exception {
        VariableSupport variableSupport = javaInfo.getVariableSupport();
        if (LAZY_DETECTED && variableSupport instanceof LazyVariableSupport) {
            LazyVariableSupport lazyVariableSupport = (LazyVariableSupport)variableSupport;
            return lazyVariableSupport.getAccessorReferenceExpression();
        }
        if (variableSupport instanceof ThisVariableSupport) {
            return "this";
        }
        if (variableSupport instanceof AbstractSimpleVariableSupport && variableSupport.hasName()) {
            return variableSupport.getName();
        }
        if (variableSupport instanceof ExposedPropertyVariableSupport || variableSupport instanceof ExposedFieldVariableSupport) {
            try {
                for (ASTNode node : javaInfo.getRelatedNodes()) {
                    if (!AstNodeUtils.isVariable((ASTNode)node)) continue;
                    return CoreUtils.getNodeReference((ASTNode)node);
                }
            }
            catch (Throwable throwable) {}
            String reference = JavaInfoReferenceProvider.getReference(javaInfo.getParentJava());
            if (reference != null) {
                return String.valueOf(reference) + "." + variableSupport.getTitle();
            }
        }
        return null;
    }
}

