/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import java.lang.reflect.Field;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IExposedCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;

public final class ExposedFieldCreationSupport
extends CreationSupport
implements IImplicitCreationSupport,
IExposedCreationSupport {
    private final JavaInfo m_hostJavaInfo;
    private final Field m_field;
    private final String m_fieldName;
    private final boolean m_direct;

    public ExposedFieldCreationSupport(JavaInfo hostJavaInfo, Field field, boolean direct) {
        this.m_hostJavaInfo = hostJavaInfo;
        this.m_field = field;
        this.m_fieldName = this.m_field.getName();
        this.m_direct = direct;
    }

    public String toString() {
        return "field: " + this.m_field.getType().getName();
    }

    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_hostJavaInfo.addBroadcastListener(new JavaInfoSetObjectAfter(){

            public void invoke(JavaInfo target, Object o) throws Exception {
                Object object;
                if (target == ExposedFieldCreationSupport.this.m_hostJavaInfo && ExposedFieldCreationSupport.this.m_javaInfo.getObject() == null && (object = ExposedFieldCreationSupport.this.m_field.get(o)) != null) {
                    ExposedFieldCreationSupport.this.m_javaInfo.setObject(object);
                }
            }
        });
        this.m_javaInfo.addBroadcastListener(new ObjectInfoPresentationDecorateIcon(){

            public void invoke(ObjectInfo object, Image[] icon) throws Exception {
                if (object == ExposedFieldCreationSupport.this.m_javaInfo) {
                    Image decorator = DesignerPlugin.getImage((String)"exposed/decorator.gif");
                    icon[0] = SwtResourceManager.decorateImage((Image)icon[0], (Image)decorator, (int)4);
                }
            }
        });
    }

    public boolean isJavaInfo(ASTNode node) {
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            return this.isNameOfField(simpleName) && !this.isFieldHidden(simpleName) && this.m_hostJavaInfo.isRepresentedBy(null);
        }
        if (node instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)node;
            Name qualifier = qualifiedName.getQualifier();
            SimpleName simpleName = qualifiedName.getName();
            return this.isNameOfField(simpleName) && this.m_hostJavaInfo.isRepresentedBy((ASTNode)qualifier);
        }
        return false;
    }

    public ASTNode getNode() {
        return this.m_hostJavaInfo.getCreationSupport().getNode();
    }

    private boolean isNameOfField(SimpleName simpleName) {
        return simpleName.getIdentifier().equals(this.m_fieldName);
    }

    private boolean isFieldHidden(SimpleName simpleName) {
        if (AstNodeUtils.isVariable((ASTNode)simpleName)) {
            ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(this.m_hostJavaInfo).getFlowDescription();
            return ExecutionFlowUtils.getLastAssignment(flowDescription, (ASTNode)simpleName) != null;
        }
        return false;
    }

    public JavaInfo getHostJavaInfo() {
        return this.m_hostJavaInfo;
    }

    public Field getField() {
        return this.m_field;
    }

    public boolean isDirect() {
        return this.m_direct;
    }

    public boolean canDelete() {
        return true;
    }

    public void delete() throws Exception {
        JavaInfoUtils.deleteJavaInfo(this.m_javaInfo, false);
    }

    public IClipboardImplicitCreationSupport getImplicitClipboard() {
        final String fieldName = this.m_fieldName;
        return new IClipboardImplicitCreationSupport(){
            private static final long serialVersionUID = 0L;

            public JavaInfo find(JavaInfo host) throws Exception {
                for (JavaInfo child : host.getChildrenJava()) {
                    ExposedFieldCreationSupport exposedCreation;
                    if (!(child.getCreationSupport() instanceof ExposedFieldCreationSupport) || !(exposedCreation = (ExposedFieldCreationSupport)child.getCreationSupport()).m_fieldName.equals(fieldName)) continue;
                    return child;
                }
                return null;
            }
        };
    }
}

