/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.util;

import com.google.inject.Injector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.handlers.RuntimeMatcherRegistrator;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;

class QueryExplorerDeltaVisitor
implements IResourceDeltaVisitor {
    private final Injector injector;

    public QueryExplorerDeltaVisitor(Injector injector) {
        this.injector = injector;
    }

    public boolean visit(IResourceDelta delta) {
        IResource res = delta.getResource();
        if (res instanceof IFile && (delta.getFlags() & 0x100) > 0) {
            IFile file = (IFile)res;
            if (QueryExplorerPatternRegistry.getInstance().getFiles().contains(file)) {
                RuntimeMatcherRegistrator registrator = new RuntimeMatcherRegistrator(file, null);
                this.injector.injectMembers((Object)registrator);
                Display.getDefault().asyncExec((Runnable)registrator);
            }
            return false;
        }
        return true;
    }
}

