/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.util;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.viatra.query.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.specification.GenericQuerySpecification;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

@Singleton
public class DisplayUtil {
    private static Map<URI, AdapterFactoryLabelProvider> registeredItemProviders = Maps.newHashMap();
    private static Map<URI, IConfigurationElement> uriConfElementMap = null;
    private static ILog logger = ViatraQueryGUIPlugin.getDefault().getLog();
    private static Map<String, IMarker> orderByPatternMarkers = Maps.newHashMap();
    public static final String ORDERBY_ANNOTATION = "OrderBy";
    @Inject
    private IResourceSetProvider resSetProvider;
    private Map<IProject, ResourceSet> resourceSetMap = new WeakHashMap<IProject, ResourceSet>();

    public static void addOrderByPatternWarning(String patternFqn, String message) {
        IQuerySpecification<?> specification;
        if (orderByPatternMarkers.get(patternFqn) == null && (specification = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(patternFqn)) instanceof GenericQuerySpecification) {
            Pattern pattern = ((GenericQuerySpecification)specification).getInternalQueryRepresentation().getPattern();
            URI uri = pattern.eResource().getURI();
            String platformString = uri.toPlatformString(true);
            IResource markerLoc = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            try {
                IMarker marker = markerLoc.createMarker("org.eclipse.emf.ecore.diagnostic");
                marker.setAttribute("severity", 1);
                marker.setAttribute("transient", true);
                marker.setAttribute("location", (Object)pattern.getName());
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)pattern).toString());
                marker.setAttribute("message", (Object)message);
                orderByPatternMarkers.put(patternFqn, marker);
            }
            catch (CoreException e) {
                logger.log((IStatus)new Status(4, "org.eclipse.viatra.query.tooling.ui", "Marker could not be created for pattern: " + patternFqn, (Throwable)e));
            }
        }
    }

    public static void removeOrderByPatternWarning(String patternFqn) {
        IMarker marker = orderByPatternMarkers.remove(patternFqn);
        if (marker != null) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                logger.log((IStatus)new Status(4, "org.eclipse.viatra.query.tooling.ui", "Marker could not be deleted: " + marker.toString(), (Throwable)e));
            }
        }
    }

    public static synchronized AdapterFactoryLabelProvider getAdapterFactoryLabelProvider(URI uri) {
        AdapterFactoryLabelProvider af;
        if (uriConfElementMap == null) {
            uriConfElementMap = DisplayUtil.collectItemProviders();
        }
        if ((af = registeredItemProviders.get(uri)) != null) {
            return af;
        }
        IConfigurationElement ce = uriConfElementMap.get(uri);
        try {
            if (ce != null) {
                Object obj = ce.createExecutableExtension("class");
                AdapterFactoryLabelProvider lp = new AdapterFactoryLabelProvider((AdapterFactory)obj);
                registeredItemProviders.put(uri, lp);
                return lp;
            }
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "org.eclipse.viatra.query.tooling.ui", "AdapterFactory could not be created for uri: " + uri.toString(), (Throwable)e));
        }
        return null;
    }

    private static Map<URI, IConfigurationElement> collectItemProviders() {
        HashMap<URI, IConfigurationElement> result = new HashMap<URI, IConfigurationElement>();
        try {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.emf.edit.itemProviderAdapterFactories");
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension e = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ce.getName().matches("factory")) {
                        URI uri = URI.createURI((String)ce.getAttribute("uri"));
                        result.put(uri, ce);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.log((IStatus)new Status(4, "org.eclipse.viatra.query.tooling.ui", "Collecting item providers failed.", (Throwable)e));
        }
        return result;
    }

    public static String getMessage(ViatraQueryMatcher<? extends IPatternMatch> matcher, int matchesSize, String patternFqn) {
        return DisplayUtil.getMessage(matcher, matchesSize, patternFqn, false, false, null, null);
    }

    public static String getMessage(ViatraQueryMatcher<? extends IPatternMatch> matcher, int matchesSize, String patternFqn, IQueryBackendFactory backend) {
        return DisplayUtil.getMessage(matcher, matchesSize, patternFqn, false, false, null, backend);
    }

    public static String getMessage(ViatraQueryMatcher<? extends IPatternMatch> matcher, int matchesSize, String patternFqn, boolean isGenerated, boolean isFiltered, String exceptionMessage, IQueryBackendFactory backend) {
        String matchString;
        if (matcher == null) {
            if (exceptionMessage != null) {
                return String.format("%s - %s", patternFqn, exceptionMessage);
            }
            return String.format("%s - See mouseover text for query loading errors", patternFqn);
        }
        switch (matchesSize) {
            case 0: {
                matchString = "No matches";
                break;
            }
            case 1: {
                matchString = "1 match";
                break;
            }
            default: {
                matchString = String.format("%d matches", matchesSize);
            }
        }
        String isFilteredString = isFiltered ? " - Filtered" : "";
        String isGeneratedString = isGenerated ? "Generated" : "Runtime";
        String backendText = backend == null ? "" : " " + DisplayUtil.getQueryBackendName(backend);
        return String.format("%s - %s %s (%s%s)", matcher.getPatternName(), matchString, isFilteredString, isGeneratedString, backendText);
    }

    public static String getQueryBackendName(IQueryBackendFactory backend) {
        return backend.getBackendClass().getSimpleName();
    }

    public static String getMessage(IPatternMatch match) {
        return DisplayUtil.getMessageForMatch(match);
    }

    private static String getMessageForMatch(IPatternMatch match) {
        String patternName = match.patternName();
        for (IQuerySpecification<?> p : QueryExplorerPatternRegistry.getInstance().getActivePatterns()) {
            PAnnotation annotation;
            if (!p.getFullyQualifiedName().matches(patternName) || (annotation = p.getFirstAnnotationByName("QueryExplorer")) == null) continue;
            return (String)annotation.getFirstValue("message");
        }
        StringBuilder message = new StringBuilder();
        if (match.parameterNames().size() == 0) {
            message.append("(Match)");
        } else {
            int i = 0;
            for (String v : match.parameterNames()) {
                if (i > 0) {
                    message.append(", ");
                }
                message.append(String.format("%s=$%s$", v, v));
                ++i;
            }
        }
        return message.toString();
    }

    public PatternModel extractPatternModelFromResource(Resource resource) {
        if (resource != null) {
            if (resource.getErrors().size() > 0) {
                return null;
            }
            if (resource.getContents().size() >= 1) {
                EObject topElement = (EObject)resource.getContents().get(0);
                return topElement instanceof PatternModel ? (PatternModel)topElement : null;
            }
        }
        return null;
    }

    public PatternModel parseEPM(IFile file) {
        if (file == null) {
            return null;
        }
        ResourceSet resourceSet = null;
        IProject project = file.getProject();
        if (this.resourceSetMap.containsKey(project)) {
            resourceSet = this.resourceSetMap.get(project);
        } else {
            resourceSet = this.resSetProvider.get(project);
            this.resourceSetMap.put(project, resourceSet);
        }
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource resource = resourceSet.getResource(fileURI, false);
        try {
            if (resource == null) {
                resource = resourceSet.createResource(fileURI);
            } else if (resource.isLoaded()) {
                TreeIterator it = resource.getAllContents();
                QueryExplorerPatternRegistry queryRegistry = QueryExplorerPatternRegistry.getInstance();
                QueryExplorer queryExplorer = QueryExplorer.getInstance();
                while (it.hasNext()) {
                    EObject next = (EObject)it.next();
                    if (!(next instanceof Pattern)) continue;
                    Pattern oldPattern = (Pattern)next;
                    String fqn = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)oldPattern);
                    queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot().removeComponent(fqn);
                    queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot().purge();
                    queryRegistry.removeActivePattern(fqn);
                    it.prune();
                }
                queryExplorer.getPatternsViewer().setInput((Object)queryExplorer.getPatternsViewerRoot());
                resource.unload();
            }
            resource.load(null);
        }
        catch (IOException e) {
            return null;
        }
        return this.extractPatternModelFromResource(resource);
    }
}

