/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

class QueryResultTreeLabelProvider
extends ColumnLabelProvider {
    private final ImageRegistry imageRegistry = ViatraQueryGUIPlugin.getDefault().getImageRegistry();
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;

    public QueryResultTreeLabelProvider() {
        AdapterFactoryLabelProvider _adapterFactoryLabelProvider;
        AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
        this.adapterFactoryLabelProvider = _adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
    }

    public Image getImage(Object element) {
        return this.getImageInternal(element);
    }

    protected Image _getImageInternal(QueryResultTreeInput element) {
        return this.imageRegistry.get("navigator_root");
    }

    protected Image _getImageInternal(QueryResultTreeMatcher element) {
        Image _xifexpression = null;
        Exception _exception = element.getException();
        boolean _notEquals = !Objects.equal((Object)_exception, null);
        _xifexpression = _notEquals ? this.imageRegistry.get("error") : this.imageRegistry.get("matcher");
        return _xifexpression;
    }

    protected Image _getImageInternal(IPatternMatch element) {
        return this.imageRegistry.get("match");
    }

    protected Image _getImageInternal(Object element) {
        return this.adapterFactoryLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        return this.getTextInternal(element);
    }

    protected String _getTextInternal(QueryResultTreeInput element) {
        AdvancedViatraQueryEngine _engine = element.getEngine();
        return _engine.toString();
    }

    protected String _getTextInternal(QueryResultTreeMatcher element) {
        boolean _notEquals;
        Exception _exception = element.getException();
        boolean bl = _notEquals = !Objects.equal((Object)_exception, null);
        if (_notEquals) {
            StringConcatenation _builder = new StringConcatenation();
            IQuerySpecificationRegistryEntry _entry = element.getEntry();
            String _fullyQualifiedName = null;
            if (_entry != null) {
                _fullyQualifiedName = _entry.getFullyQualifiedName();
            }
            _builder.append((Object)_fullyQualifiedName, "");
            _builder.append((Object)" - ");
            Exception _exception_1 = element.getException();
            String _message = _exception_1.getMessage();
            _builder.append((Object)_message, "");
            return _builder.toString();
        }
        ViatraQueryMatcher matcher = element.getMatcher();
        IPatternMatch _filterMatch = element.getFilterMatch();
        int count = matcher.countMatches(_filterMatch);
        String _switchResult = null;
        switch (count) {
            case 0: {
                _switchResult = "No matches";
                break;
            }
            case 1: {
                _switchResult = "1 match";
                break;
            }
            default: {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)count, "");
                _builder_1.append((Object)" matches");
                _switchResult = _builder_1.toString();
            }
        }
        String countMsg = _switchResult;
        String _xifexpression = null;
        boolean _isFiltered = element.isFiltered();
        _xifexpression = _isFiltered ? " (Filtered)" : "";
        String filterMsg = _xifexpression;
        StringConcatenation _builder_1 = new StringConcatenation();
        IQuerySpecification _specification = matcher.getSpecification();
        String _fullyQualifiedName_1 = _specification.getFullyQualifiedName();
        _builder_1.append((Object)_fullyQualifiedName_1, "");
        _builder_1.append((Object)" - ");
        _builder_1.append((Object)countMsg, "");
        _builder_1.append((Object)filterMsg, "");
        return _builder_1.toString();
    }

    protected String _getTextInternal(IPatternMatch element) {
        boolean _notEquals;
        String message = DisplayUtil.getMessage((IPatternMatch)element);
        boolean bl = _notEquals = !Objects.equal((Object)message, null);
        if (_notEquals) {
            Function<Object, String> _function = new Function<Object, String>(){

                public String apply(Object it) {
                    return QueryResultTreeLabelProvider.this.adapterFactoryLabelProvider.getText(it);
                }
            };
            return ViatraQueryRuntimeHelper.getMessage((IPatternMatch)element, (String)message, (Function)_function);
        }
        return element.prettyPrint();
    }

    protected String _getTextInternal(Object element) {
        return this.adapterFactoryLabelProvider.getText(element);
    }

    public Image getImageInternal(Object element) {
        if (element instanceof IPatternMatch) {
            return this._getImageInternal((IPatternMatch)element);
        }
        if (element instanceof QueryResultTreeInput) {
            return this._getImageInternal((QueryResultTreeInput)element);
        }
        if (element instanceof QueryResultTreeMatcher) {
            return this._getImageInternal((QueryResultTreeMatcher)element);
        }
        if (element != null) {
            return this._getImageInternal(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public String getTextInternal(Object element) {
        if (element instanceof IPatternMatch) {
            return this._getTextInternal((IPatternMatch)element);
        }
        if (element instanceof QueryResultTreeInput) {
            return this._getTextInternal((QueryResultTreeInput)element);
        }
        if (element instanceof QueryResultTreeMatcher) {
            return this._getTextInternal((QueryResultTreeMatcher)element);
        }
        if (element != null) {
            return this._getTextInternal(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

