/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineManager;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryHintOption;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class ViatraQueryEngineContentProvider implements ITreeContentProvider {
  protected AdapterFactoryContentProvider adapterFactoryContentProvider;
  
  @Accessors
  protected boolean traverseResources = true;
  
  @Accessors
  protected boolean traverseEObjects = true;
  
  public ViatraQueryEngineContentProvider() {
    final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    AdapterFactoryContentProvider _adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory);
    this.adapterFactoryContentProvider = _adapterFactoryContentProvider;
  }
  
  @Override
  public Object[] getChildren(final Object parentElement) {
    return ((Object[])Conversions.unwrapArray(this.getChildrenInternal(parentElement), Object.class));
  }
  
  protected List<?> _getChildrenInternal(final Object parentElement) {
    Object[] _children = this.adapterFactoryContentProvider.getChildren(parentElement);
    return IterableExtensions.<Object>toList(((Iterable<Object>)Conversions.doWrapArray(_children)));
  }
  
  protected List<?> _getChildrenInternal(final EObject parentElement) {
    if (this.traverseEObjects) {
      Object[] _children = this.adapterFactoryContentProvider.getChildren(parentElement);
      return IterableExtensions.<Object>toList(((Iterable<Object>)Conversions.doWrapArray(_children)));
    } else {
      return CollectionLiterals.<Object>emptyList();
    }
  }
  
  protected List<?> _getChildrenInternal(final Resource parentElement) {
    if (this.traverseResources) {
      Object[] _children = this.adapterFactoryContentProvider.getChildren(parentElement);
      return IterableExtensions.<Object>toList(((Iterable<Object>)Conversions.doWrapArray(_children)));
    } else {
      return CollectionLiterals.<Object>emptyList();
    }
  }
  
  protected List<?> _getChildrenInternal(final ViatraQueryEngineManager parentElement) {
    Set<ViatraQueryEngine> _existingQueryEngines = parentElement.getExistingQueryEngines();
    return IterableExtensions.<ViatraQueryEngine>toList(_existingQueryEngines);
  }
  
  protected List<?> _getChildrenInternal(final AdvancedViatraQueryEngine parentElement) {
    final ViatraQueryEngineOptions engineOptions = parentElement.getEngineOptions();
    final QueryScope scope = parentElement.getScope();
    if ((scope instanceof EMFScope)) {
      final Set<? extends Notifier> roots = ((EMFScope)scope).getScopeRoots();
      final BaseIndexOptions options = ((EMFScope)scope).getOptions();
      ImmutableList.Builder<Object> _builder = ImmutableList.<Object>builder();
      ImmutableList.Builder<Object> _addAll = _builder.addAll(roots);
      ImmutableList.Builder<Object> _add = _addAll.add(engineOptions);
      ImmutableList.Builder<Object> _add_1 = _add.add(options);
      return _add_1.build();
    } else {
      return Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(scope, engineOptions));
    }
  }
  
  protected List<?> _getChildrenInternal(final BaseIndexOptions parentElement) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Dynamic EMF mode");
    boolean _isDynamicEMFMode = parentElement.isDynamicEMFMode();
    Pair<String, Boolean> _mappedTo = Pair.<String, Boolean>of(_builder.toString(), Boolean.valueOf(_isDynamicEMFMode));
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("Wildcard mode");
    boolean _isWildcardMode = parentElement.isWildcardMode();
    Pair<String, Boolean> _mappedTo_1 = Pair.<String, Boolean>of(_builder_1.toString(), Boolean.valueOf(_isWildcardMode));
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("Traverse only well-behaving features");
    boolean _isTraverseOnlyWellBehavingDerivedFeatures = parentElement.isTraverseOnlyWellBehavingDerivedFeatures();
    Pair<String, Boolean> _mappedTo_2 = Pair.<String, Boolean>of(_builder_2.toString(), Boolean.valueOf(_isTraverseOnlyWellBehavingDerivedFeatures));
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("Resource filter");
    IBaseIndexResourceFilter _resourceFilterConfiguration = parentElement.getResourceFilterConfiguration();
    Pair<String, IBaseIndexResourceFilter> _mappedTo_3 = Pair.<String, IBaseIndexResourceFilter>of(_builder_3.toString(), _resourceFilterConfiguration);
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("Object filter");
    IBaseIndexObjectFilter _objectFilterConfiguration = parentElement.getObjectFilterConfiguration();
    Pair<String, IBaseIndexObjectFilter> _mappedTo_4 = Pair.<String, IBaseIndexObjectFilter>of(_builder_4.toString(), _objectFilterConfiguration);
    final List<? extends Pair<String, ?>> baseOptions = Collections.<Pair<String, ?>>unmodifiableList(CollectionLiterals.<Pair<String, ?>>newArrayList(_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4));
    return baseOptions;
  }
  
  protected List<?> _getChildrenInternal(final ViatraQueryEngineOptions parentElement) {
    QueryEvaluationHint _engineDefaultHints = parentElement.getEngineDefaultHints();
    return this.getChildrenInternal(_engineDefaultHints);
  }
  
  protected List<?> _getChildrenInternal(final QueryEvaluationHint parentElement) {
    ImmutableList.Builder<Object> _builder = ImmutableList.<Object>builder();
    IQueryBackendFactory _queryBackendFactory = parentElement.getQueryBackendFactory();
    final ImmutableList.Builder<Object> builder = _builder.add(_queryBackendFactory);
    Map<QueryHintOption, Object> _backendHintSettings = parentElement.getBackendHintSettings();
    boolean _isEmpty = _backendHintSettings.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      Map<QueryHintOption, Object> _backendHintSettings_1 = parentElement.getBackendHintSettings();
      Set<Map.Entry<QueryHintOption, Object>> _entrySet = _backendHintSettings_1.entrySet();
      builder.add(_entrySet);
    } else {
      builder.add("No hints specified");
    }
    return builder.build();
  }
  
  protected List<?> _getChildrenInternal(final ResourceSet parentElement) {
    return parentElement.getResources();
  }
  
  @Override
  public Object[] getElements(final Object inputElement) {
    return this.getChildren(inputElement);
  }
  
  @Override
  public Object getParent(final Object element) {
    return null;
  }
  
  @Override
  public boolean hasChildren(final Object element) {
    boolean _and = false;
    Object[] _children = this.getChildren(element);
    boolean _notEquals = (!Objects.equal(_children, null));
    if (!_notEquals) {
      _and = false;
    } else {
      Object[] _children_1 = this.getChildren(element);
      boolean _isEmpty = ((List<Object>)Conversions.doWrapArray(_children_1)).isEmpty();
      boolean _not = (!_isEmpty);
      _and = _not;
    }
    return _and;
  }
  
  /**
   * Default implementation does nothing
   */
  @Override
  public void dispose() {
  }
  
  /**
   * Default implementation does nothing
   */
  @Override
  public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
  }
  
  public List<?> getChildrenInternal(final Object parentElement) {
    if (parentElement instanceof EObject) {
      return _getChildrenInternal((EObject)parentElement);
    } else if (parentElement instanceof Resource) {
      return _getChildrenInternal((Resource)parentElement);
    } else if (parentElement instanceof ResourceSet) {
      return _getChildrenInternal((ResourceSet)parentElement);
    } else if (parentElement instanceof AdvancedViatraQueryEngine) {
      return _getChildrenInternal((AdvancedViatraQueryEngine)parentElement);
    } else if (parentElement instanceof ViatraQueryEngineManager) {
      return _getChildrenInternal((ViatraQueryEngineManager)parentElement);
    } else if (parentElement instanceof ViatraQueryEngineOptions) {
      return _getChildrenInternal((ViatraQueryEngineOptions)parentElement);
    } else if (parentElement instanceof BaseIndexOptions) {
      return _getChildrenInternal((BaseIndexOptions)parentElement);
    } else if (parentElement instanceof QueryEvaluationHint) {
      return _getChildrenInternal((QueryEvaluationHint)parentElement);
    } else if (parentElement != null) {
      return _getChildrenInternal(parentElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(parentElement).toString());
    }
  }
  
  @Pure
  public boolean isTraverseResources() {
    return this.traverseResources;
  }
  
  public void setTraverseResources(final boolean traverseResources) {
    this.traverseResources = traverseResources;
  }
  
  @Pure
  public boolean isTraverseEObjects() {
    return this.traverseEObjects;
  }
  
  public void setTraverseEObjects(final boolean traverseEObjects) {
    this.traverseEObjects = traverseEObjects;
  }
}
