/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.filter;

import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.utility.StringMatcher;
import org.eclipse.team.svn.ui.history.filter.ILogEntryFilter;

public class AuthorNameLogEntryFilter
implements ILogEntryFilter {
    protected String authorNameToAccept;

    public AuthorNameLogEntryFilter() {
        this(null);
    }

    public AuthorNameLogEntryFilter(String authorNameToAccept) {
        this.authorNameToAccept = authorNameToAccept;
    }

    public boolean accept(SVNLogEntry logEntry) {
        if (this.authorNameToAccept == null) {
            return true;
        }
        StringMatcher matcher = new StringMatcher(this.authorNameToAccept);
        String authorName = logEntry.author == null ? "" : logEntry.author;
        return matcher.match(authorName);
    }

    public void setAuthorNameToAccept(String authorNameToAccept) {
        this.authorNameToAccept = authorNameToAccept;
    }

    public String getAuthorNameToAccept() {
        return this.authorNameToAccept;
    }
}

