/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.newmodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.common.tools.internal.ecore.EPackageHelper;
import org.eclipse.sirius.ui.tools.internal.wizards.newmodel.CreateEMFModelWizardDataModel;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectRootElementWizardPage
extends WizardPage
implements PropertyChangeListener {
    private Image eClassIcon = ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EClass"));
    private Text rootElementText;
    private Button rootElementCheckbox;
    private TableViewer rootElementFilteredList;
    private String rootElementFilter;
    private CreateEMFModelWizardDataModel dataModel;
    private RegexpViewerFilter filter;

    public SelectRootElementWizardPage(CreateEMFModelWizardDataModel dataModel) {
        super("SelectRootElementWizardPage");
        this.dataModel = dataModel;
        this.setTitle(Messages.SelectRootElementWizardPage_title);
        this.setDescription(Messages.SelectRootElementWizardPage_description);
    }

    public void setRootElementFilter(String theFilter) {
        if (this.rootElementText == null) {
            this.rootElementFilter = theFilter;
        } else {
            this.rootElementText.setText(theFilter);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        CLabel lblSelectRootElement = new CLabel(container, 0);
        lblSelectRootElement.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblSelectRootElement.setText(Messages.SelectRootElementWizardPage_label);
        this.createRootElementFilterText(container);
        this.createRootElementCheckbox(container);
        this.createRootElementFilteredList(container);
        this.setRootElementFilter("*");
        this.rootElementCheckbox.setSelection(true);
    }

    private void createRootElementFilterText(Composite parent) {
        this.rootElementText = new Text(parent, 2048);
        this.rootElementText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.rootElementText.setText(this.rootElementFilter == null ? "" : this.rootElementFilter);
        this.rootElementText.addListener(24, event -> {
            this.filter.setFilter(this.rootElementText.getText());
            this.rootElementFilteredList.refresh(true);
        });
        this.rootElementText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    SelectRootElementWizardPage.this.rootElementFilteredList.getTable().setFocus();
                }
            }
        });
    }

    private void createRootElementCheckbox(Composite parent) {
        this.rootElementCheckbox = new Button(parent, 32);
        this.rootElementCheckbox.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        this.rootElementCheckbox.setText(Messages.SelectRootElementWizardPage_checkboxLabel);
        this.rootElementCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRootElementWizardPage.this.updateRootElementFilteredList();
            }
        });
    }

    private void createRootElementFilteredList(Composite parent) {
        this.rootElementFilteredList = new TableViewer(parent, 68356);
        this.rootElementFilteredList.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.filter = new RegexpViewerFilter();
        this.filter.setFilter(this.rootElementFilter == null ? "" : this.rootElementFilter);
        this.rootElementFilteredList.setFilters(new ViewerFilter[]{this.filter});
        this.rootElementFilteredList.addSelectionChangedListener(event -> this.updateSelectedRootElement());
        this.rootElementFilteredList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        this.rootElementFilteredList.setLabelProvider((IBaseLabelProvider)new RootElementsListLabelProvider());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedPackage".equals(evt.getPropertyName())) {
            this.updateRootElementFilteredList();
            this.updateSelectedRootElement();
        }
    }

    private void updateSelectedRootElement() {
        ISelection selection = this.rootElementFilteredList.getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object[] selectionArray = structuredSelection.toArray();
            if (selectionArray.length == 1) {
                this.dataModel.setSelectedRootElement((EClass)selectionArray[0]);
                this.setPageComplete(true);
            } else {
                EClass preferredRootElement = EPackageHelper.getPreferredRootElementFromEPackageExtraData((EPackage)this.dataModel.getSelectedPackage());
                if (preferredRootElement != null) {
                    this.dataModel.setSelectedRootElement(preferredRootElement);
                    this.setPageComplete(true);
                } else {
                    this.dataModel.setSelectedRootElement(null);
                    this.setPageComplete(false);
                }
            }
        }
    }

    private void updateRootElementFilteredList() {
        if (this.rootElementCheckbox != null) {
            Object[] rootElements;
            if (this.rootElementCheckbox.getSelection()) {
                List eClassRootElements = EPackageHelper.getEClassRootElements((EPackage)this.dataModel.getSelectedPackage());
                rootElements = eClassRootElements.toArray();
            } else {
                rootElements = EPackageHelper.getConcreteClasses((EPackage)this.dataModel.getSelectedPackage()).toArray();
            }
            this.rootElementFilteredList.setInput((Object)rootElements);
            EClass preferredRootElement = EPackageHelper.getPreferredRootElementFromEPackageExtraData((EPackage)this.dataModel.getSelectedPackage());
            if (preferredRootElement != null) {
                this.rootElementFilteredList.setSelection((ISelection)new StructuredSelection((Object)preferredRootElement));
            } else if (rootElements.length > 0) {
                this.rootElementFilteredList.setSelection((ISelection)new StructuredSelection(rootElements[0]));
            }
            this.rootElementFilteredList.refresh(true);
        }
    }

    private final class RegexpViewerFilter
    extends ViewerFilter {
        private String filter;

        private RegexpViewerFilter() {
        }

        public void setFilter(String theFilter) {
            this.filter = theFilter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.filter.equals("*") && element instanceof EClass) {
                EClass eClass = (EClass)element;
                return eClass.getName() != null && eClass.getName().toLowerCase().contains(this.filter.toLowerCase());
            }
            return true;
        }
    }

    private class RootElementsListLabelProvider
    extends LabelProvider {
        private RootElementsListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EClass) {
                return ((EClass)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return SelectRootElementWizardPage.this.eClassIcon;
        }
    }
}

