/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.ReparentExecutionOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetMessageRangeOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetVerticalRangeOperation;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LostMessageEndEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceNodeCreationPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceSiriusGraphicalNodeEditPolicy;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusGraphicalNodeEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AirDefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.base.Option;

public final class ExecutionOperations {
    private ExecutionOperations() {
    }

    public static void installExecutionAwareNodeCreationPolicy(ISequenceEventEditPart self) {
        ExecutionOperations.replaceEditPolicy((IGraphicalEditPart)self, "ContainerEditPolicy", (EditPolicy)new SequenceNodeCreationPolicy(), NodeCreationEditPolicy.class);
        ExecutionOperations.replaceEditPolicy((IGraphicalEditPart)self, "GraphicalNodeEditPolicy", (EditPolicy)new SequenceSiriusGraphicalNodeEditPolicy(), SiriusGraphicalNodeEditPolicy.class);
    }

    public static void replaceEditPolicy(IGraphicalEditPart self, String role, EditPolicy editPolicy, Class<?> policyType) {
        if (self.getEditPolicy((Object)role) instanceof CompoundEditPolicy) {
            CompoundEditPolicy cep = (CompoundEditPolicy)self.getEditPolicy((Object)role);
            int i = 0;
            while (i < cep.getEditPolicies().size()) {
                if (policyType.isInstance(cep.getEditPolicies().get(i))) {
                    cep.getEditPolicies().set(i, editPolicy);
                    break;
                }
                ++i;
            }
            self.installEditPolicy((Object)role, (EditPolicy)cep);
        } else {
            self.installEditPolicy((Object)role, editPolicy);
        }
    }

    public static void adjustFigureSlidableArea(NodeFigure figure) {
        if (figure instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)figure).setSlidableAnchorArea(1.0);
        }
    }

    public static Command getReconnectEdgesToParentCommand(ExecutionEditPart exec) {
        CompoundCommand result = new CompoundCommand();
        ISequenceEventEditPart parentEP = (ISequenceEventEditPart)new EditPartQuery((IGraphicalEditPart)exec).getFirstAncestorOfType(ISequenceEventEditPart.class);
        AbstractNodeEvent execution = (AbstractNodeEvent)exec.getISequenceEvent();
        ISequenceEvent parent = execution.getHierarchicalParentEvent();
        Range parentRange = parent.getVerticalRange();
        for (SequenceMessageEditPart msg : Iterables.filter((Iterable)exec.getSourceConnections(), SequenceMessageEditPart.class)) {
            if (msg.getSource() == msg.getTarget()) continue;
            result.append(ExecutionOperations.getSourceReconnectionCommand(parentEP, parentRange, msg));
        }
        for (SequenceMessageEditPart msg : Iterables.filter((Iterable)exec.getTargetConnections(), SequenceMessageEditPart.class)) {
            if (msg.getSource() == msg.getTarget()) continue;
            result.append(ExecutionOperations.getTargetReconnectionCommand(parentEP, parentRange, msg));
        }
        for (SequenceMessageEditPart msg : Iterables.filter((Iterable)exec.getSourceConnections(), SequenceMessageEditPart.class)) {
            Message message = (Message)msg.getISequenceEvent();
            if (msg.getSource() != msg.getTarget()) continue;
            result.append(ExecutionOperations.getReflectiveReconnectionCommand(parentEP.getISequenceEvent(), parentRange, message, parentEP.getEditingDomain()));
        }
        if (result.isEmpty()) {
            return IdentityCommand.INSTANCE;
        }
        return result;
    }

    private static Command getReflectiveReconnectionCommand(ISequenceEvent parent, Range parentRange, Message msg, TransactionalEditingDomain domain) {
        CompoundCommand result = new CompoundCommand();
        Range currentRange = msg.getVerticalRange();
        SetMessageRangeOperation smrc = new SetMessageRangeOperation((Edge)msg.getNotationView(), currentRange, true);
        smrc.setSource(parent.getNotationView(), new Rectangle(0, parentRange.getLowerBound(), 0, parentRange.width()));
        smrc.setTarget(parent.getNotationView(), new Rectangle(0, parentRange.getLowerBound(), 0, parentRange.width()));
        result.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)smrc));
        return result;
    }

    private static Command getSourceReconnectionCommand(ISequenceEventEditPart parent, Range parentRange, SequenceMessageEditPart msg) {
        Rectangle targetBounds;
        CompoundCommand result = new CompoundCommand();
        Range currentRange = msg.getISequenceEvent().getVerticalRange();
        SetMessageRangeOperation smrc = new SetMessageRangeOperation((Edge)msg.getNotationView(), currentRange, true);
        smrc.setSource(parent.getNotationView(), new Rectangle(0, parentRange.getLowerBound(), 0, parentRange.width()));
        IGraphicalEditPart target = (IGraphicalEditPart)msg.getTarget();
        if (target instanceof ISequenceEventEditPart) {
            Range targetRange = SequenceEditPartsOperations.getVerticalRange((ISequenceEventEditPart)target);
            targetBounds = new Rectangle(0, targetRange.getLowerBound(), 0, targetRange.width());
        } else {
            targetBounds = target.getFigure().getBounds().getCopy();
            if (target.getFigure().getParent() != null) {
                target.getFigure().getParent().translateToAbsolute((Translatable)targetBounds);
            }
        }
        smrc.setTarget(target.getNotationView(), targetBounds);
        result.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)parent.getEditingDomain(), (AbstractModelChangeOperation)smrc));
        return result;
    }

    private static Command getTargetReconnectionCommand(ISequenceEventEditPart parent, Range parentRange, SequenceMessageEditPart msg) {
        Rectangle sourceBounds;
        CompoundCommand result = new CompoundCommand();
        Range currentRange = msg.getISequenceEvent().getVerticalRange();
        SetMessageRangeOperation smrc = new SetMessageRangeOperation((Edge)msg.getNotationView(), currentRange, true);
        IGraphicalEditPart source = (IGraphicalEditPart)msg.getSource();
        if (source instanceof ISequenceEventEditPart) {
            Range sourceRange = SequenceEditPartsOperations.getVerticalRange((ISequenceEventEditPart)source);
            sourceBounds = new Rectangle(0, sourceRange.getLowerBound(), 0, sourceRange.width());
        } else if (source instanceof LostMessageEndEditPart) {
            LostMessageEnd lostMessageEnd = ((LostMessageEndEditPart)source).getLostMessageEnd();
            sourceBounds = lostMessageEnd.getProperLogicalBounds().getCopy();
        } else {
            throw new RuntimeException(MessageFormat.format(Messages.ExecutionOperations_invalidMessageSource, String.valueOf(source)));
        }
        smrc.setSource(source.getNotationView(), sourceBounds);
        smrc.setTarget(parent.getNotationView(), new Rectangle(0, parentRange.getLowerBound(), 0, parentRange.width()));
        result.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)parent.getEditingDomain(), (AbstractModelChangeOperation)smrc));
        return result;
    }

    public static Command getReconnectSubExecutionsToParentCommand(ExecutionEditPart removedExecEditPart) {
        CompoundCommand result = new CompoundCommand();
        ISequenceEvent removedExec = removedExecEditPart.getISequenceEvent();
        if (removedExec != null) {
            ISequenceEvent futureParent = removedExec.getHierarchicalParentEvent();
            TransactionalEditingDomain domain = removedExecEditPart.getEditingDomain();
            for (View hierarchicalChild : Iterables.filter((Iterable)Iterables.filter((Iterable)removedExec.getNotationView().getChildren(), View.class), (Predicate)AbstractNodeEvent.notationPredicate())) {
                Option child = ISequenceElementAccessor.getAbstractNodeEvent((View)hierarchicalChild);
                if (!child.some()) continue;
                Range childRange = ((AbstractNodeEvent)child.get()).getVerticalRange();
                result.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new ReparentExecutionOperation((AbstractNodeEvent)child.get(), futureParent)));
                result.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new SetVerticalRangeOperation((ISequenceEvent)child.get(), childRange)));
            }
        }
        if (result.isEmpty()) {
            return IdentityCommand.INSTANCE;
        }
        return result;
    }
}

