/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.ObservableMap;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.el.DeferredFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;
import org.eclipse.sapphire.util.CollectionsUtil;

public class FunctionContext {
    @Text(value="Property \"{0}\" is undefined.")
    private static LocalizableText undefinedPropertyMessage;
    @Text(value="Property \"{0}\" is undefined for {1} objects.")
    private static LocalizableText undefinedPropertyMessageExt;
    @Text(value="Cannot read properties from null object.")
    private static LocalizableText cannotReadPropertiesFromNull;
    @Text(value="Index {0} is outside the bounds of the collection.")
    private static LocalizableText indexOutOfBounds;

    static {
        LocalizableText.init(FunctionContext.class);
    }

    public FunctionResult property(final Object element, final String name) {
        if (element == null) {
            throw new FunctionException(cannotReadPropertiesFromNull.text());
        }
        if (element instanceof Map) {
            Function f;
            final Map map = (Map)element;
            if (map instanceof ObservableMap) {
                final ObservableMap observable = (ObservableMap)map;
                f = new Function(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public FunctionResult evaluate(FunctionContext context) {
                        return new FunctionResult(this, context){
                            private Listener listener;

                            @Override
                            protected void init() {
                                this.listener = new Listener(){

                                    @Override
                                    public void handle(Event event) {
                                        this.refresh();
                                    }
                                };
                                observable.attach(this.listener);
                            }

                            @Override
                            protected Object evaluate() {
                                return CollectionsUtil.findIgnoringCase(observable, name);
                            }

                            @Override
                            public void dispose() {
                                super.dispose();
                                observable.detach(this.listener);
                            }
                        };
                    }
                };
            } else {
                f = new Function(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public FunctionResult evaluate(FunctionContext context) {
                        return new FunctionResult(this, context){

                            @Override
                            protected Object evaluate() {
                                return CollectionsUtil.findIgnoringCase(map, name);
                            }
                        };
                    }
                };
            }
            f.init(new Function[0]);
            return f.evaluate(this);
        }
        try {
            final int index = Integer.parseInt(name);
            if (element instanceof List) {
                final List list = (List)element;
                Function f = new Function(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public FunctionResult evaluate(FunctionContext context) {
                        return new FunctionResult(this, context){

                            @Override
                            protected Object evaluate() {
                                if (index >= 0 && index < list.size()) {
                                    return list.get(index);
                                }
                                throw new FunctionException(indexOutOfBounds.format(index));
                            }
                        };
                    }
                };
                f.init(new Function[0]);
                return f.evaluate(this);
            }
            if (element.getClass().isArray()) {
                Function f = new Function(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public FunctionResult evaluate(FunctionContext context) {
                        return new FunctionResult(this, context){

                            @Override
                            protected Object evaluate() {
                                if (index >= 0 && index < Array.getLength(element)) {
                                    return Array.get(element, index);
                                }
                                throw new FunctionException(indexOutOfBounds.format(index));
                            }
                        };
                    }
                };
                f.init(new Function[0]);
                return f.evaluate(this);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (element == this) {
            if (!SapphireModelingExtensionSystem.functions(name, 0).isEmpty()) {
                DeferredFunction f = new DeferredFunction(name);
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
        } else if (!SapphireModelingExtensionSystem.functions(name, 1).isEmpty()) {
            DeferredFunction f = new DeferredFunction(name);
            f.init(Literal.create(element));
            return ((Function)f).evaluate(this);
        }
        if (element == this) {
            throw new FunctionException(undefinedPropertyMessage.format(name));
        }
        Class<?> cl = element.getClass();
        String type = cl.isArray() ? String.valueOf(cl.getComponentType().getName()) + "[]" : cl.getName();
        throw new FunctionException(undefinedPropertyMessageExt.format(name, type));
    }

    public LocalizationService getLocalizationService() {
        return SourceLanguageLocalizationService.INSTANCE;
    }
}

