/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.internal.proxy.core.Activator;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.ProxyProcess;
import org.eclipse.remote.internal.proxy.core.commands.ExecCommand;
import org.eclipse.remote.internal.proxy.core.messages.Messages;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class ProxyProcessBuilder
extends AbstractRemoteProcessBuilder {
    private final ProxyConnection proxyConnection;
    private Map<String, String> remoteEnv;

    public ProxyProcessBuilder(ProxyConnection connection, List<String> command) {
        super(connection.getRemoteConnection(), command);
        this.proxyConnection = connection;
        IRemoteFileService fileSvc = (IRemoteFileService)this.proxyConnection.getRemoteConnection().getService(IRemoteFileService.class);
        if (fileSvc != null) {
            this.directory(fileSvc.getResource(this.proxyConnection.getWorkingDirectory()));
        }
    }

    public ProxyProcessBuilder(ProxyConnection connection, String ... command) {
        this(connection, Arrays.asList(command));
    }

    public Map<String, String> environment() {
        if (this.remoteEnv == null) {
            this.remoteEnv = new HashMap<String, String>(this.proxyConnection.getEnv());
        }
        return this.remoteEnv;
    }

    public int getSupportedFlags() {
        return 0;
    }

    public IRemoteProcess start(int flags) throws IOException {
        final List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        final HashMap<String, String> env = new HashMap<String, String>();
        if (this.remoteEnv != null) {
            env.putAll(this.remoteEnv);
        }
        final boolean append = (flags & 3) != 0 || this.remoteEnv == null;
        final ProxyConnection conn = (ProxyConnection)this.getRemoteConnection().getService(ProxyConnection.class);
        if (conn == null) {
            throw new IOException(Messages.ProxyProcessBuilder_0);
        }
        final StreamChannel chanStdIO = conn.openChannel();
        final StreamChannel chanStdErr = conn.openChannel();
        final StreamChannel chanControl = conn.openChannel();
        Job job = new Job("process executor"){

            protected IStatus run(IProgressMonitor monitor) {
                ExecCommand cmd = new ExecCommand(conn, cmdArgs, env, ProxyProcessBuilder.this.directory().toURI().getPath(), ProxyProcessBuilder.this.redirectErrorStream(), append, chanStdIO.getId(), chanStdErr.getId(), chanControl.getId());
                try {
                    cmd.getResult(monitor);
                }
                catch (ProxyException e) {
                    return new Status(4, Activator.getUniqueIdentifier(), e.getMessage());
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        if (!job.getResult().isOK()) {
            throw new IOException(job.getResult().getMessage());
        }
        ProxyProcess proc = new ProxyProcess(this.getRemoteConnection(), (IRemoteProcessBuilder)this, chanStdIO, chanStdErr, chanControl);
        return proc;
    }
}

