/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.ui.launching.DirectionalMainTab;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public abstract class QVTDirectionalMainTab<TX extends Transformation>
extends DirectionalMainTab<TX> {
    private void gatherOutputModels(@NonNull List<TypedModel> outputModels, @NonNull TypedModel typedModel) {
        if (!outputModels.contains(typedModel)) {
            outputModels.add(typedModel);
            for (TypedModel anotherTypedModel : typedModel.getDependsOn()) {
                if (anotherTypedModel == null) continue;
                this.gatherOutputModels(outputModels, anotherTypedModel);
            }
        }
    }

    @Override
    protected void updateDirection(@NonNull TX transformation) {
        HashSet<@NonNull String> enforceableDirectionNames = new HashSet<String>();
        for (TypedModel typedModel : QVTbaseUtil.getEnforceableTypedModels(transformation)) {
            String name = typedModel.getName();
            if (name == null) continue;
            enforceableDirectionNames.add(name);
        }
        this.setDirections(enforceableDirectionNames);
    }

    @Override
    protected void updateGroups(@NonNull TX transformation, @NonNull Map<@NonNull String, @Nullable String> oldInputsMap, @NonNull Map<@NonNull String, @Nullable String> newInputsMap, @NonNull Map<@NonNull String, @Nullable String> oldOutputsMap, @NonNull Map<@NonNull String, @Nullable String> newOutputsMap, @NonNull Map<@NonNull String, @Nullable String> intermediateMap) {
        String name;
        super.updateGroups(transformation, oldInputsMap, newInputsMap, oldOutputsMap, newOutputsMap, intermediateMap);
        HashSet<@NonNull TypedModel> inputs = new HashSet<TypedModel>();
        HashSet<@NonNull TypedModel> outputs = new HashSet<TypedModel>();
        String directionName = this.directionCombo.getText();
        ArrayList<@NonNull TypedModel> inputModels = new ArrayList<TypedModel>();
        ArrayList<@NonNull TypedModel> outputModels = new ArrayList<TypedModel>();
        for (TypedModel typedModel : ClassUtil.nullFree((EList)transformation.getModelParameter())) {
            if (!ClassUtil.safeEquals((Object)typedModel.getName(), (Object)directionName)) continue;
            this.gatherOutputModels(outputModels, typedModel);
        }
        for (TypedModel inputModel : ClassUtil.nullFree((EList)transformation.getModelParameter())) {
            if (inputModel.getName() == null) continue;
            inputModels.add(inputModel);
        }
        inputModels.removeAll(outputModels);
        String modeName = this.modeCombo.getText();
        if ("CHECK".equals(modeName)) {
            for (TypedModel inputModel : inputModels) {
                if (!inputs.add(inputModel) || (name = inputModel.getName()) == null) continue;
                newInputsMap.put(name, null);
            }
            for (TypedModel outputModel : outputModels) {
                if (!outputs.add(outputModel) || (name = outputModel.getName()) == null) continue;
                oldOutputsMap.put(name, null);
            }
        } else if ("ENFORCE - CREATE".equals(modeName)) {
            for (TypedModel inputModel : inputModels) {
                if (!inputs.add(inputModel) || (name = inputModel.getName()) == null) continue;
                newInputsMap.put(name, null);
            }
            for (TypedModel outputModel : outputModels) {
                if (!outputs.add(outputModel) || (name = outputModel.getName()) == null) continue;
                newOutputsMap.put(name, null);
            }
        }
        if ("ENFORCE - UPDATE".equals(modeName)) {
            for (TypedModel inputModel : inputModels) {
                if (!inputs.add(inputModel) || (name = inputModel.getName()) == null) continue;
                oldInputsMap.put(name, null);
                newInputsMap.put(name, null);
            }
            for (TypedModel outputModel : outputModels) {
                if (!outputs.add(outputModel) || (name = outputModel.getName()) == null) continue;
                oldOutputsMap.put(name, null);
                newOutputsMap.put(name, null);
            }
        }
    }
}

