/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitElementManager;
import org.eclipse.php.phpunit.model.elements.PHPUnitTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;
import org.eclipse.php.phpunit.model.providers.PHPUnitElementTreeContentProvider;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.php.phpunit.ui.view.TestLabelProvider;
import org.eclipse.php.phpunit.ui.view.actions.OpenTestAction;
import org.eclipse.php.phpunit.ui.view.actions.RerunAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.PageBook;

public class TestViewer {
    private LinkedList<Object> fAutoClose;
    private Set<Object> fAutoExpand;
    private PHPUnitTestCase fAutoScrollTarget;
    private final FailuresOnlyFilter fFailuresOnlyFilter = new FailuresOnlyFilter();
    private final Image fHierarchyIcon;
    private Set<PHPUnitElement> fNeedUpdate;
    private IPostSelectionProvider fSelectionProvider;
    private PHPUnitElementTreeContentProvider fTreeContentProvider;
    private boolean fTreeHasFilter;
    private boolean fTreeNeedsRefresh;
    private TreeViewer fTreeViewer;
    private PageBook fViewerbook;
    private PHPUnitTestGroup testRoot;
    private final PHPUnitView view;

    public TestViewer(Composite parent, PHPUnitView runner) {
        this.view = runner;
        this.fHierarchyIcon = PHPUnitPlugin.createImage("obj16/testhier.png");
        parent.addDisposeListener(e -> this.disposeIcons());
        this.createTestViewers(parent);
        this.registerViewersRefresh();
        this.initContextMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoScrollInUI() {
        PHPUnitTestGroup parent;
        if (!this.view.isAutoScroll()) {
            this.clearAutoExpand();
            this.fAutoClose.clear();
            return;
        }
        TestViewer testViewer = this;
        synchronized (testViewer) {
            for (PHPUnitTestGroup pHPUnitTestGroup : this.fAutoExpand) {
                this.fTreeViewer.setExpandedState((Object)pHPUnitTestGroup, true);
            }
            this.clearAutoExpand();
        }
        PHPUnitTestCase current = this.fAutoScrollTarget;
        this.fAutoScrollTarget = null;
        PHPUnitTestGroup pHPUnitTestGroup = parent = current == null ? null : (PHPUnitTestGroup)this.fTreeContentProvider.getParent(current);
        if (this.fAutoClose.isEmpty() || !this.fAutoClose.getLast().equals(parent)) {
            ListIterator<Object> listIterator = this.fAutoClose.listIterator(this.fAutoClose.size());
            while (listIterator.hasPrevious()) {
                PHPUnitTestGroup previousAutoOpened = (PHPUnitTestGroup)listIterator.previous();
                if (previousAutoOpened.equals(parent)) break;
                if (previousAutoOpened.getStatus() != 1) continue;
                listIterator.remove();
                this.fTreeViewer.collapseToLevel((Object)previousAutoOpened, -1);
            }
            while (parent != null && !this.testRoot.equals(parent) && !this.fTreeViewer.getExpandedState((Object)parent)) {
                this.fAutoClose.add(parent);
                parent = (PHPUnitTestGroup)this.fTreeContentProvider.getParent(parent);
            }
        }
        if (current != null) {
            this.fTreeViewer.reveal((Object)current);
        }
    }

    private synchronized void clearAutoExpand() {
        this.fAutoExpand.clear();
    }

    private void clearUpdateAndExpansion() {
        this.fNeedUpdate = new LinkedHashSet<PHPUnitElement>();
        this.fAutoClose = new LinkedList();
        this.fAutoExpand = new HashSet<Object>();
    }

    public void collapseAll() {
        this.fTreeViewer.collapseAll();
        this.fTreeViewer.refresh();
    }

    private void createTestViewers(Composite parent) {
        this.fViewerbook = new PageBook(parent, 0);
        this.fTreeViewer = new TreeViewer((Composite)this.fViewerbook, 516);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeContentProvider = new PHPUnitElementTreeContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TestLabelProvider(this.view));
        this.fSelectionProvider = new SelectionProviderMediator(new StructuredViewer[]{this.fTreeViewer}, (StructuredViewer)this.fTreeViewer);
        this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)new TestSelectionListener());
        this.fTreeViewer.addDoubleClickListener(event -> this.handleDefaultSelected((IStructuredSelection)event.getSelection()));
        this.fViewerbook.showPage((Control)this.fTreeViewer.getTree());
    }

    void disposeIcons() {
        this.fHierarchyIcon.dispose();
    }

    public void expandAll() {
        this.fTreeViewer.expandAll();
        this.fTreeViewer.refresh();
    }

    private StructuredViewer getActiveViewer() {
        return this.fTreeViewer;
    }

    private boolean getActiveViewerHasFilter() {
        return this.fTreeHasFilter;
    }

    private boolean getActiveViewerNeedsRefresh() {
        return this.fTreeNeedsRefresh;
    }

    private IType getClass(String className, String fileName) {
        IProject project = this.view.getProject();
        IType[] classes = PHPModelAccess.getDefault().findTypes(className, ISearchEngine.MatchRule.EXACT, 0, 0, SearchEngine.createSearchScope((IModelElement)DLTKCore.create((IProject)project)), null);
        if (classes != null && classes.length > 0) {
            return classes[0];
        }
        return null;
    }

    private PHPUnitTestCase getNextChildFailure(PHPUnitTestGroup root, boolean showNext) {
        ArrayList<PHPUnitTest> children = new ArrayList<PHPUnitTest>(root.getChildren());
        if (!showNext) {
            Collections.reverse(children);
        }
        for (PHPUnitTest child : children) {
            if (child.getStatus() <= 1) continue;
            if (child instanceof PHPUnitTestCase) {
                return (PHPUnitTestCase)child;
            }
            return this.getNextChildFailure((PHPUnitTestGroup)child, showNext);
        }
        return null;
    }

    private PHPUnitElement getNextFailure(PHPUnitElement selected, boolean showNext) {
        PHPUnitTestCase nextChild;
        if (selected instanceof PHPUnitTestGroup && (nextChild = this.getNextChildFailure((PHPUnitTestGroup)selected, showNext)) != null) {
            return nextChild;
        }
        return this.getNextFailureSibling(selected, showNext);
    }

    private PHPUnitTestCase getNextFailureSibling(PHPUnitElement current, boolean showNext) {
        int nextIndex;
        PHPUnitTestGroup parent = (PHPUnitTestGroup)current.getParent();
        if (parent == null) {
            return null;
        }
        Set<PHPUnitTest> children = parent.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList<PHPUnitTest> siblings = new ArrayList<PHPUnitTest>(children);
        if (!showNext) {
            Collections.reverse(siblings);
        }
        int i = nextIndex = siblings.indexOf(current) + 1;
        while (i < siblings.size()) {
            PHPUnitTest sibling = (PHPUnitTest)siblings.get(i);
            if (sibling.getStatus() > 1) {
                if (sibling instanceof PHPUnitTestCase) {
                    return (PHPUnitTestCase)sibling;
                }
                return this.getNextChildFailure((PHPUnitTestGroup)sibling, showNext);
            }
            ++i;
        }
        return this.getNextFailureSibling(parent, showNext);
    }

    public Control getTestViewerControl() {
        return this.fViewerbook;
    }

    void handleDefaultSelected(IStructuredSelection selection) {
        OpenTestAction action;
        if (selection.isEmpty()) {
            return;
        }
        PHPUnitTest test = (PHPUnitTest)selection.getFirstElement();
        if (test instanceof PHPUnitTestGroup) {
            action = new OpenTestAction(null, this.view, test.getName(), test.getLocalFile(), test.getLine());
        } else if (test instanceof PHPUnitTestCase) {
            PHPUnitTestCase testCase = (PHPUnitTestCase)test;
            action = new OpenTestAction(null, this.view, ((PHPUnitTestGroup)testCase.getParent()).getName(), testCase.getLocalFile(), testCase.getLine(), testCase.getName());
        } else {
            throw new IllegalStateException(String.valueOf(test));
        }
        if (action.isEnabled()) {
            action.run();
        }
    }

    void handleMenuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectionProvider.getSelection();
        if (!selection.isEmpty()) {
            String testLabel;
            PHPUnitTest test = (PHPUnitTest)selection.getFirstElement();
            String className = testLabel = test.getName();
            String fileName = test.getLocalFile();
            int lineNumber = test.getLine();
            if (test instanceof PHPUnitTestGroup) {
                manager.add((IAction)new OpenTestAction(null, this.view, testLabel, fileName, lineNumber));
                manager.add((IContributionItem)new Separator());
                IType phpClass = this.getClass(className, fileName);
                if (phpClass != null) {
                    manager.add((IAction)new RerunAction(this.view, test.getTestId(), phpClass, null, "run"));
                    manager.add((IAction)new RerunAction(this.view, test.getTestId(), phpClass, null, "debug"));
                }
            } else {
                String testMethodName = test.getName();
                PHPUnitTestGroup parent = (PHPUnitTestGroup)test.getParent();
                className = parent.getName();
                fileName = parent.getFile();
                lineNumber = parent.getLine();
                IType phpClass = this.getClass(className, fileName);
                if (phpClass != null) {
                    manager.add((IAction)new OpenTestAction(null, this.view, className, phpClass.getResource().getFullPath().toPortableString(), lineNumber, testMethodName));
                }
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.handleMenuAboutToShow(manager));
        this.view.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fSelectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)this.fViewerbook);
        this.fTreeViewer.getTree().setMenu(menu);
    }

    private boolean isShown(PHPUnitElement current) {
        return this.fFailuresOnlyFilter.select(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangesInUI() {
        if (this.view.isDisposed()) {
            return;
        }
        if (this.testRoot == null) {
            this.registerViewersRefresh();
            this.fTreeNeedsRefresh = false;
            this.fTreeViewer.setInput(null);
            return;
        }
        StructuredViewer viewer = this.getActiveViewer();
        if (viewer.getInput() != this.testRoot) {
            viewer.setInput((Object)this.testRoot);
        }
        viewer.refresh();
        if (this.getActiveViewerNeedsRefresh()) {
            this.clearUpdateAndExpansion();
            this.setActiveViewerRefreshed();
        } else {
            PHPUnitElement[] toUpdate;
            TestViewer testViewer = this;
            synchronized (testViewer) {
                toUpdate = this.fNeedUpdate.toArray(new PHPUnitElement[0]);
                this.fNeedUpdate.clear();
            }
            if (!this.fTreeNeedsRefresh && toUpdate.length > 0) {
                if (this.fTreeHasFilter) {
                    PHPUnitElement[] pHPUnitElementArray = toUpdate;
                    int n = toUpdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PHPUnitElement element = pHPUnitElementArray[n2];
                        this.updateElementInTree(element);
                        ++n2;
                    }
                } else {
                    HashSet<PHPUnitElement> toUpdateWithParents = new HashSet<PHPUnitElement>();
                    toUpdateWithParents.addAll(Arrays.asList(toUpdate));
                    PHPUnitElement[] pHPUnitElementArray = toUpdate;
                    int n = toUpdate.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PHPUnitElement element = pHPUnitElementArray[n3];
                        if (element != null) {
                            PHPUnitElement parent = element.getParent();
                            while (parent != null) {
                                toUpdateWithParents.add(parent);
                                parent = parent.getParent();
                            }
                        }
                        ++n3;
                    }
                    this.fTreeViewer.update(toUpdateWithParents.toArray(), null);
                }
            }
        }
        this.autoScrollInUI();
    }

    public synchronized void registerActiveSession(PHPUnitTestGroup testRoot) {
        if (this.testRoot != testRoot) {
            this.testRoot = testRoot;
            this.registerAutoScrollTarget(null);
            this.registerViewersRefresh();
        }
    }

    public void registerAutoScrollTarget(PHPUnitTestCase TestCase) {
        this.fAutoScrollTarget = TestCase;
    }

    public synchronized void registerFailedForAutoScroll(PHPUnitElement testRunInfo) {
        Object parent = this.fTreeContentProvider.getParent(testRunInfo);
        if (parent != null) {
            this.fAutoExpand.add(parent);
        }
    }

    public synchronized void registerTestAdded() {
        this.fTreeNeedsRefresh = true;
    }

    public synchronized void registerViewersRefresh() {
        this.fTreeNeedsRefresh = true;
        this.clearUpdateAndExpansion();
    }

    public synchronized void registerViewerUpdate(PHPUnitElement test) {
        if (test == null) {
            return;
        }
        this.fNeedUpdate.add(test);
    }

    public void selectFailure(boolean showNext) {
        IStructuredSelection selection = (IStructuredSelection)this.getActiveViewer().getSelection();
        PHPUnitElement selected = (PHPUnitElement)selection.getFirstElement();
        PHPUnitElement next = selected == null ? this.getNextChildFailure(this.testRoot, showNext) : this.getNextFailure(selected, showNext);
        if (next != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)next), true);
        }
    }

    public void selectFirstFailure() {
        PHPUnitTestCase firstFailure = this.getNextChildFailure(this.testRoot, true);
        if (firstFailure != null) {
            this.getActiveViewer().setSelection((ISelection)new StructuredSelection((Object)firstFailure), true);
        }
    }

    private void setActiveViewerHasFilter(boolean filter) {
        this.fTreeHasFilter = filter;
    }

    private void setActiveViewerRefreshed() {
        this.fTreeNeedsRefresh = false;
    }

    public synchronized void setShowFailuresOnly(boolean failuresOnly) {
        try {
            this.fViewerbook.setRedraw(false);
            StructuredViewer viewer = this.getActiveViewer();
            if (failuresOnly) {
                if (!this.getActiveViewerHasFilter()) {
                    this.setActiveViewerHasFilter(true);
                    if (this.getActiveViewerNeedsRefresh()) {
                        viewer.setInput(null);
                    }
                    viewer.addFilter((ViewerFilter)this.fFailuresOnlyFilter);
                }
            } else if (this.getActiveViewerHasFilter()) {
                this.setActiveViewerHasFilter(false);
                if (this.getActiveViewerNeedsRefresh()) {
                    viewer.setInput(null);
                }
                viewer.removeFilter((ViewerFilter)this.fFailuresOnlyFilter);
            }
            this.processChangesInUI();
        }
        finally {
            this.fViewerbook.setRedraw(true);
        }
    }

    private void updateElementInTree(PHPUnitElement test) {
        if (this.isShown(test)) {
            this.updateShownElementInTree(test);
        } else {
            PHPUnitElement current = test;
            do {
                if (this.fTreeViewer.testFindItem((Object)current) == null) continue;
                this.fTreeViewer.remove((Object)current);
            } while (!((current = current.getParent()) instanceof PHPUnitTestGroup) && !this.isShown(current));
            while (current != null && current != this.testRoot) {
                this.fTreeViewer.update((Object)current, null);
                current = current.getParent();
            }
        }
    }

    private void updateShownElementInTree(PHPUnitElement test) {
        if (test == null || test == this.testRoot) {
            return;
        }
        PHPUnitTestGroup parent = (PHPUnitTestGroup)test.getParent();
        if (parent == null) {
            return;
        }
        this.updateShownElementInTree(parent);
        if (this.fTreeViewer.testFindItem((Object)test) == null) {
            this.fTreeViewer.add((Object)parent, (Object)test);
        } else {
            this.fTreeViewer.update((Object)test, null);
        }
    }

    private final class FailuresOnlyFilter
    extends ViewerFilter {
        private FailuresOnlyFilter() {
        }

        public boolean select(PHPUnitElement testInfo) {
            if (testInfo instanceof PHPUnitTestGroup) {
                PHPUnitTestGroup testGroup = (PHPUnitTestGroup)testInfo;
                if (testGroup.getRunCount() > testGroup.getTotalCount()) {
                    return true;
                }
                if (testInfo == PHPUnitElementManager.getInstance().getRoot()) {
                    return true;
                }
            }
            return testInfo instanceof PHPUnitTest && ((PHPUnitTest)testInfo).getStatus() >= 4;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select((PHPUnitElement)element);
        }
    }

    private final class TestSelectionListener
    implements ISelectionChangedListener {
        private TestSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.handleSelected();
        }

        private void handleSelected() {
            IStructuredSelection selection = (IStructuredSelection)TestViewer.this.fSelectionProvider.getSelection();
            PHPUnitElement test = null;
            if (selection.size() == 1) {
                test = (PHPUnitElement)selection.getFirstElement();
            }
            TestViewer.this.view.handleTestSelected(test);
        }
    }
}

