/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.providers.DiffLine;

public class PHPUnitTestDiffTreeContentProvider
extends ArrayContentProvider
implements ITreeContentProvider {
    private String diff;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DiffLine) {
            return ((DiffLine)parentElement).getChildren().toArray();
        }
        ArrayList<DiffLine> results = new ArrayList<DiffLine>();
        if (parentElement instanceof PHPUnitTestCase) {
            this.getCaseChildren((PHPUnitTestCase)parentElement, results);
        }
        return results.toArray();
    }

    private void getCaseChildren(PHPUnitTestCase testCase, List<DiffLine> results) {
        PHPUnitTestException exception = testCase.getException();
        if (this.hasChildren(testCase)) {
            DiffLine testDiffLine = new DiffLine(exception.getMessage(), null);
            results.add(testDiffLine);
            String[] children = exception.getDiff().split("\n");
            Stack<DiffLine> parentStack = new Stack<DiffLine>();
            parentStack.push(testDiffLine);
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                DiffLine diffLine = new DiffLine(child, (DiffLine)parentStack.peek());
                if (child.endsWith(" Object (") || child.endsWith(" Array (")) {
                    parentStack.push(diffLine);
                } else if (")".equals(child.trim()) && parentStack.size() > 1) {
                    parentStack.pop();
                }
                ++n2;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof DiffLine) {
            return ((DiffLine)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof PHPUnitTestCase) {
            PHPUnitTestException exception = ((PHPUnitTestCase)element).getException();
            if (exception == null) {
                return false;
            }
            this.diff = exception.getDiff();
            return this.diff != null && !this.diff.isEmpty();
        }
        if (element instanceof DiffLine) {
            return !((DiffLine)element).getChildren().isEmpty();
        }
        return false;
    }

    public String getDiff() {
        return this.diff;
    }
}

